<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Backend\LanguageController;
use App\Http\Controllers\{
    PaymentController,
    LocationController,
    AdminAuthController
};
use App\Http\Controllers\Frontend\{
    HomeController,
    UserController,
    CheckoutController
};


if (file_exists(storage_path('installed'))) {
    // normal routes


Route::get('/admin/login', [AdminAuthController::class, 'index'])->name('admin.login');
Route::post('/admin/login', [AdminAuthController::class, 'login'])->name('admin.login.submit');
Route::get('/thank-you', [CheckoutController::class, 'thank_you'])->name('thank_you');
Route::controller(CheckoutController::class)->middleware(['auth'])->prefix('checkout')->group(function () {
    Route::get('/', 'index')->name('checkout.page');
    Route::post('/', 'checkout')->name('checkout.show');
});
Route::controller(HomeController::class)->group(function () {
    Route::get('/', 'index')->name('home.page');
    Route::get('/search', 'search')->name('home.search');
    Route::get('artworks/filter', 'artwork_filter')->name('artworks.filter');
    Route::get('artwork/{slug}', 'artwork_details')->name('artwork.details');
    Route::get('category/{slug}', 'category_page')->name('category.page');
    Route::get('artwork-tag/{slug}', 'tag_page')->name('tag.page');
    Route::get('/artists/{slug}', 'artist_details')->name('artists.details');
    Route::get('blog/category/{slug}', 'blog_category')->name('blog.category.page');
    Route::get('blog/{slug}', 'blog_details')->name('blog.details');
    Route::post('/submit/contact', 'contact_submit')->name('contact.submit');
    Route::post('/submit/notify', 'notify_submit')->name('notify.submit');
    Route::post('comment', 'blog_comment')->name('blog.comment');
    Route::post('/subscribe', 'newsletter_subscribe')->name('newsletter.subscribe');
    Route::get('/certificate/{slug}', 'certificate')->name('home.certificate');
    Route::get('/{slug}', 'loadPagesContent')->name('all_pages');
});
Route::post('/changelanguage', [LanguageController::class, 'changeLanguage'])->name('language.change');
// Get State and City
Route::post('/location/get/state', [LocationController::class, 'get_state'])->name('location.get.state');
Route::post('/location/get/city', [LocationController::class, 'get_city'])->name('location.get.city');

// Profile
Route::middleware(['auth', 'verified'])->prefix('user')->name('user.')->controller(UserController::class)->group(function () {
    Route::get('/dashboard', 'index')->name('dashboard');
    Route::get('/profile', 'profile')->name('profile');
    Route::patch('/profile/update', 'profile_update')->name('profile.update');
    Route::get('/bidding', 'bidding')->name('bidding');
    Route::get('/orders', 'orders')->name('orders');
    Route::get('/wishlist', 'wishlist')->name('wishlist');
    Route::get('/deposit', 'deposit')->name('deposit');
    Route::post('/panel/status', 'panel_status')->name('panel.status');
    Route::get('/order/{id}/details', 'order_details')->name('order.details');
    Route::post('/wishlist/store', 'wishlist_store')->name('wishlist.store');
    Route::delete('/wishlist/{id}/destroy', 'wishlist_destroy')->name('wishlist.destroy');
});

// Profile
Route::middleware(['auth', 'verified'])->prefix('payment')->name('payment.')->group(function () {
    Route::post('/process', [PaymentController::class, 'process'])->name('process');
    Route::get('/error', [PaymentController::class, 'paymentError'])->name('error');
    Route::get('/success/paypal', [PaymentController::class, 'paypalSuccess'])->name('success.paypal');
    Route::post('/success/razorpay', [PaymentController::class, 'razorpaySuccess'])->name('success.razorpay');
});

} else {
    Route::get('{any}', fn() => redirect('/install'))->where('any', '.*');
}
