<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LocationController;
use App\Http\Controllers\Backend\{
    ProfileController,
    HomeController,
    LanguageController,
    BackendSettingController,
    FrontendSettingController,
    BlogCategoryController,
    BlogController,
    CustomerController,
    ArtGalleryController,
    ArtistController,
    CategoryController,
    EmailTemplateController,
    ArtworkController,
    MenuController,
    PageController,
    ContactController,
    PaymentMethodController,
    OrderController,
    WinnerController,
    DepositController,
    WithdrawController,
    SupportTicketController,
    TransactionController
};

//dashboard
Route::get('/', [HomeController::class, 'index'])->name('index');
Route::get('cache-clear', [HomeController::class, 'cacheClear'])->name('cache.clear');
// Profile
Route::prefix('profile')->name('profile.')->group(function () {
    Route::get('/', [ProfileController::class, 'edit'])->name('edit');
    Route::patch('/', [ProfileController::class, 'update'])->name('update');
    Route::get('/payment', [ProfileController::class, 'payment'])->name('payment');
    Route::patch('/payment/{id}/update', [ProfileController::class, 'payment_update'])->name('payment.update');
});

// Language
Route::prefix('languages')->group(function () {
    Route::resource('/', LanguageController::class)
        ->parameters(['' => 'id'])
        ->names('languages')
        ->except(['show']);

    Route::post('change/status', [LanguageController::class, 'changeStatus'])->name('languages.change.status');
    Route::get('{id}/translations', [LanguageController::class, 'translations'])->name('languages.translations');
    Route::post('{id}/key_value_store', [LanguageController::class, 'key_value_store'])->name('languages.key_value_store');
});

// Blog Category 
Route::prefix('blogs/categories')->group(function () {
    Route::resource('/', BlogCategoryController::class)
        ->parameters(['' => 'id'])
        ->names('blogs.categories')
        ->except(['show']);

    Route::post('change/status', [BlogCategoryController::class, 'changeStatus'])->name('blogs.categories.change.status');
});

// Blogs
Route::prefix('blogs')->group(function () {
    Route::resource('/', BlogController::class)
        ->parameters(['' => 'id'])
        ->names('blogs')
        ->except(['show']);

    Route::post('change/status', [BlogController::class, 'changeStatus'])->name('blogs.change.status');
});

// Location
Route::controller(LocationController::class)->group(function () {
    // Country (can be handled via resource)
    Route::get('/locations', 'index')->name('locations.index'); // custom listing
    Route::post('/country/store', 'store')->name('country.store');
    Route::get('country/{id}/edit', 'edit')->name('country.edit');
    Route::patch('country/{id}/update', 'update')->name('country.update');
    Route::delete('country/{id}/destroy', 'destroy')->name('country.delete');

    // State
    Route::prefix('state')->group(function () {
        Route::get('{id}/create', 'state_create')->name('state.create');
        Route::post('{id}/store', 'state_store')->name('state.store');
        Route::get('{id}/edit', 'state_edit')->name('state.edit');
        Route::patch('{id}/update', 'state_update')->name('state.update');
        Route::delete('{id}/destroy', 'state_destroy')->name('state.delete');
    });

    // City
    Route::prefix('city')->group(function () {
        Route::get('{id}/create', 'city_create')->name('city.create');
        Route::post('{id}/store', 'city_store')->name('city.store');
        Route::get('{id}/edit', 'city_edit')->name('city.edit');
        Route::patch('{id}/update', 'city_update')->name('city.update');
        Route::delete('{id}/destroy', 'city_destroy')->name('city.delete');
    });
});
// Customer
Route::prefix('customer')->group(function () {
    Route::resource('/', CustomerController::class)
        ->parameters(['' => 'id'])
        ->names('customer');

    Route::get('/login/{id}', [CustomerController::class, 'login'])->name('customer.login');
    Route::post('/change/status', [CustomerController::class, 'changeStatus'])->name('customer.change.status');
});

// Art Gallery
Route::prefix('art-gallery')->group(function () {
    Route::resource('/', ArtGalleryController::class)
        ->parameters(['' => 'id'])
        ->names('art-gallery');

    Route::get('/login/{id}', [ArtGalleryController::class, 'login'])->name('art-gallery.login');
    Route::post('/change/status', [ArtGalleryController::class, 'changeStatus'])->name('art-gallery.change.status');
});

// Backend Setting
Route::prefix('backend/settings')->controller(BackendSettingController::class)->group(function () {
    Route::get('/', 'index')->name('backend.setting');
    Route::post('store', 'store')->name('backend.settings.store');
    Route::post('testmail', 'sendTestMail')->name('backend.testmail');
});

// Frontend Settings
Route::prefix('frontend/settings')->controller(FrontendSettingController::class)->group(function () {
    Route::get('/', 'index')->name('frontend.setting');
    Route::post('/store', 'store')->name('frontend.settings.store');
});

// Artists
Route::prefix('artist')->group(function () {
    Route::resource('/', ArtistController::class)
        ->parameters(['' => 'id'])
        ->names('artist')
        ->except(['show']);

    Route::post('change/status', [ArtistController::class, 'changeStatus'])->name('artist.change.status');
    Route::patch('change/{id}/featured', [ArtistController::class, 'changeFeatured'])->name('artist.change.featured');
});

// Email Template 
Route::prefix('email/template')->group(function () {
    Route::resource('/', EmailTemplateController::class)
        ->parameters(['' => 'id'])
        ->names('email.template')
        ->except(['show','create','store','destroy']);
});

// Artwork Category 
Route::prefix('artwork/categories')->group(function () {
    Route::resource('/', CategoryController::class)
        ->parameters(['' => 'id'])
        ->names('artwork.categories')
        ->except(['show']);

    Route::post('change/status', [CategoryController::class, 'changeStatus'])->name('artwork.categories.change.status');
});

// Artwork 
Route::prefix('artworks')->group(function () {
    Route::resource('/', ArtworkController::class)
        ->parameters(['' => 'id'])
        ->names('artworks')
        ->except(['show']);

    Route::post('change/status', [ArtworkController::class, 'changeStatus'])->name('artworks.change.status');
    Route::patch('/{id}/approve', [ArtworkController::class, 'approve'])->name('artworks.approve');
    Route::post('/gallery/remove', [ArtworkController::class, 'gallery_remove'])->name('artworks.gallery.remove');
    Route::post('/get/artists', [ArtworkController::class, 'get_artists'])->name('artworks.get.artists');
    Route::get('/{id}/details', [ArtworkController::class, 'details'])->name('artworks.details');
    Route::post('/{id}/closed', [ArtworkController::class, 'closed'])->name('artworks.bids.closed');
    Route::patch('/{id}/approve', [ArtworkController::class, 'approve'])->name('artworks.approve');
    Route::delete('/{id}/winner', [ArtworkController::class, 'winner'])->name('artworks.bids.winner');
});

// Menu
Route::prefix('menu')->controller(MenuController::class)->group(function () {
    Route::get('manage/{id?}', 'menu')->name('menu.list');
    Route::get('add-menu', 'addToMenu')->name('add.menu');
    Route::get('menu-item', 'storeMenuItem')->name('menu.item');
    Route::get('menu-item-edit/{id}', 'editMenuItem')->name('menu.item.edit');
    Route::post('menu-item-update', 'updateMenuItem')->name('menu.item.update');
    Route::get('menu-item-delete/{id}', 'deleteMenuItem')->name('menu.item.delete');
});
// page
Route::prefix('pages')->controller(PageController::class)->group(function () {
    Route::resource('/', PageController::class)
        ->parameters(['' => 'id'])
        ->names('pages')
        ->except(['create','show']);

    Route::post('/change/status', 'changeStatus')->name('pages.change.status');
    Route::get('add-widget-page/{slug}', 'widgetAddedToPage')->name('pages.add.widget');
    Route::post('widget-save-by-page', 'widgetUpdateByPage')->name('pages.widget.save');
    Route::get('/widget-status/{id}', 'widgetStatusChange')->name('pages.widget.status.change');
    Route::get('widget-delete-by-page/{id}', 'widgetDeleteByPage')->name('pages.widget.delete');
    Route::get('/widget-sorted-by-page', 'widgetSortedByPage')->name('pages.widget.storted');
    Route::post('/image-upload-file', 'imageUpload')->name('pages.image.upload');
});
// conatct 
Route::prefix('contacts')->name('contacts.')->controller(ContactController::class)->group(function () {
    Route::get('/', 'index')->name('index');
    Route::get('/show/{id}', 'show')->name('show');
    Route::delete('/destroy/{id}', 'destroy')->name('destroy');
});
// Payment Methods 
Route::prefix('payment/methods')->name('payment.methods.')->controller(PaymentMethodController::class)->group(function () {
    Route::get('/', 'index')->name('index');
    Route::post('/edit', 'edit')->name('edit');
    Route::post('/update', 'update')->name('update');
});
// order
Route::prefix('order')->name('order.')->controller(OrderController::class)->group(function () {
    Route::post('change/status', 'changeStatus')->name('change.status');
    Route::get('{id}/details', 'details')->name('details');
    Route::get('/', 'index')->name('list');
});
//bidding
Route::prefix('bidding')->name('bidding.')->controller(OrderController::class)->group(function () {
    Route::get('/', 'bidding')->name('list');
    Route::get('/{id}/details', 'details')->name('details');
});

// Winner
Route::prefix('winner')->controller(WinnerController::class)->group(function () {
    Route::get('/', 'index')->name('winner.list');
});

// Deposits
Route::get('/deposits', [DepositController::class, 'index'])->name('deposits.list');
// Withdraw
Route::prefix('withdraw')->controller(WithdrawController::class)->group(function () {
    Route::get('/', 'index')->name('withdraw.list');
    Route::get('/request', 'withdraw_new')->name('withdraw.new');
    Route::post('/request', 'withdraw_request')->name('withdraw.request');
    Route::get('/details/{id}', 'details')->name('withdraw.details');
    Route::patch('/status/{id}', 'status')->name('withdraw.status.change');
});

// Support Ticket
Route::prefix('supports')->controller(SupportTicketController::class)->group(function () {
    Route::resource('/', SupportTicketController::class)
        ->parameters(['' => 'id'])
        ->names('supports')
        ->except(['show']);
    Route::get('close-ticket/{supportId}', 'closeTicket')->name('supports.close.ticket');
});

// transaction
Route::get('/transactions', [TransactionController::class, 'index'])->name('transactions.list');
