@if ($paginator->hasPages())
    <div class="pagination-area">
        <div class="pagination-text">
            <span>
                Showing {{ $paginator->firstItem() }} to {{ $paginator->lastItem() }} of {{ $paginator->total() }} entries
            </span>
        </div>
        <div class="pagination-button">
            <ul>
                {{-- Previous Page Link --}}
                @if ($paginator->onFirstPage())
                    <li><span>Previous</span></li>
                @else
                    <li><a href="{{ $paginator->previousPageUrl() }}">Previous</a></li>
                @endif

                {{-- Pagination Elements --}}
                @foreach ($paginator->getUrlRange(1, $paginator->lastPage()) as $page => $url)
                    @if ($page == $paginator->currentPage())
                        <li><span class="active">{{ $page }}</span></li>
                    @else
                        <li><a href="{{ $url }}">{{ $page }}</a></li>
                    @endif
                @endforeach

                {{-- Next Page Link --}}
                @if ($paginator->hasMorePages())
                    <li><a href="{{ $paginator->nextPageUrl() }}">Next</a></li>
                @else
                    <li><span>Next</span></li>
                @endif
            </ul>
        </div>
    </div>
@endif
