@if ($paginator->hasPages())
<div class="row">
    <div class="col-lg-12">
        <div class="page-navigation-area d-flex flex-wrap align-items-center justify-content-between">
            @if ($paginator->onFirstPage())
            <div class="prev-next-btn">
                <a href="#" onclick="return false;">
                    <svg width="7" height="14" viewBox="0 0 7 14" xmlns="http://www.w3.org/2000/svg">
                        <path d="M0 7.00008L7 0L2.54545 7.00008L7 14L0 7.00008Z" />
                    </svg>
                    prev
                </a>
            </div>
            @else
            <div class="prev-next-btn">
                <a href="{{ $paginator->previousPageUrl() }}">
                    <svg width="7" height="14" viewBox="0 0 7 14" xmlns="http://www.w3.org/2000/svg">
                        <path d="M0 7.00008L7 0L2.54545 7.00008L7 14L0 7.00008Z" />
                    </svg>
                    prev
                </a>
            </div>
            @endif
            <ul class="pagination">
                @foreach ($elements as $element)
                @if (is_string($element))
                <li class="disabled"><a href="#">{{ $element }}</a></li>
                @endif
                @if (is_array($element))
                    @foreach ($element as $page => $url)
                        @if ($page == $paginator->currentPage())
                        <li class="active"><a href="#" onclick="return false;">{{ $page }}</a></li>
                        @else
                            <li><a href="{{ $url }}">{{ $page }}</a></li>
                        @endif
                    @endforeach
                @endif
                @endforeach
            </ul>
            @if ($paginator->hasMorePages())
            <div class="prev-next-btn">
                <a href="{{ $paginator->nextPageUrl() }}">
                    next
                    <svg width="7" height="14" viewBox="0 0 7 14" xmlns="http://www.w3.org/2000/svg">
                        <path d="M7 7.00008L0 0L4.45455 7.00008L0 14L7 7.00008Z" />
                    </svg>
                </a>
            </div>
            @else
            <div class="prev-next-btn disabled">
                <a href="#" onclick="return false;">
                    next
                    <svg width="7" height="14" viewBox="0 0 7 14" xmlns="http://www.w3.org/2000/svg">
                        <path d="M7 7.00008L0 0L4.45455 7.00008L0 14L7 7.00008Z" />
                    </svg>
                </a>
            </div>
            @endif
        </div>
    </div>
</div>
@endif