<div class="modal specification-modal fade" id="finalPaymentModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="finalPaymentModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                @if (paymentMethods()->count() > 1)
                <div class="currency-icon">
                    <span><i class="bi bi-currency-dollar"></i></span>
                </div>
                <h4 class="modal-title" id="finalPaymentModalLabel">{{ translate('Bid Final Payment') }}</h4>
                @endif
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><i class="bi bi-x"></i></button>
            </div>
            @if (paymentMethods()->count() > 1)
            <div class="modal-body">
                <form action="{{route('payment.process')}}" method="POST" class="modal-require-validation" data-modal-stripe-publishable-key="{{ get_payment_method('stripe_key') }}" id="modal-payment-form">
                    @csrf
                    <input type="hidden" name="artwork_id" value="{{ $bidSingle->artwork_id }}">
                    <input type="hidden" name="current_url" value="{{ URL::full() }}">
                    <div class="choose-payment-mathord">
                        <h5>{{ translate('Select Your Payment Method') }}</h5>
                        <div class="payment-option mb-3">
                            <div class="payment-method-section d-flex gap-3 align-items-center flex-wrap">
                                @foreach (paymentMethods() as $payment_method)
                                <div class="custom-control custom-radio custom-control-inline {{$payment_method->slug}}">
                                    <input type="radio" id="payment_method_modal{{$payment_method->id}}" name="payment_method" class="custom-control-input" value="{{$payment_method->slug}}" {{$payment_method->slug == 'wallet' ?
                                    'checked' : ''}}>
                                    <label class="custom-control-label" for="payment_method_modal{{$payment_method->id}}">
                                        @if ($payment_method->logo)
                                        <img src="{{ uploaded_asset($payment_method->logo) }}" alt="{{$payment_method->name}}" height="20">
                                        @else
                                        {{$payment_method->name}}
                                        @endif
                                        <div class="checked {{$payment_method->slug == 'wallet' ? 'd-block' : 'd-none'}}">
                                            <i class="bi bi-check"></i></div>
                                    </label>
                                </div>
                                @endforeach
                            </div>
                        </div>
                        <div class="pt-25 payment-option-hide mt-30" id="StripePayment">
                            <div class="row g-4">
                                <div class="col-md-12">
                                    <label class="text-color">{{ translate('Credit or Debit Card') }}</label>
                                    <div id="card-element"></div>
                                    <div id="card-errors" role="alert" class="text-danger mt-2"></div>
                                </div>
                            </div>
                            <div class='form-row row pt-3'>
                                <div class='col-md-12 modal-error form-group d-none'>
                                    <div class='alert-danger alert'>
                                        {{ translate('Please correct the errors and try again') }}.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @php
                    $last_amount = $bidSingle->amount - $bidSingle->transactions?->sum('amount');
                    $tax_amount = ($last_amount / 100) * $bidSingle->tax_rate;
                    $total_amount = $last_amount + $tax_amount;
                    @endphp
                    <input type="hidden" name="order_id" value="{{ $bidSingle->id }}">
                    <input type="hidden" class="modal_amount_main_val" name="amount" value="{{ number_format($last_amount, 2) ?? 0 }}">
                    <input type="hidden" class="modal_tax_amount_val" name="tax_amount" value="{{ number_format($tax_amount, 2) ?? 0 }}">
                    <input type="hidden" class="modal_total_amount_val" name="total_amount" value="{{ number_format($total_amount, 2) ?? 0 }}">
                    <div class="total-amount-area">
                        <ul>
                            <li>{{ translate('Payment Amount') }}<span class="amount-main">{{ format_currency($last_amount)}}</span>
                            </li>
                            <li>{{ $bidSingle->tax_rate ?? get_setting('tax_rate') ?? 0 }}% {{ translate('TAX') }}<span class="amount">{{
                                    format_currency($tax_amount) }}</span>
                            </li>
                            <li>{{ translate('Total for payment') }}<span class="amount">{{ format_currency($total_amount) }}</span>
                            </li>
                        </ul>
                    </div>
                    <div class="pay-btn">
                        <input type="hidden" name="type" value="7">
                        <button class="primary-btn2 btn-hover w-100 text-center d-block" type="submit">{{
                            translate('Pay') }}
                            <span class="modal_total_amount">{{format_currency($total_amount)}}</span></button>
                    </div>
                </form>
            </div>
            @else
            <h2>{{ translate('No Payment Method Found') }}</h2>
            @endif
        </div>
    </div>
</div>

@push('js')
<script src="https://js.stripe.com/v3/"></script>
<script src="https://checkout.razorpay.com/v1/checkout.js"></script>
<script src="{{ asset('frontend/js/payment-transaction.js') }}"></script>
@endpush