<div class="auction-card">
    <div class="auction-card-img-wrap">
        <a href="{{route('artwork.details',$item->slug)}}" class="card-img">
            <img src="{{ uploaded_asset($item->features_image) }}" alt="{{ $item->name }}">
        </a>
        <div class="batch">
            @switch($item->sale_type)
            @case(1)
            @if(\Carbon\Carbon::parse($item->start_date)->isFuture())
            <span class="upcoming">{{ translate('UpComing') }}</span>
            @else
            <span>{{ translate('Live') }}</span>
            @endif
            @break

            @case(2)
            @if ($item->sale_price)
            <span class="sold-out">{{ translate('Sale') }}!</span>
            @endif
            @break
            @endswitch
        </div>


        <button type="button" class="wishlist" onclick="wishlistFunction()" data-id="{{ $item->id }}" @auth data-auth="1" @else data-auth="0" @endauth>
            @if(Auth::check() && $item->wishlists?->where('user_id', Auth::id())->isNotEmpty())
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="15" viewBox="0 0 16 15">
                <path fill="#e63946" d="M8.00013 13.6828C4.76378 11.4628 2.96935 9.42471 2.10683 7.72315C1.21149 5.95597 1.32211 4.57128 1.81244 3.61222C2.85685 1.57317 5.75006 1.01348 7.32792 2.63535L8.00013 3.32629L8.67234 2.63441C10.2502 1.01254 13.1434 1.57317 14.1878 3.61222C14.6791 4.57128 14.7888 5.95503 13.8934 7.72315C13.03 9.42471 11.2365 11.4628 8.00013 13.6828Z" />
            </svg>
            @else
            <svg width="16" height="15" viewBox="0 0 16 15" xmlns="http://www.w3.org/2000/svg">
                <path d="M8.00013 3.32629L7.32792 2.63535C5.75006 1.01348 2.85685 1.57317 1.81244 3.61222C1.32211 4.57128 1.21149 5.95597 2.10683 7.72315C2.96935 9.42471 4.76378 11.4628 8.00013 13.6828C11.2365 11.4628 13.03 9.42471 13.8934 7.72315C14.7888 5.95503 14.6791 4.57128 14.1878 3.61222C13.1434 1.57317 10.2502 1.01254 8.67234 2.63441L8.00013 3.32629Z" />
            </svg>
            @endif
        </button>
        @if ($item->sale_type == 1)
        <div class="countdown-timer">
            <ul data-countdown="{{ \Carbon\Carbon::parse($item->start_date)->isFuture() ? $item->start_date : $item->end_date }}">
                <li class="times" data-days="00">00</li>
                <li class="colon">
                    :
                </li>
                <li class="times" data-hours="00">00</li>
                <li class="colon">
                    :
                </li>
                <li class="times" data-minutes="00">00</li>
                <li class="colon">
                    :
                </li>
                <li class="times" data-seconds="00">00</li>
            </ul>
        </div>
        @endif
    </div>
    <div class="auction-card-content">
        <h6><a href="{{route('artwork.details',$item->slug)}}">{{ $item->getTranslation('name') }}</a></h6>
        <ul>
            <li><span>{{ translate('Artist') }} : </span>{{ $item->artists?->getTranslation('name') }}</li>
            <li><span>{{ $item->sale_type == 1 ? translate('Current Bidding') : translate('Price') }}: </span>
                @if ($item->sale_type == 1)
                {{ format_currency($item->bids?->max('amount') ?? $item->min_bid_price) }}
                @else
                @if ($item->sale_price)
                <del>{{ format_currency($item->sale_price) }}</del> {{ format_currency($item->price) }}
                @else
                {{ format_currency($item->price) }}
                @endif
                @endif
            </li>
        </ul>
        <a href="{{route('artwork.details',$item->slug)}}" class="bid-btn btn-hover">
            <span>{{ isset($type) && $type == 'upcoming' ? translate('Notify Me') : ($item->sale_type == 1 ?
                translate('Bidding Start') : translate('Buy Now')) }}</span>
            <strong></strong>
        </a>
    </div>
</div>