@extends('frontend.template-' . selectedTheme() . '.layouts.master')

@section('content')
@include('frontend.template-' . selectedTheme() . '.partials.breadcrumb')
<div class="dashboard-section mb-120">
    <div class="container">
        <div class="dashboard-wrapper">
            @include('frontend.template-' . selectedTheme() . '.pages.dashboard.sidebar')
            <div class="dashboard-content-wrap style-2">
                <div class="dashboard-order-content">
                    <div class="dashboard-order-table">
                        <div class="dashboard-top-area">
                            <h4>{{$title ?? ''}}</h4>
                            <div class="category-area d-lg-flex d-none active sorting-select">
                                <form action="" method="get">
                                    <select class="select2 filter_by" name="filter_by">
                                        <option value="">{{translate('Sorting')}}</option>
                                        <option value="1">{{translate('Sort by Auction')}}</option>
                                        <option value="2">{{translate('Sort by Direct')}}</option>
                                    </select>
                                </form>
                            </div>
                        </div>
                        <table>
                            <thead>
                                <tr>
                                    <th>{{translate('Image')}}</th>
                                    <th>{{translate('Artwork')}}</th>
                                    <th>{{translate('Amount')}}</th>
                                    <th>{{translate('Date')}}</th>
                                    <th>{{translate('View More')}}</th>
                                    <th>{{translate('Remove')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if($wishlists->count() > 0)
                                @foreach($wishlists as $wishlist)
                                <tr>
                                    <td data-label="{{translate('Image')}}"><img src="{{uploaded_asset($wishlist->artworks?->features_image)}}" alt="Image" width="50">
                                    </td>
                                    <td data-label="{{translate('Artwork')}}"><span class="table-text px-2">{{$wishlist->artworks?->getTranslation('name')}}</span></td>
                                    <td data-label="{{translate('Amount')}}"><span class="table-text px-2">{{ format_currency($wishlist->artworks?->sale_type == 1
                                        ? $wishlist->artworks?->min_bid_price
                                        : ($wishlist->artworks?->sale_price ?? 
                                        $wishlist->artworks?->price)) }}</span></td>
                                    <td data-label="{{translate('Date')}}"><span class="table-text px-2">{{dateFormat($wishlist->created_at)}}</span></td>
                                    <td data-label="{{translate('View More')}}" class="px-2">
                                        <a href="{{route('artwork.details',$wishlist->artworks?->slug)}}" class="primary-btn1 btn-hover">
                                            <span>{{$wishlist->artworks?->sale_type == 1 ? translate('Bidding Start') : translate('Buy Now')}}</span>
                                            <strong></strong>
                                        </a>
                                    </td>
                                    <td data-label="{{translate('Remove')}}">
                                        <form method="POST" action="{{ route('user.wishlist.destroy', $wishlist->id) }}">
                                            @csrf
                                            <input name="_method" type="hidden" value="DELETE">
                                            <button type="submit" class="primary-btn1 btn-hover show_confirm"><span><i class="bi bi-trash3"></i></span><strong></strong></button>
                                        </form>
                                    </td>
                                </tr>
                                @endforeach
                                @else
                                <tr>
                                <tr>
                                    <td colspan="6">
                                        <div class="text-center">{{translate('Data not found')}}</div>
                                    </td>
                                </tr>
                                @endif
                            </tbody>
                        </table>
                        {!! $wishlists->links('vendor.pagination.custom') !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
