@extends('frontend.template-' . selectedTheme() . '.layouts.master')

@section('content')
@include('frontend.template-' . selectedTheme() . '.partials.breadcrumb')
<div class="dashboard-section mb-120">
    <div class="container">
        <div class="dashboard-wrapper">
            @include('frontend.template-' . selectedTheme() . '.pages.dashboard.sidebar')
            <form action="{{ route('user.profile.update') }}" method="post" enctype="multipart/form-data">
                @csrf
                @method('PATCH')
                <div class="dashboard-content-wrap">
                    <div class="dashboard-profile-content">
                        <div class="single-content border-0">
                            <h5>{{ translate('Basic Info') }}</h5>
                            <div class="author-area text-center">
                                <div class="author-image">
                                    <img id="imagePreview" src="{{ uploaded_asset($user->image) }}" alt="Profile Image">
                                    <input type="file" name="image" id="imageInput" accept="image/*" style="display: none;">
                                    <label for="imageInput" class="icon image-icon">
                                        <svg width="15" height="15" viewBox="0 0 15 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <g clip-path="url(#clip0_1323_1720)">
                                                <path d="M14.0625 11.25C14.0625 11.4986 13.9637 11.7371 13.7879 11.9129C13.6121 12.0887 13.3736 12.1875 13.125 12.1875H1.875C1.62636 12.1875 1.3879 12.0887 1.21209 11.9129C1.03627 11.7371 0.9375 11.4986 0.9375 11.25V5.625C0.9375 5.37636 1.03627 5.1379 1.21209 4.96209C1.3879 4.78627 1.62636 4.6875 1.875 4.6875H2.97375C3.71929 4.68709 4.43416 4.39069 4.96125 3.86344L5.73938 3.08719C5.91469 2.91182 6.15234 2.81305 6.40031 2.8125H8.59781C8.84643 2.81255 9.08485 2.91136 9.26062 3.08719L10.0369 3.86344C10.2981 4.12473 10.6082 4.332 10.9496 4.47339C11.2909 4.61479 11.6568 4.68754 12.0262 4.6875H13.125C13.3736 4.6875 13.6121 4.78627 13.7879 4.96209C13.9637 5.1379 14.0625 5.37636 14.0625 5.625V11.25ZM1.875 3.75C1.37772 3.75 0.900806 3.94754 0.549175 4.29917C0.197544 4.65081 0 5.12772 0 5.625L0 11.25C0 11.7473 0.197544 12.2242 0.549175 12.5758C0.900806 12.9275 1.37772 13.125 1.875 13.125H13.125C13.6223 13.125 14.0992 12.9275 14.4508 12.5758C14.8025 12.2242 15 11.7473 15 11.25V5.625C15 5.12772 14.8025 4.65081 14.4508 4.29917C14.0992 3.94754 13.6223 3.75 13.125 3.75H12.0262C11.529 3.74989 11.0522 3.55228 10.7006 3.20063L9.92438 2.42437C9.57283 2.07272 9.09599 1.87511 8.59875 1.875H6.40125C5.90401 1.87511 5.42717 2.07272 5.07562 2.42437L4.29938 3.20063C3.94783 3.55228 3.47099 3.74989 2.97375 3.75H1.875Z" fill="black" />
                                                <path d="M7.5 10.3125C6.8784 10.3125 6.28226 10.0656 5.84272 9.62603C5.40318 9.18649 5.15625 8.59035 5.15625 7.96875C5.15625 7.34715 5.40318 6.75101 5.84272 6.31147C6.28226 5.87193 6.8784 5.625 7.5 5.625C8.1216 5.625 8.71774 5.87193 9.15728 6.31147C9.59682 6.75101 9.84375 7.34715 9.84375 7.96875C9.84375 8.59035 9.59682 9.18649 9.15728 9.62603C8.71774 10.0656 8.1216 10.3125 7.5 10.3125ZM7.5 11.25C8.37024 11.25 9.20484 10.9043 9.82019 10.2889C10.4355 9.67359 10.7812 8.83899 10.7812 7.96875C10.7812 7.09851 10.4355 6.26391 9.82019 5.64856C9.20484 5.0332 8.37024 4.6875 7.5 4.6875C6.62976 4.6875 5.79516 5.0332 5.17981 5.64856C4.56445 6.26391 4.21875 7.09851 4.21875 7.96875C4.21875 8.83899 4.56445 9.67359 5.17981 10.2889C5.79516 10.9043 6.62976 11.25 7.5 11.25ZM2.8125 6.09375C2.8125 6.21807 2.76311 6.3373 2.67521 6.42521C2.5873 6.51311 2.46807 6.5625 2.34375 6.5625C2.21943 6.5625 2.1002 6.51311 2.01229 6.42521C1.92439 6.3373 1.875 6.21807 1.875 6.09375C1.875 5.96943 1.92439 5.8502 2.01229 5.76229C2.1002 5.67439 2.21943 5.625 2.34375 5.625C2.46807 5.625 2.5873 5.67439 2.67521 5.76229C2.76311 5.8502 2.8125 5.96943 2.8125 6.09375Z" fill="black" />
                                            </g>
                                            <defs>
                                                <clipPath id="clip0_1323_1720">
                                                    <rect width="15" height="15" fill="white" />
                                                </clipPath>
                                            </defs>
                                        </svg>
                                    </label>
                                </div>
                            </div>
                            <div class="author-content text-center mb-3 text-color">
                                <h4 class="mb-0">{{ $user->fname . ' ' . $user->lname }}</h4>
                                <span>{{ '@' . $user->custom_id }}</span>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-md-6">
                                <div class="form-inner mb-30">
                                    <label>{{ translate('First Name') }} <span class="text-color">*</span></label>
                                    <input type="text" name="fname" value="{{ old('fname', $user->fname) }}" placeholder="{{ translate('Enter First Name') }}">
                                    @error('fname')
                                    <div class="error text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-inner mb-30">
                                    <label>{{ translate('Last Name') }}</label>
                                    <input type="text" name="lname" value="{{ old('lname', $user->lname) }}" placeholder="{{ translate('Enter Last Name') }}">
                                    @error('lname')
                                    <div class="error text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-inner mb-30">
                                    <label>{{translate('Email')}} <span class="text-color">*</span></label>
                                    <input type="email" name="email" value="{{old('email',$user->email)}}" placeholder="info@example.com">
                                    @error('email')
                                    <div class="error text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-inner mb-30">
                                    <label>{{translate('Contact Number')}}</label>
                                    <input id="phone" type="tel" name="phone" value="{{old('phone',$user->phone)}}" placeholder="01700000000">
                                    @error('phone')
                                    <div class="error text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="single-content style-2">
                        <h5 class="text-color">{{translate('Personal Address')}}</h5>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-inner mb-30">
                                    <label>{{translate('Your Address')}}</label>
                                    <input type="text" name="address" value="{{old('address',$user->address)}}" placeholder="{{translate('Enter Your Address')}}">
                                    @error('address')
                                    <div class="error text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6 mb-30">
                                <div class="form-inner">
                                    <label>{{translate('Country')}}</label>
                                    <select name="country_id" class="country_id select2">
                                        <option value="">{{translate('Select Option')}}</option>
                                        @foreach($countries as $country)
                                        <option value="{{$country->id}}" {{$country->id == $user->country_id ? 'selected' : ''}}>{{$country->getTranslation('name')}}</option>
                                        @endforeach
                                    </select>
                                    @error('country_id')
                                    <div class="error text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6 mb-30">
                                <div class="form-inner">
                                    <label>{{translate('State')}}</label>
                                    <select name="state_id" class="state_id select2">
                                        <option value="">{{translate('Select Option')}}</option>
                                        @if($user->state_id)
                                        <option value="{{$user->state_id}}" selected>{{$user->states?->getTranslation('name')}}</option>
                                        @endif
                                    </select>
                                    @error('state_id')
                                    <div class="error text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6 mb-30">
                                <div class="form-inner">
                                    <label>{{translate('City')}}</label>
                                    <select name="city_id" class="city_id select2">
                                        <option value="">{{translate('Select Option')}}</option>
                                        @if($user->city_id)
                                        <option value="{{$user->city_id}}" selected>{{$user->cities?->getTranslation('name')}}</option>
                                        @endif
                                    </select>
                                    @error('city_id')
                                    <div class="error text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-inner mb-30">
                                    <label>{{translate('Zip Code')}}</label>
                                    <input type="text" name="zip_code" value="{{old('zip_code',$user->zip_code)}}" placeholder="1216">
                                    @error('zip_code')
                                    <div class="error text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="single-content style-2">
                        <h5 class="text-color">{{translate('Password Info')}}</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-inner mb-30 position-relative">
                                    <label>{{translate('Password')}}</label>
                                    <input id="password" type="password" name="password" placeholder="******" autocomplete="new-password">
                                    <i class="bi bi-eye-slash" id="togglePassword"></i>
                                    @error('password')
                                    <div class="error text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-inner mb-30 position-relative">
                                    <label>{{translate('Confirm Password')}}</label>
                                    <input id="password2" type="password" name="password_confirmation" placeholder="******" autocomplete="new-password">
                                    <i class="bi bi-eye-slash" id="togglePassword2"></i>
                                </div>
                            </div>
                        </div>
                        <div class="form-inner style-2">
                            <button type="submit" class="primary-btn2 btn-hover">
                                <span>{{translate('Update Profile')}}</span>
                                <strong></strong>
                            </button>
                            <a href="{{ url()->current() }}" class="primary-btn1 btn-hover">
                                <span>{{translate('Cancel')}}</span>
                                <strong></strong>
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
</div>
<!-- Ends deshboard section -->
@endsection
