@extends('frontend.template-' . selectedTheme() . '.layouts.master')

@section('content')
@include('frontend.template-' . selectedTheme() . '.partials.breadcrumb')
<div class="dashboard-section mb-120">
    <div class="container">
        <div class="dashboard-wrapper">
            @include('frontend.template-' . selectedTheme() . '.pages.dashboard.sidebar')
            <div class="dashboard-content-wrap style-2">
                <div class="dashboard-order-content">
                    <div class="dashboard-order-table">
                        <div class="dashboard-top-area">
                            <h4>{{$title ?? ''}}</h4>
                            <div class="category-area d-lg-flex d-none active sorting-select">
                                <form action="" method="get">
                                    <select class="select2 filter_by" name="filter_by">
                                        <option value="">{{translate('Sorting')}}</option>
                                        <option value="1">{{translate('Sort by Status')}}</option>
                                        <option value="2">{{translate('Sort by Product title')}}</option>
                                    </select>
                                </form>
                            </div>
                        </div>
                        <table>
                            <thead>
                                <tr>
                                    <th>{{translate('Order Id')}}</th>
                                    <th>{{translate('Image')}}</th>
                                    <th>{{translate('Artwork')}}</th>
                                    <th>{{translate('Price')}}</th>
                                    <th>{{translate('Status')}}</th>
                                    <th>{{translate('Certificate')}}</th>
                                    <th>{{translate('Action')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if($orders->count() > 0)
                                @foreach($orders as $order)
                                <tr>
                                    <td data-label="Order Id"><span class="table-text">{{$order->order_number}}</span>
                                    </td>
                                    <td data-label="Image"><img src="{{uploaded_asset($order->artworks?->features_image)}}" alt="Image" width="50">
                                    </td>
                                    <td data-label="Artwork"><span class="table-text">{{$order->artworks?->getTranslation('name')}}</span></td>
                                    <td data-label="Price"><span class="table-text px-1">{{format_currency($order->amount)}}</span></td>
                                    @php
                                    $statuses = [
                                    1 => ['label' => 'Processing', 'class' => 'orange-color'],
                                    2 => ['label' => 'Win', 'class' => 'green-color'],
                                    3 => ['label' => 'Reject', 'class' => 'red-color'],
                                    4 => ['label' => 'Completed', 'class' => 'green-color'],
                                    5 => ['label' => 'On Hold', 'class' => 'orange-color'],
                                    6 => ['label' => 'Delivered', 'class' => 'green-color'],
                                    7 => ['label' => 'Refunded', 'class' => 'red-color'],
                                    8 => ['label' => 'Shipped', 'class' => 'color-purple'],
                                    ];

                                    $status = $statuses[$order->status];
                                    @endphp
                                    <td data-label="Status"><span class="{{ $status['class'] }} px-2">{{ $status['label'] }}</span></td>
                                    <td data-label="Certificate" class="px-2">
                                        <a href="{{route('home.certificate',$order->artworks?->slug)}}" class="primary-btn1 btn-hover">
                                            <span>{{translate('Preview')}}</span>
                                            <strong></strong>
                                        </a>
                                    </td>
                                    <td>
                                        <a href="{{route('user.order.details',$order->id)}}" class="icon">
                                            <svg width="6" height="12" viewBox="0 0 6 12" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M4.47001 10.5004C4.24509 10.5214 4.01931 10.4707 3.82501 10.3554C3.75492 10.2835 3.70191 10.1967 3.66989 10.1015C3.63787 10.0063 3.62766 9.90511 3.64003 9.80543C3.64527 9.63733 3.66534 9.47001 3.70001 9.30544C3.73357 9.11664 3.77693 8.92972 3.82999 8.74543L4.42 6.71542C4.48085 6.51504 4.52106 6.30896 4.54001 6.1004C4.54001 5.87542 4.57 5.72039 4.57 5.63041C4.57619 5.43245 4.53759 5.23565 4.45707 5.0547C4.37655 4.87375 4.2562 4.71333 4.10499 4.58541C3.7282 4.29615 3.25898 4.15396 2.78499 4.18542C2.44532 4.19052 2.10829 4.24613 1.78498 4.35042C1.43165 4.46042 1.05997 4.59207 0.669985 4.74543L0.5 5.40543C0.614984 5.36542 0.75502 5.32044 0.914992 5.27042C1.06761 5.2252 1.22582 5.20164 1.38498 5.20042C1.60826 5.17622 1.83296 5.23107 2.01998 5.35541C2.08284 5.43042 2.12986 5.51738 2.15822 5.61104C2.18657 5.70471 2.19568 5.80315 2.18498 5.90043C2.18442 6.06857 2.16598 6.23617 2.12998 6.40041C2.09496 6.57542 2.04997 6.7604 1.99497 6.9554L1.39998 8.99538C1.35203 9.185 1.31365 9.37691 1.285 9.57039C1.26163 9.73602 1.24993 9.9031 1.24998 10.0704C1.24877 10.2696 1.29321 10.4665 1.37987 10.6459C1.46654 10.8253 1.59314 10.9825 1.74996 11.1054C2.13257 11.3991 2.60845 11.5448 3.08994 11.5154C3.42898 11.5223 3.76686 11.4733 4.08995 11.3703C4.37329 11.2737 4.75163 11.1354 5.22497 10.9554L5.38499 10.3253C5.25677 10.3785 5.12473 10.422 4.98998 10.4553C4.81956 10.4942 4.64458 10.5094 4.47001 10.5004ZM5.09499 0.875447C4.82287 0.625537 4.46433 0.491088 4.09498 0.500459C3.72581 0.492133 3.36764 0.626441 3.09497 0.875447C2.59516 1.30642 2.53934 2.061 2.97036 2.56085C3.00877 2.60541 3.05042 2.64706 3.09497 2.68546C3.66439 3.19477 4.52557 3.19477 5.09495 2.68546C5.59476 2.25023 5.64714 1.49226 5.21191 0.992451C5.17569 0.950791 5.13663 0.911696 5.09499 0.875447Z" />
                                            </svg>
                                        </a>
                                    </td>
                                </tr>
                                @endforeach
                                @else
                                <tr>
                                    <td colspan="7">
                                        <div class="text-center">{{translate('Data not found')}}</div>
                                    </td>
                                </tr>
                                @endif
                            </tbody>
                        </table>
                        {!! $orders->links('vendor.pagination.custom') !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection