@extends('frontend.template-1.layouts.master')

@section('content')
<div class="certificate-section mb-120 pt-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10 mb-35">
                <div class="certificate-download-icon">
                    <ul>
                        <li>
                            <a id="printBtn" href="javascript:void(0)">
                                <svg width="20" height="20" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                    <g>
                                        <path d="M17.9167 15H15.4167C15.3062 15 15.2002 14.9561 15.122 14.878C15.0439 14.7998 15 14.6938 15 14.5833C15 14.4728 15.0439 14.3668 15.122 14.2887C15.2002 14.2106 15.3062 14.1667 15.4167 14.1667H17.9167C18.6058 14.1667 19.1667 13.6058 19.1667 12.9167V7.08333C19.1667 6.39417 18.6058 5.83333 17.9167 5.83333H2.08333C1.39417 5.83333 0.833333 6.39417 0.833333 7.08333V12.9167C0.833333 13.6058 1.39417 14.1667 2.08333 14.1667H4.58333C4.69384 14.1667 4.79982 14.2106 4.87796 14.2887C4.9561 14.3668 5 14.4728 5 14.5833C5 14.6938 4.9561 14.7998 4.87796 14.878C4.79982 14.9561 4.69384 15 4.58333 15H2.08333C1.531 14.9993 1.00148 14.7796 0.610925 14.3891C0.220367 13.9985 0.000661607 13.469 0 12.9167V7.08333C0 5.935 0.934167 5 2.08333 5H17.9167C19.0658 5 20 5.935 20 7.08333V12.9167C20 14.065 19.0658 15 17.9167 15ZM12.0833 17.5H7.08333C6.97283 17.5 6.86685 17.4561 6.7887 17.378C6.71057 17.2998 6.66667 17.1938 6.66667 17.0833C6.66667 16.9728 6.71057 16.8668 6.7887 16.7887C6.86685 16.7106 6.97283 16.6667 7.08333 16.6667H12.0833C12.1938 16.6667 12.2998 16.7106 12.378 16.7887C12.4561 16.8668 12.5 16.9728 12.5 17.0833C12.5 17.1938 12.4561 17.2998 12.378 17.378C12.2998 17.4561 12.1938 17.5 12.0833 17.5ZM12.0833 15.8333H7.08333C6.97283 15.8333 6.86685 15.7894 6.7887 15.7113C6.71057 15.6332 6.66667 15.5272 6.66667 15.4167C6.66667 15.3062 6.71057 15.2002 6.7887 15.122C6.86685 15.0439 6.97283 15 7.08333 15H12.0833C12.1938 15 12.2998 15.0439 12.378 15.122C12.4561 15.2002 12.5 15.3062 12.5 15.4167C12.5 15.5272 12.4561 15.6332 12.378 15.7113C12.2998 15.7894 12.1938 15.8333 12.0833 15.8333Z" />
                                        <path d="M8.7513 14.1667H7.08464C6.97413 14.1667 6.86815 14.1228 6.79001 14.0446C6.71187 13.9665 6.66797 13.8605 6.66797 13.75C6.66797 13.6395 6.71187 13.5335 6.79001 13.4554C6.86815 13.3772 6.97413 13.3333 7.08464 13.3333H8.7513C8.86181 13.3333 8.96779 13.3772 9.04593 13.4554C9.12407 13.5335 9.16797 13.6395 9.16797 13.75C9.16797 13.8605 9.12407 13.9665 9.04593 14.0446C8.96779 14.1228 8.86181 14.1667 8.7513 14.1667ZM15.418 5.83333C15.3075 5.83333 15.2015 5.78944 15.1233 5.7113C15.0452 5.63315 15.0013 5.52717 15.0013 5.41667V2.08333C15.0013 1.39417 14.4405 0.833333 13.7513 0.833333H6.2513C5.56214 0.833333 5.0013 1.39417 5.0013 2.08333V5.41667C5.0013 5.52717 4.9574 5.63315 4.87926 5.7113C4.80112 5.78944 4.69514 5.83333 4.58464 5.83333C4.47413 5.83333 4.36815 5.78944 4.29001 5.7113C4.21187 5.63315 4.16797 5.52717 4.16797 5.41667V2.08333C4.16797 0.935 5.10214 0 6.2513 0H13.7513C14.9005 0 15.8346 0.935 15.8346 2.08333V5.41667C15.8346 5.52717 15.7907 5.63315 15.7126 5.7113C15.6345 5.78944 15.5285 5.83333 15.418 5.83333Z" />
                                        <path d="M13.7513 19.9987H6.2513C5.69897 19.998 5.16945 19.7783 4.77889 19.3878C4.38834 18.9972 4.16863 18.4677 4.16797 17.9154V11.2487C4.16797 11.1382 4.21187 11.0322 4.29001 10.9541C4.36815 10.8759 4.47413 10.832 4.58464 10.832H15.418C15.5285 10.832 15.6345 10.8759 15.7126 10.9541C15.7907 11.0322 15.8346 11.1382 15.8346 11.2487V17.9154C15.8346 19.0637 14.9005 19.9987 13.7513 19.9987ZM5.0013 11.6654V17.9154C5.0013 18.6045 5.56214 19.1654 6.2513 19.1654H13.7513C14.4405 19.1654 15.0013 18.6045 15.0013 17.9154V11.6654H5.0013Z" />
                                    </g>
                                </svg>
                            </a>
                        </li>
                        <li>
                            <a id="downloadPdf" href="javascript:void(0)">
                                <svg width="20" height="20" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M3.71016 13.1992C3.92233 13.1992 4.12581 13.2835 4.27584 13.4335C4.42587 13.5836 4.51016 13.787 4.51016 13.9992V15.5992C4.51016 15.8114 4.59444 16.0149 4.74447 16.1649C4.8945 16.3149 5.09798 16.3992 5.31016 16.3992H14.9102C15.1223 16.3992 15.3258 16.3149 15.4758 16.1649C15.6259 16.0149 15.7102 15.8114 15.7102 15.5992V13.9992C15.7102 13.787 15.7944 13.5836 15.9445 13.4335C16.0945 13.2835 16.298 13.1992 16.5102 13.1992C16.7223 13.1992 16.9258 13.2835 17.0758 13.4335C17.2259 13.5836 17.3102 13.787 17.3102 13.9992V15.5992C17.3102 16.2357 17.0573 16.8462 16.6072 17.2963C16.1571 17.7464 15.5467 17.9992 14.9102 17.9992H5.31016C4.67364 17.9992 4.06319 17.7464 3.6131 17.2963C3.16301 16.8462 2.91016 16.2357 2.91016 15.5992V13.9992C2.91016 13.787 2.99444 13.5836 3.14447 13.4335C3.2945 13.2835 3.49798 13.1992 3.71016 13.1992Z" />
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M5.54282 8.63486C5.69284 8.48488 5.89629 8.40063 6.10842 8.40063C6.32055 8.40063 6.524 8.48488 6.67402 8.63486L10.1084 12.0693L13.5428 8.63486C13.6166 8.55845 13.7049 8.4975 13.8025 8.45557C13.9001 8.41365 14.0051 8.39158 14.1113 8.39066C14.2175 8.38973 14.3229 8.40997 14.4212 8.4502C14.5195 8.49042 14.6088 8.54983 14.6839 8.62494C14.7591 8.70005 14.8185 8.78938 14.8587 8.88769C14.8989 8.98601 14.9191 9.09135 14.9182 9.19758C14.9173 9.3038 14.8952 9.40878 14.8533 9.50638C14.8114 9.60398 14.7504 9.69226 14.674 9.76606L10.674 13.7661C10.524 13.916 10.3206 14.0003 10.1084 14.0003C9.89629 14.0003 9.69284 13.916 9.54282 13.7661L5.54282 9.76606C5.39285 9.61603 5.30859 9.41259 5.30859 9.20046C5.30859 8.98832 5.39285 8.78488 5.54282 8.63486Z" />
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M9.8 3C10.0122 3 10.2157 3.08429 10.3657 3.23431C10.5157 3.38434 10.6 3.58783 10.6 3.8V13.4C10.6 13.6122 10.5157 13.8157 10.3657 13.9657C10.2157 14.1157 10.0122 14.2 9.8 14.2C9.58783 14.2 9.38434 14.1157 9.23431 13.9657C9.08429 13.8157 9 13.6122 9 13.4V3.8C9 3.58783 9.08429 3.38434 9.23431 3.23431C9.38434 3.08429 9.58783 3 9.8 3Z" />
                                </svg>
                            </a>
                        </li>
                    </ul>
                </div>
                <div id="pdfContent" class="certificate-wrapper">
                    <div class="certificate text-center">
                        <div class="tag">
                            <h2>{{translate('Certificate of Authenticity')}}</h2>
                        </div>
                        <span>{{translate('Title Of Artwork')}}</span>
                        <h2>{{$artworkSingle->getTranslation('name')}}</h2>
                        <p>{{translate('This document certifies that the artwork described above is an original creation by Jane Doe and has been authenticated by')}} {{get_setting('company_name')}}. {{translate('The artwork is signed by the artist.It is an
                            original piece and has not been previously sold or exhibited')}}.</p>
                        <div class="lebel-section">
                            <div class="single-lebel">
                                <img class="sign-img" src="{{ uploaded_asset($artworkSingle->artists?->signature) }}" alt="artist signature" width="150">
                                <h5>{{translate('ARTIST')}}</h5>
                            </div>
                            <div class="single-lebel">
                                <img class="second-img" src="{{asset('frontend/img/inner-page/lebel-img.png')}}" alt="label image">
                            </div>
                            <div class="single-lebel">
                                <img class="sign-img" src="{{ uploaded_asset(get_setting('authorized_sign')) }}" alt="authorized signature" width="150">
                                <h5>{{translate('AUTHORIZED')}}</h5>
                            </div>
                        </div>
                        <img class="img-shape" src="{{asset('frontend/img/inner-page/certificate-shape1.png')}}" alt="img-shape">
                        <img class="img-shape2" src="{{asset('frontend/img/inner-page/certificate-shape2.png')}}" alt="img-shape2">
                        <svg class="img-shape3" width="100" height="108" viewBox="0 0 100 108" xmlns="http://www.w3.org/2000/svg">
                            <path d="M100 108L0 7.62939e-06H100V108Z" />
                        </svg>
                        <svg class="img-shape4" width="109" height="98" viewBox="0 0 109 98" xmlns="http://www.w3.org/2000/svg">
                            <path d="M0 0L109 98H0V0Z" />
                        </svg>
                    </div>
                </div>
            </div>
            <div class="col-lg-10">
                <div class="certificate-other-info">
                    <ul class="info-list">
                        <li class="list-content">
                            <div class="certificate-number">
                                <h4>{{translate('Certificate Number')}}:</h4>
                                <p>{{$artworkSingle->certificate_number}}</p>
                                <h4>{{translate('Important Note')}}:</h4>
                                <p>{{translate("Keep this Certificate of Authenticity in a safe place, as it serves as official documentation of the artwork's authenticity and provenance")}}.</p>
                            </div>
                        </li>
                        <li class="list-content">
                            <div class="certificate-issued">
                                <h4>{{translate('Certificate Issued By')}} <a href="{{route('home.page')}}">{{get_setting('company_name')}}</a></h4>
                                <ul class="issued-list">
                                    @if(get_setting('company_address'))
                                    <li>{{translate('Address')}}: <a href="#">{{get_setting('company_address')}}</a></li>
                                    @endif
                                    <li>{{translate('Website')}}: <a href="{{route('home.page')}}">{{route('home.page')}}</a></li>
                                    @if(get_setting('company_email'))
                                    <li>{{translate('Email')}}: <a href="mailto:{{get_setting('company_email')}}">{{get_setting('company_email')}}</a></li>
                                    @endif
                                    @if(get_setting('company_phone'))
                                    <li>{{translate('Phone')}}: <a href="tel:{{get_setting('company_phone')}}">{{get_setting('company_phone')}}</a></li>
                                    @endif
                                </ul>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection