@extends('frontend.template-1.layouts.master')

@section('content')
@include('frontend.template-' . selectedTheme() . '.partials.breadcrumb')
<div class="details-page-wrapper mb-120 pb-120">
    <div class="container-lg container-fluid">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="post-author-meta">
                    <div class="author-and-date">
                        <div class="author-area">
                            <div class="author-img">
                                <img src="{{uploaded_asset($blogSingle->users?->image)}}" alt="{{$blogSingle->users?->fname}}">
                            </div>
                            <div class="author-name-desig">
                                <span>{{translate('Author')}}</span>
                                <h6><a href="#">{{$blogSingle->users?->fname.' '.$blogSingle->users?->lname}}</a></h6>
                            </div>
                        </div>
                        <div class="date">
                            <span>{{translate('Published Date')}}</span>
                            <h6>{{dateFormat($blogSingle->created_at)}}</h6>
                        </div>
                    </div>
                    <div class="social-area d-sm-flex d-none">
                        <h6>{{translate('Share')}}:</h6>
                        <ul class="social-link">
                            <li><a href="https://www.facebook.com/sharer.php?u={{ urlencode(url()->current()) }}"><i class='bx bxl-facebook'></i></a></li>
                            <li><a href="https://x.com/intent/tweet?url={{ urlencode(url()->current()) }}"><i class="bi bi-twitter-x"></i></a></li>
                            <li>
                                <a href="https://www.linkedin.com/shareArticle?mini=true&url={{ urlencode(url()->current()) }}&title={{ urlencode($blogSingle->getTranslation('name') ?? '') }}&summary={{ urlencode(\Illuminate\Support\Str::limit(strip_tags($blogSingle->getTranslation('description') ?? ''), 50)) }}" target="_blank" rel="noopener">
                                    <i class="bx bxl-linkedin"></i>
                                </a>
                            </li>
                            <li><a href="https://pinterest.com/pin/create/button/?url={{ urlencode(url()->current()) }}&media={{ urlencode(uploaded_asset($blogSingle->image)) }}&description={{ urlencode(\Illuminate\Support\Str::limit($blogSingle->getTranslation('description'), 50) ?? '') }}"><i class="bx bxl-pinterest"></i></a>
                            </li>
                        </ul>
                    </div>
                </div>
                <span class="line-break"></span>
                <span class="line-break"></span>
                <div class="post-thumb">
                    <img src="{{uploaded_asset($blogSingle->image)}}" alt="{{$blogSingle->title}}">
                </div>
                <span class="line-break"></span>
                <span class="line-break"></span>
                <div class="details-page-content style-2 mb-120">
                    <h3>{{$blogSingle->getTranslation('title')}}</h3>
                    <span class="line-break"></span>
                    {!! $blogSingle->getTranslation('description') !!}
                    <span class="line-break"></span>
                    <span class="line-break"></span>
                    <span class="line-break"></span>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="details-navigation">
                                @if(!empty($previous))
                                <div class="single-navigation">
                                    <a class="arrow" href="{{route('blog.details',$previous->slug)}}">
                                        <svg width="7" height="14" viewBox="0 0 8 13" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M0 6.50008L8 0L2.90909 6.50008L8 13L0 6.50008Z"></path>
                                        </svg>
                                        {{translate('Prev')}}
                                    </a>
                                    <div class="content">
                                        <h6><a class="style-2" href="{{route('blog.details',$previous->slug)}}">{{$previous->getTranslation('title')}}</a></h6>
                                    </div>
                                </div>
                                @endif
                                @if(!empty($next))
                                <div class="single-navigation two text-end">
                                    <div class="content">
                                        <h6><a class="style-2" href="{{route('blog.details',$next->slug)}}">{{$next->getTranslation('title')}}</a></h6>
                                    </div>
                                    <a class="arrow" href="{{route('blog.details',$next->slug)}}">
                                        {{translate('Next')}}
                                        <svg width="7" height="14" viewBox="0 0 8 13" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M8 6.50008L0 0L5.09091 6.50008L0 13L8 6.50008Z"></path>
                                        </svg>
                                    </a>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                @include('frontend.template-' . selectedTheme() . '.partials.comment')
            </div>
        </div>
    </div>
</div>
@endsection