@extends('frontend.template-1.layouts.master')

@section('content')
@include('frontend.template-' . selectedTheme() . '.partials.breadcrumb')
<div class="auction-details-section mb-120">
    <div class="container">
        <div class="row gy-5">
            <div class="col-lg-7">
                <div class="auction-details-img">
                    <div class="tab-content" id="v-pills-tabContent">
                        @if ($artworkSingle->features_image)
                        <div class="tab-pane fade show active" id="v-pills-img01" role="tabpanel">
                            <div class="auction-details-tab-img">
                                <div class="tab-image">
                                    <img src="{{ uploaded_asset($artworkSingle->features_image) }}" alt="Image">
                                </div>
                            </div>
                        </div>
                        @endif
                        @if ($artworkSingle->galleries)
                        @foreach ($artworkSingle->galleries as $gallery)
                        <div class="tab-pane fade" id="v-pills-img{{ $gallery->id }}" role="tabpanel">
                            <div class="auction-details-tab-img">
                                <div class="tab-image">
                                    <img src="{{ uploaded_asset($gallery->image) }}" alt="Image">
                                </div>
                            </div>
                        </div>
                        @endforeach
                        @endif
                    </div>
                    <div class="nav nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                        <div class="swiper auction-details-nav-slider">
                            <div class="swiper-wrapper">
                                @if ($artworkSingle->features_image)
                                <div class="swiper-slide">
                                    <div class="nav-item" role="presentation">
                                        <button class="nav-link active" id="v-pills-img01-tab" data-bs-toggle="pill" data-bs-target="#v-pills-img01" type="button" role="tab" aria-controls="v-pills-img01" aria-selected="true">
                                            <img src="{{ uploaded_asset($artworkSingle->features_image) }}" alt="Image">
                                        </button>
                                    </div>
                                </div>
                                @endif

                                @if ($artworkSingle->galleries)
                                @foreach ($artworkSingle->galleries as $img)
                                <div class="swiper-slide">
                                    <div class="nav-item" role="presentation">
                                        <button class="nav-link" id="v-pills-img{{ $img->id }}-tab" data-bs-toggle="pill" data-bs-target="#v-pills-img{{ $img->id }}" type="button" role="tab" aria-controls="v-pills-img{{ $img->id }}" aria-selected="false">
                                            <img src="{{ uploaded_asset($img->image) }}" alt="Image">
                                        </button>
                                    </div>
                                </div>
                                @endforeach
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-5 wow animate fadeInRight" data-wow-delay="200ms" data-wow-duration="1500ms">
                <div class="auction-details-content">
                    <h3>{{$artworkSingle->getTranslation('name')}}</h3>
                    <ul class="artist-info">
                        <li><span>{{translate('Artist')}} :</span> {{$artworkSingle->artists?->getTranslation('name')}}</li>
                        <li>
                            <span>{{ $artworkSingle->sale_type == 1 ? translate('Current Bid') : translate('Price') }}
                                :</span>
                            @if(($artworkSingle->sale_type == 1 && $artworkSingle->status == 5) ||
                            ($artworkSingle->sale_type != 1 && $artworkSingle->quantity == 0))
                            <span class="text-danger">{{ translate('Sold Out') }}</span>
                            @elseif($artworkSingle->sale_type == 1)
                            {{ format_currency($artworkSingle->bids?->max('amount') ?? $artworkSingle->min_bid_price) }}
                            @else
                            {!! $artworkSingle->sale_price > 0
                            ? '<del>' . format_currency($artworkSingle->price) . '</del> ' .
                            format_currency($artworkSingle->sale_price)
                            : format_currency($artworkSingle->price) !!}
                            @endif
                        </li>
                        <li><span>{{translate('Item condition')}} :</span> {{ $artworkSingle->condition == 1 ? 'Good' :
                            ($artworkSingle->condition == 2 ? 'Bad' : 'Moderate') }}</li>
                    </ul>
                    @if($artworkSingle->sale_type == 1 && $artworkSingle->status == 1)
                    <div class="quantity-area">
                        <h6>{{translate('Bidding Start')}}</h6>
                        <form action="{{ route('checkout.show') }}" method="POST" class="quantity-form">
                            @csrf
                            <input type="hidden" name="artwork_id" value="{{$artworkSingle->id}}">
                            <input type="hidden" name="current_bid" value="{{$artworkSingle->bids?->max('amount') ?? $artworkSingle->min_bid_price}}">
                            <div class="quantity-counter-and-btn-area">
                                <div class="quantity-counter">
                                    <a href="#" class="{{$artworkSingle->start_date &&
                                \Carbon\Carbon::parse($artworkSingle->start_date)->isPast() ? 'quantity__minus' : ''}}"><i class='bx bx-minus'></i></a>
                                    <input name="price" type="text" class="quantity__input" value="{{($artworkSingle->bids?->max('amount') ?? $artworkSingle->min_bid_price) + 1}}" data-value="{{($artworkSingle->bids?->max('amount') ?? $artworkSingle->min_bid_price) + 1}}" {{$artworkSingle->start_date &&
                                \Carbon\Carbon::parse($artworkSingle->start_date)->isFuture() ? 'readonly' : ''}}>
                                    <a href="#" class="{{$artworkSingle->start_date &&
                                \Carbon\Carbon::parse($artworkSingle->start_date)->isPast() ? 'quantity__plus' : ''}}"><i class='bx bx-plus'></i></a>
                                </div>
                                @if ($artworkSingle->start_date &&
                                \Carbon\Carbon::parse($artworkSingle->start_date)->isPast())
                                <button type="submit" class="primary-btn1 btn-hover">
                                    <span>{{translate('Place Bid')}}</span>
                                    <strong></strong>
                                </button>
                                @else
                                <button type="button" class="primary-btn1 btn-hover" data-bs-toggle="modal" data-bs-target="#notifyModal">
                                    <span>{{translate('Notify Me')}}</span>
                                    <strong></strong>
                                </button>
                                @endif
                            </div>
                        </form>
                    </div>
                    @endif
                    <div class="auction-details-btn">
                            <button type="button" class="wishlist auction-grid-btn btn-hover wishlit-btn mb-3" onclick="wishlistFunction()" data-id="{{ $artworkSingle->id }}" @auth data-auth="1" @else data-auth="0" @endauth>
                                <span>{{Auth::check() && $artworkSingle->wishlists?->where('user_id', Auth::id())->isNotEmpty() ? translate('Already Added Wishlist') : translate('Add To Wishlist')}}</span>
                                <strong></strong>
                            </button>
                        @if($artworkSingle->sale_type == 2)
                        <form action="{{ route('checkout.show') }}" method="POST">
                            @csrf
                            <input type="hidden" name="artwork_id" value="{{$artworkSingle->id}}">
                            <input type="hidden" name="price" value="{{$artworkSingle->sale_price > 0 ? $artworkSingle->sale_price : $artworkSingle->price}}">
                            <button type="submit" class="auction-grid-btn btn-hover" @if($artworkSingle->quantity == 0)
                                disabled @endif>
                                <span>{{$artworkSingle->quantity == 0 ? translate('Sold Out') : translate('Buy
                                    Now')}}</span>
                                <strong></strong>
                            </button>
                        </form>
                        @endif
                    </div>
                    @if($artworkSingle->sale_type == 1)
                    @if ($artworkSingle->start_date && \Carbon\Carbon::parse($artworkSingle->start_date)->isFuture())
                    <div class="countdown-area mb-3">
                        <h6>{{translate('Auction will Be Start')}}</h6>
                        <div class="countdown-timer">
                            <ul data-countdown="{{$artworkSingle->start_date}}">
                                <li class="times" data-days="00">00</li>
                                <li class="colon">
                                    :
                                </li>
                                <li class="times" data-hours="00">00</li>
                                <li class="colon">
                                    :
                                </li>
                                <li class="times" data-minutes="00">00</li>
                                <li class="colon">
                                    :
                                </li>
                                <li class="times" data-seconds="00">00</li>
                            </ul>
                        </div>
                        <span class="ending-time">{{translate('Starting')}} : <strong>{{
                                \Carbon\Carbon::parse($artworkSingle->start_date)->format('F j, Y \a\t g:i a')
                                }}</strong></span>
                    </div>
                    @endif
                    <div class="countdown-area">
                        <h6>{{translate('Auction will Be End')}}</h6>
                        <div class="countdown-timer">
                            <ul data-countdown="{{$artworkSingle->end_date}}">
                                <li class="times" data-days="00">00</li>
                                <li class="colon">
                                    :
                                </li>
                                <li class="times" data-hours="00">00</li>
                                <li class="colon">
                                    :
                                </li>
                                <li class="times" data-minutes="00">00</li>
                                <li class="colon">
                                    :
                                </li>
                                <li class="times" data-seconds="00">00</li>
                            </ul>
                        </div>
                        <span class="ending-time">{{translate('Ending')}} : <strong>{{
                                \Carbon\Carbon::parse($artworkSingle->end_date)->format('F j, Y \a\t g:i a')
                                }}</strong></span>
                    </div>
                    @endif
                    <div class="product_meta mt-3">
                        @if($artworkSingle->categories->count() > 0)
                        <span class="posted_in">{{translate('Categories')}}:
                            @foreach($artworkSingle->categories as $category)
                            <a href="{{route('category.page',$category->slug)}}" rel="tag">{{$category->getTranslation('name')}}</a>@if(!$loop->last), @endif
                            @endforeach
                        </span>
                        @endif
                        @php
                        $tagString = $artworkSingle->getTranslation('tags');
                        $tags = $tagString ? explode(',', $tagString) : [];
                        @endphp
                        @if(!empty($tags))
                        <span class="tagged_as">
                            {{ translate('Tags') }}:
                            @foreach($tags as $tag)
                            <a href="{{ route('tag.page', \Illuminate\Support\Str::slug(trim($tag))) }}" rel="tag">
                                {{ trim($tag) }}
                            </a>@if(!$loop->last), @endif
                            @endforeach
                        </span>
                        @endif
                    </div>
                    <div class="payment-method">
                        <ul class="payment-list">
                            <li>
                                <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M3.375 9.5625L7.875 14.0625L14.625 3.9375" stroke="#1D972B" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                                {{translate('Shipping : Less than one week')}}
                            </li>
                            <li>
                                <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M3.375 9.5625L7.875 14.0625L14.625 3.9375" stroke="#1D972B" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                                {{translate('Secure delivery : United States + $162')}}
                            </li>
                            <li>
                                <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M3.375 9.5625L7.875 14.0625L14.625 3.9375" stroke="#1D972B" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                                {{translate('Free returns within Two Weekes')}}
                            </li>
                            <li>
                                <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M3.375 9.5625L7.875 14.0625L14.625 3.9375" stroke="#1D972B" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                                {{translate('Authenticity Certificate')}}
                            </li>
                            <li>
                                <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M3.375 9.5625L7.875 14.0625L14.625 3.9375" stroke="#1D972B" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                                {{translate('Secured Payment Gateways')}}
                            </li>
                        </ul>
                        <ul class="payment-card">
                            <li>
                                <img src="{{asset('frontend/img/inner-page/payment-image.svg')}}" alt="{{translate('payment-img1')}}">
                            </li>
                            <li>
                                <img src="{{asset('frontend/img/inner-page/payment-image2.svg')}}" alt="{{translate('payment-img2')}}">
                            </li>
                            <li>
                                <img src="{{asset('frontend/img/inner-page/payment-image3.svg')}}" alt="{{translate('payment-img3')}}">
                            </li>
                            <li>
                                <img src="{{asset('frontend/img/inner-page/payment-image4.svg')}}" alt="{{translate('payment-img4')}}">
                            </li>
                        </ul>
                    </div>
                    <span class="ask-question">{{translate('Have any question?')}} <a href="{{url('contact-us')}}">{{translate('Ask Us')}}</a></span>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="product-description mb-120">
    <div class="container">
        <div class="row justify-content-center gy-4">
            <div class="col-xxl-3 col-lg-6">
                <div class="artist-overview">
                    <h5>{{translate('Artist Overview')}}</h5>
                    <ul>
                        @if($artworkSingle->artists?->dob)
                        <li>
                            <h6>{{translate('Date of Birth and death')}}</h6>
                            <p>{{$artworkSingle->artists?->getTranslation('dob')}}</p>
                        </li>
                        @endif
                        @if($artworkSingle->artists?->nationality)
                        <li>
                            <h6>{{translate('Nationality')}}</h6>
                            <p>{{$artworkSingle->artists?->getTranslation('nationality')}}</p>
                        </li>
                        @endif
                        @if($artworkSingle->artists?->themes)
                        <li>
                            <h6>{{translate('Style')}}</h6>
                            <p>{{$artworkSingle->artists?->getTranslation('themes')}}</p>
                        </li>
                        @endif
                        @if($artworkSingle->artists?->awards_lists)
                        <li>
                            <h6>{{translate('Notable work')}}</h6>
                            @php
                            $awards = $artworkSingle->artists?->awards_lists ?
                            json_decode($artworkSingle->artists?->getTranslation('awards_lists')) : '';
                            @endphp
                            @if($awards)
                            <p>@foreach($awards as $award)
                                {{'"'.$award->title.'" ('.$award->year.')'}},
                                @endforeach
                            </p>@endif
                        </li>
                        @endif
                    </ul>
                </div>
            </div>
            <div class="col-xxl-5 col-lg-6">
                <div class="exploring-artwork">
                    <h5>{{translate('Exploring the Artwork')}}</h5>
                    @php
                    $specifications = $artworkSingle->specifications ?
                    json_decode($artworkSingle->getTranslation('specifications')) : '';
                    @endphp
                    @if($specifications)
                    <ul>
                        @foreach($specifications as $specification)
                        <li>
                            <h6>{{$specification->label}} :</h6>
                            <p>{{$specification->value}}</p>
                        </li>
                        @endforeach
                    </ul>
                    @endif
                    @if($artworkSingle->height && $artworkSingle->width && $artworkSingle->length)
                    <ul>
                        <li>
                            <h6>{{translate('Size')}} :</h6>
                            <p>{{$artworkSingle->height}} {{translate('inch')}} x {{$artworkSingle->width}}
                                {{translate('inch')}} x {{$artworkSingle->length}}
                                {{translate('inch')}} ({{translate('Height')}} x {{translate('Width')}} x
                                {{translate('Depth')}})</p>
                        </li>
                    </ul>
                    @endif
                </div>
            </div>
            <div class="col-xxl-4 col-lg-6">
                <div class="narrative-guidelines">
                    <h5>{{translate('Art Inner narrative & guidelines')}}</h5>
                    {!! $artworkSingle->getTranslation('content') !!}
                </div>
            </div>
        </div>
    </div>
</div>
@if($similar_artworks)
<div class="home1-auction-slider-section mb-120">
    <div class="container">
        <div class="row mb-50 align-items-center justify-content-between flex-wrap gap-3 wow animate fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
            <div class="col-lg-12">
                <div class="section-title">
                    <h3>{{translate('Similar Artworks')}}</h3>
                </div>
            </div>
        </div>
        <div class="auction-slider-wrap wow animate fadeInUp" data-wow-delay="200ms" data-wow-duration="1500ms">
            <div class="row">
                <div class="col-lg-12">
                    <div class="swiper home1-auction-slider">
                        <div class="swiper-wrapper">
                            @foreach($similar_artworks as $item)
                            <div class="swiper-slide">
                                @include('frontend.template-1.partials.artwork')
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
            <div class="slider-btn-grp">
                <div class="slider-btn auction-slider-prev">
                    <svg width="10" height="16" viewBox="0 0 10 16" xmlns="http://www.w3.org/2000/svg">
                        <path d="M0.735295 8.27932L10 16L4.10428 8.27932L10 0.558823L0.735295 8.27932Z" />
                    </svg>
                </div>
                <div class="slider-btn auction-slider-next">
                    <svg width="10" height="16" viewBox="0 0 10 16" xmlns="http://www.w3.org/2000/svg">
                        <path d="M9.26471 7.72068L0 0L5.89572 7.72068L0 15.4412L9.26471 7.72068Z" />
                    </svg>
                </div>
            </div>
        </div>
    </div>
</div>
@endif

@include('frontend.template-' . selectedTheme() . '.partials.notify_modal')
@endsection
