@extends('frontend.template-1.layouts.master')

@section('content')
<div class="breadcrumb-section" style="background-image: linear-gradient(180deg, rgba(0, 0, 0, 0.28), rgba(0, 0, 0, 0.28)), url(/frontend/img/inner-page/breadcrumb-image.jpg);">
    <div class="container">
        <div class="row">
            <div class="col-lg-12 d-flex mb-70">
                <div class="top-content style-2">
                    <ul>
                        <li>
                            <a href="{{ route('home.page') }}">
                                <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M1.125 5.99955L5.602 1.52205C5.822 1.30255 6.178 1.30255 6.3975 1.52205L10.875 5.99955M2.25 4.87455V9.93705C2.25 10.2475 2.502 10.4995 2.8125 10.4995H4.875V8.06205C4.875 7.75155 5.127 7.49955 5.4375 7.49955H6.5625C6.873 7.49955 7.125 7.75155 7.125 8.06205V10.4995H9.1875C9.498 10.4995 9.75 10.2475 9.75 9.93705V4.87455M4.125 10.4995H8.25" stroke="white" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </a>
                        </li>
                        <li>{{ $artistSingle->getTranslation('name') }}</li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="breadcrumb-wrapper">
                    <div class="row gy-4">
                        <div class="col-lg-7 d-flex align-items-center">
                            <div class="artist-info">
                                <h1>{{ $artistSingle->getTranslation('name') }}</h1>
                                <p>{{ $artistSingle->getTranslation('bio') }}</p>
                            </div>
                        </div>
                        <div class="col-lg-5 d-flex justify-content-lg-end">
                            <div class="artist-image">
                                <img src="{{ uploaded_asset($artistSingle->image) }}" alt="{{ $artistSingle->name }}">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="auction-card-sidebar-section pt-120 mb-120">
    <div class="container">
        <div class="row gy-5">
            <div class="col-xl-3  order-xl-1 order-2">
                <div class="sidebar-area">
                    <input type="hidden" id="artwork_type">
                    <input type="hidden" id="widget_name" value="artist">
                    <input type="hidden" id="item_show" value="{{ request()->item ?? 12 }}">
                    <input type="hidden" class="artist_id">
                    <input type="hidden" class="art_type">
                    <div class="single-widgets widget_search mb-30">
                        <div class="widget-title">
                            <h5>{{ translate('Search Artwork') }}</h5>
                        </div>
                        <form id="productSearch">
                            <div class="wp-block-search__inside-wrapper ">
                                <input type="search" id="keyword" class="keyword wp-block-search__input" placeholder="{{translate('Search Artwork')}}" required="">
                                <button type="submit" class="wp-block-search__button">
                                    <svg width="16" height="16" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M11.7425 10.3418C12.7107 9.0205 13.1444 7.38236 12.9567 5.75508C12.769 4.1278 11.9739 2.63139 10.7303 1.56522C9.48666 0.49905 7.88635 -0.0582469 6.2495 0.0048239C4.61265 0.0678947 3.05997 0.746681 1.90209 1.90538C0.744221 3.06409 0.0665459 4.61725 0.00464636 6.25415C-0.0572531 7.89104 0.501188 9.49095 1.56825 10.7338C2.63531 11.9766 4.13229 12.7707 5.7597 12.9572C7.38711 13.1438 9.02494 12.7089 10.3455 11.7397H10.3445C10.3745 11.7797 10.4065 11.8177 10.4425 11.8547L14.2924 15.7046C14.4799 15.8922 14.7342 15.9977 14.9995 15.9977C15.2647 15.9978 15.5192 15.8926 15.7068 15.7051C15.8944 15.5176 15.9999 15.2632 16 14.9979C16.0001 14.7327 15.8948 14.4782 15.7073 14.2906L11.8575 10.4408C11.8217 10.4046 11.7833 10.3711 11.7425 10.3408V10.3418ZM12.0004 6.4979C12.0004 7.22015 11.8582 7.93532 11.5818 8.60258C11.3054 9.26985 10.9003 9.87614 10.3896 10.3868C9.87889 10.8975 9.2726 11.3027 8.60533 11.5791C7.93807 11.8554 7.2229 11.9977 6.50065 11.9977C5.77841 11.9977 5.06324 11.8554 4.39597 11.5791C3.72871 11.3027 3.12242 10.8975 2.61171 10.3868C2.10101 9.87614 1.6959 9.26985 1.41951 8.60258C1.14312 7.93532 1.00086 7.22015 1.00086 6.4979C1.00086 5.03927 1.5803 3.64037 2.61171 2.60896C3.64312 1.57755 5.04202 0.99811 6.50065 0.99811C7.95929 0.99811 9.35818 1.57755 10.3896 2.60896C11.421 3.64037 12.0004 5.03927 12.0004 6.4979Z" />
                                    </svg>
                                </button>
                            </div>
                        </form>
                    </div>

                    <div class="single-widgets mb-50">
                        <div class="widget-title">
                            <h5>{{ translate('Category') }}</h5>
                        </div>
                        <div class="checkbox-container">
                            <ul>
                                @if ($categories)
                                @foreach ($categories as $category)
                                <li>
                                    <label class="containerss">
                                        <input type="checkbox" class="category_id" name="category_id" value="{{ $category->id }}">
                                        <span class="checkmark"></span>
                                        <span>{{ $category->getTranslation('name') }}</span>
                                    </label>
                                </li>
                                @endforeach
                                @endif
                            </ul>
                        </div>
                    </div>
                    <div class="single-widgets mb-50">
                        <div class="widget-title">
                            <h5>{{ translate('Default Sorting') }}</h5>
                        </div>
                        <div class="checkbox-container">
                            <ul>
                                <li>
                                    <label class="containerss">
                                        <input type="checkbox" class="order_by" value="price_high_low">
                                        <span class="checkmark"></span>
                                        <span>{{ translate('Sort By Price (High to Low)') }}</span>
                                    </label>
                                </li>
                                <li>
                                    <label class="containerss">
                                        <input type="checkbox" class="order_by" value="price_low_high">
                                        <span class="checkmark"></span>
                                        <span>{{ translate('Sort By Price (Low to High)') }} </span>
                                    </label>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-9 order-xl-2 order-1">
                <div class="right-content">
                    <div class="row mb-35">
                        <div class="nav-area">
                            <div class="col-lg-12 d-flex justify-content-center">
                                <ul class="nav nav-tabs2" id="myTab5" role="tablist">
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link active" id="artworks-tab" data-bs-toggle="tab" data-bs-target="#artworks" type="button" role="tab" aria-controls="artworks" aria-selected="false" tabindex="-1">{{ translate('Artworks') }}</button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link" id="biography-tab" data-bs-toggle="tab" data-bs-target="#biography" type="button" role="tab" aria-controls="biography" aria-selected="false" tabindex="-1">{{ translate('Biography') }}</button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link" id="awards-tab" data-bs-toggle="tab" data-bs-target="#awards" type="button" role="tab" aria-controls="awards" aria-selected="false" tabindex="-1">{{ translate('Awards') }}</button>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="row ">
                        <div class="col-lg-12">
                            <div class="tab-content" id="myTabContent5">
                                <div class="tab-pane fade show active" id="artworks" role="tabpanel">
                                    <div class="row justify-content-center gy-4" id="loadArtwork">
                                        @php
                                        $artworks = $artistSingle
                                        ->art_works()
                                        ->where('status', 1)
                                        ->latest()
                                        ->paginate(12);
                                        @endphp

                                        @include('frontend.template-1.partials.filter_artwork', [
                                        'artworks' => $artworks,
                                        ])
                                    </div>
                                    <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
                                </div>
                                <div class="tab-pane" id="biography" role="tabpanel">
                                    <div class="row">
                                        <div class="col-lg-8">
                                            <div class="biography-section">
                                                <p class="biography-top-text">
                                                    {{ $artistSingle->getTranslation('biography_desc') }}</p>

                                                @if(!empty($artistSingle->career_lists))
                                                @php
                                                $careers = json_decode(
                                                $artistSingle->getTranslation('career_lists') ?? '[]'
                                                );
                                                @endphp
                                                @if(!empty($careers))
                                                @foreach ($careers as $career)
                                                <div class="biography-card">
                                                    <h4>{{ $career->title }}</h4>
                                                    {!! $career->content !!}
                                                </div>
                                                @endforeach
                                                @endif
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-lg-4">
                                            <div class="biography-right-section">
                                                @if ($artistSingle->nationality)
                                                <div class="biography-right-content">
                                                    <h6>{{ translate('Nationality') }}</h6>
                                                    <p>{{ $artistSingle->getTranslation('nationality') }}</p>
                                                </div>
                                                @endif
                                                @if ($artistSingle->themes)
                                                <div class="biography-right-content">
                                                    <h6>{{ translate('Themes') }}</h6>
                                                    <p>{{ $artistSingle->getTranslation('themes') }}</p>
                                                </div>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane" id="awards" role="tabpanel">
                                    <div class="awards-section">
                                        <p>{{ $artistSingle->getTranslation('awards_desc') }}</p>
                                        <ul class="awards-list">
                                            @if (!empty($artistSingle->awards_lists))
                                            @php
                                            $awards = json_decode(
                                            $artistSingle->getTranslation('awards_lists') ?? '[]'
                                            );
                                            @endphp
                                            @if(!empty($awards))
                                            @foreach ($awards as $award)
                                            <li>
                                                <div class="content">
                                                    <span>{{ $award->year }}</span>
                                                    <h4>{{ $award->title }}</h4>
                                                    <p>{!! $award->content !!}</p>
                                                </div>
                                                @if ($award->link)
                                                <div class="button-area">
                                                    <a href="{{ $award->link }}" class="icon">
                                                        <svg width="16" height="16" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg">
                                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M13.582 1.41649L0 14.9978L1.00217 16L14.5835 2.41795L14.5835 11.8086H16L16 0L4.1914 0V1.41649L13.582 1.41649Z" />
                                                        </svg>
                                                    </a>
                                                </div>
                                                @endif
                                            </li>
                                            @endforeach
                                            @endif
                                            @endif
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('js')
<script src="{{asset('frontend/js/artwork-filter.js')}}?v={{ rand(1000, 9999) }}"></script>
@endpush
