@extends('backend.layouts.master')
@section('content')
<div class="row mb-35 g-4">
    <div class="page-title d-flex justify-content-between align-items-center">
        <h4>{{$page_title ?? ''}}</h4>
        <a href="{{route('dashboard.withdraw.list')}}" class="eg-btn btn--primary back-btn"> <img src="{{asset('backend/images/icons/back.svg')}}" alt="{{ translate('Go Back') }}"> {{ translate('Go
            Back') }}</a>
    </div>
</div>
<div class="row d-flex justify-content-center">
    <div class="col-md-7 col-sm-8">
        <div class="eg-card deposit-card text-center position-relative">
            @if($withdraw->status == 1)
            <span class="eg-badge orange deopsit-badge">{{translate('Pending')}}</span>
            @elseif($withdraw->status == 2)
            <span class="eg-badge green deopsit-badge">{{translate('Completed')}}</span>
            @else
            <span class="eg-badge red deopsit-badge">{{translate('Rejected')}}</span>
            @endif
            <div class="winner-body">
                @php
                $info = $withdraw->payment_method ? json_decode($withdraw?->payment_method) : NULL;
                @endphp
                @if (isset($info->bank_name))
                <img src="{{asset('backend/images/bg/bank.jpg')}}" class="paypal img-fluid" alt="Bank" width="150">
                @elseif(isset($info->mobile_banking_name))
                <img src="{{asset('backend/images/bg/mobile_banking.jpg')}}" class="paypal img-fluid" alt="mobile_banking" width="150">
                @elseif(isset($info->paypal_email))
                <img src="{{asset('backend/images/bg/paypal.png')}}" class="paypal img-fluid" alt="paypal" width="150">
                @endif
                <h4>{{translate('Withdraw Via')}} @if (isset($info->bank_name)) {{translate('Bank')}}
                    @elseif(isset($info->mobile_banking_name)) {{translate('Mobile Banking')}} @elseif(isset($info->paypal_email))
                    {{translate('Paypal')}} @endif</h4>
                <div class="winner-details-list">
                    <li><a href="#"><span>{{translate('Date')}} :</span><span>{{date('d M, Y H:i:s A',
                                strtotime($withdraw->updated_at))}}</span></a></li>
                    <li><a href="#"><span>{{translate('Transaction Number')}}
                                :</span><span>{{$withdraw->transaction_id}}</span></a></li>
                    <li><a href="{{ $withdraw->users?->role == 1 ? route('dashboard.customer.show', $withdraw->users->id) : route('dashboard.art-gallery.show', $withdraw->users->id) }}"><span>{{translate('Name')}}
                                :</span><span class="username">{{$withdraw->users->fname ? $withdraw->users->fname.'
                                '.$withdraw->users->lname : ''}}</span></a></li>
                    <li><a href="#"><span>{{translate('Method')}} :</span><span>
                                @if (isset($info->bank_name)) {{translate('Bank')}} @elseif(isset($info->mobile_banking_name))
                                {{translate('Mobile Banking')}} @elseif(isset($info->paypal_email)) {{translate('Paypal')}} @endif</span></a></li>

                    @if (isset($info->bank_name))
                    <li><a href="#"><span>{{translate('Name')}}
                                :</span><span>{{$info->bank_name}}</span></a></li>
                    <li><a href="#"><span>{{translate('Branch Name')}}
                                :</span><span>{{$info->branch_name}}</span></a></li>
                    <li><a href="#"><span>{{translate('Account Name')}}
                                :</span><span>{{$info->bank_ac_name}}</span></a></li>
                    <li><a href="#"><span>{{translate('Account Number')}}
                                :</span><span>{{$info->bank_ac_number}}</span></a></li>
                    <li><a href="#"><span>{{translate('Routing Number')}}
                                :</span><span>{{$info->bank_routing_number}}</span></a></li>
                    @elseif(isset($info->mobile_banking_name))
                    <li><a href="#"><span>{{translate('Type')}}
                                :</span><span>{{$info->mobile_banking_name}}</span></a></li>
                    <li><a href="#"><span>{{translate('Number')}}
                                :</span><span>{{$info->mobile_banking_number}}</span></a></li>
                    @elseif(isset($info->paypal_email))
                    <li><a href="#"><span>{{translate('Name')}}
                                :</span><span>{{$info->paypal_name}}</span></a></li>
                    <li><a href="#"><span>{{translate('Username')}}
                                :</span><span>{{$info->paypal_username}}</span></a></li>
                    <li><a href="#"><span>{{translate('Email')}}
                                :</span><span>{{$info->paypal_email}}</span></a></li>
                    <li><a href="#"><span>{{translate('Mobile Number')}}
                                :</span><span>{{$info->paypal_mobile_number}}</span></a></li>
                    @endif
                    <li><a href="#"><span>{{translate('Amount')}} :</span><span>{{$withdraw->amount.' '.$withdraw->currency}}</span></a></li>
                </div>
                @if($withdraw->status == 1)
                <form action="{{route('dashboard.withdraw.status.change',$withdraw->id)}}" method="post">
                    <input name="_method" type="hidden" value="PATCH">
                    @csrf
                    <div class="button-group mt-15 d-flex justify-content-between">
                        <button type="submit" class="radio-button">
                            <input type="radio" id="approved" name="status" value="1" />
                            <label class="eg-btn btn--green medium-btn" for="approved">{{translate('Approved')}}</label>
                        </button>
                        <button type="submit" class="radio-button">
                            <input type="radio" id="reject" name="status" value="2" />
                            <label class="eg-btn btn--red medium-btn" for="reject">{{translate('Reject')}}</label>
                        </button>
                    </div>
                </form>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection