@extends('backend.layouts.master')
@section('content')
    <div class="row mb-35 g-4">
        <div class=" col-md-3">
            <div class="page-title text-md-start text-center">
                <h4>{{ $page_title ?? '' }}</h4>
            </div>
        </div>
        <div
            class=" col-md-9 text-md-end text-center d-flex justify-content-md-end justify-content-center flex-row align-items-center flex-wrap gap-4">
            <form action="" method="get">
                <div class="input-with-btn d-flex jusify-content-start align-items-strech">
                    <input type="text" name="search" placeholder="{{translate('Transaction ID Or Amount')}}...">
                    <button type="submit"><i class="bi bi-search"></i></button>
                </div>
            </form>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="table-wrapper">
                <table class="eg-table">
                    <thead>
                        <tr>
                            <th>{{ translate('S.N') }}</th>
                            @if (auth()->user()->role == 3)
                            <th>{{ translate('Customer') }}</th>
                            @endif

                            <th>{{ translate('Method') }}</th>
                            <th>{{ translate('Amount') }}</th>
                            <th>{{ translate('Tax') }}</th>
                            <th>{{ translate('Income') }}</th>
                            <th>{{ translate('Status') }}</th>
                            <th>{{ translate('Date') }}</th>

                        </tr>
                    </thead>
                    <tbody>
                        @if ($transactions->count() > 0)
                            @foreach ($transactions as $key => $transaction)
                                <tr>
                                    <td data-label="S.N">
                                        {{ ($transactions->currentpage() - 1) * $transactions->perpage() + $key + 1 }}</td>
                                    @if (auth()->user()->role == 3)
                                    <td data-label="Customer"><a href="{{ route('dashboard.customer.show', $transaction->users?->id) }}"
                                            title="{{ $transaction->users?->fname }}">{{ $transaction->users?->fname.' '.$transaction->users?->lname . ' - ' . $transaction->users?->custom_id }}</a>
                                    </td>@endif
                                    <td data-label="Method">{{ ucfirst($transaction->payment_method) }}</td>
                                    <td data-label="Amount">
                                        {{ format_currency($transaction->total_amount) }}
                                    </td>
                                    <td data-label="Tax">
                                        {{ format_currency($transaction->tax_amount) }}
                                    </td>
                                    <td data-label="Income">
                                        {{ $user->role != 3 ? format_currency($transaction->merchant_amount) : format_currency($transaction->admin_commission) }}
                                    </td>
                                    <td data-label="Status">
                                        @if ($transaction->status == 2)
                                            <button
                                            class="eg-btn green-light--btn">{{ translate('Approved') }}</button>@else<button
                                                class="eg-btn red-light--btn">{{ translate('Rejected') }}</button>
                                        @endif
                                    </td>
                                    <td data-label="Date">{{ dateFormat($transaction->created_at) }}</td>

                                </tr>
                            @endforeach
                        @else
                            <tr>
                                <td colspan="8" data-label="Not Found">
                                    <h5 class="data-not-found">{{ translate('No Data Found') }}</h5>
                                </td>
                            </tr>
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    @push('footer')
        <div class="d-flex justify-content-center custom-pagination">
            {!! $transactions->links() !!}
        </div>
    @endpush
@endsection
