@extends('backend.layouts.master')
@section('content')
<div class="row mb-35">
    <div class="page-title d-flex justify-content-between align-items-center">
        <h4>{{ $page_title ?? '' }}</h4>
    </div>
</div>
<div class="row">
    <div class="col-12">
        <div class="table-wrapper">
            <table class="eg-table">
                <thead>
                    <tr>
                        <th>{{ translate('S.N') }}</th>
                        <th>{{ translate('Logo') }}</th>
                        <th>{{ translate('Name') }}</th>
                        <th>{{ translate('Status') }}</th>
                        <th>{{ translate('Option') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($methods as $key => $method)
                    <tr>
                        <td data-label="S.N">{{ ($methods->currentpage() - 1) * $methods->perpage() + $key + 1 }}</td>
                        <td data-label="Logo"><img src="{{ uploaded_asset($method->logo) }}" alt="Logo" width="80"></td>
                        <td data-label="Name">{{ $method->name }}</td>
                        <td data-label="Status">
                            <div class="form-check form-switch">
                                <input class="form-check-input stausChange" type="checkbox" data-type="payment_methods" data-id="{{ $method->id }}" id="stausChange{{ $method->id }}" {{ $method->status == 1 ? 'checked' : '' }}>
                            </div>
                        </td>
                        <td data-label="Option">
                            <div class="d-flex flex-row justify-content-md-center justify-content-end align-items-center gap-2">
                                <a href="javascript:void(0)" data-toggle="tooltip" data-method_id="{{ $method->id }}" data-original-title="Edit" class="eg-btn add--btn editPaymentMethods">
                                    <i class="bi bi-pencil-square"></i>
                                </a>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

@push('footer')
<div class="d-flex justify-content-center custom-pagination">
    {!! $methods->links() !!}
</div>
@endpush

@include('backend.payment_methods.modal')
@endsection
