@if (@isset($widgetContent))
<div class="sortable-item accordion-item allowPrimary" data-code="{{ $widgetContent->ui_card_number }}">
    <div class="accordion-header">
        <div class="section-name"> {{ $widgetContent->widget?->widget_name }}
            <div class="collapsed d-flex">
                <div class="form-check form-switch me-2">
                    <input class="form-check-input status-change" data-action="{{ route('dashboard.pages.widget.status.change', $widgetContent->id) }}" {{ $widgetContent->status == 1 ? 'checked' : '' }} type="checkbox" role="switch" id="{{ $widgetContent->id }}">
                    <label class="form-check-label d-none" for="{{ $widgetContent->id }}"> </label>
                </div>
                <div class="collapsed-action-btn edit-action action-icon me-2">
                    <i class="bi bi-pencil-square"></i>
                </div>
                <div class="action-icon delete-action" data-id="{{ $widgetContent->id }}">
                    <i class="bi bi-trash"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="accordion-collapse collapse ">
        <div class="accordion-body">
            @php
            $widgetContents= $widgetContent->getTranslation("widget_content",$lang);
            @endphp
            <form enctype="multipart/form-data" data-action="{{ route('dashboard.pages.widget.save') }}" class="form" method="POST">
                @csrf
                <input type="hidden" name="ui_card_number" value="{{ $widgetContent->ui_card_number }}">
                <input type="hidden" name="page_id" value="{{ $widgetContent->page_id }}">
                <input type="hidden" name="widget_slug" class="widget-slug" value="{{ $widgetContent->widget_slug }}">
                <div class="row">
                    <div class="col-sm-12 mb-2">
                        <div class="form-inner">
                            <label>{{ translate('Title') }}</label>
                            <input type="text" class="username-input" placeholder="{{ translate('Enter Title') }}" name="content[0][title]" value="{{ isset($widgetContents['title']) ? $widgetContents['title'] : '' }}">
                        </div>
                    </div>
                    <div class="col-sm-12 mb-2">
                        <div class="form-inner">
                            <label>{{ translate('Sub Title') }}</label>
                            <input type="text" class="username-input" placeholder="{{ translate('Enter Sub Title') }}" name="content[0][sub_title]" value="{{ isset($widgetContents['sub_title']) ? $widgetContents['sub_title'] : '' }}">
                        </div>
                    </div>
                    <div class="col-sm-6 mb-2">
                        <div class="form-inner">
                            <label>{{translate('Image')}}</label>
                            <div class="d-flex align-items-center">
                                <input type="file" class="username-input widget-image-upload" name="image" data-folder="/uploads/files/">
                                <input type="hidden" name="content[0][video_img][img]" id="old_file" value="{{ isset($widgetContents['video_img']['img']) ? $widgetContents['video_img']['img'] : '' }}">
                            </div>
                            @if (isset($widgetContents['video_img']['img']))
                            <div class="ms-4">
                                <img width="100" src="{{ asset('uploads/files/' . $widgetContents['video_img']['img']) }}" alt="image">
                            </div>
                            @endif
                        </div>
                    </div>
                    <div class="col-sm-6 mb-2">
                        <div class="form-inner">
                            <label>{{ translate('Youtube Video Link') }}</label>
                            <input type="text" class="username-input" placeholder="{{ translate('Youtube Video Link') }}" name="content[0][video_link]" value="{{ isset($widgetContents['video_link']) ? $widgetContents['video_link'] : '' }}">
                        </div>
                    </div>
                    <div class="col-sm-6 mb-2">
                        <div class="form-inner">
                            <label>{{ translate('Question') }}</label>
                            <input type="text" class="username-input" placeholder="{{ translate('Enter Question') }}" name="content[0][question]" value="{{ isset($widgetContents['question']) ? $widgetContents['question'] : '' }}">
                        </div>
                    </div>
                    <div class="col-sm-6 mb-2">
                        <div class="form-inner">
                            <label>{{ translate('Button Text') }}</label>
                            <input type="text" class="username-input" placeholder="{{ translate('Button Text') }}" name="content[0][btn_text]" value="{{ isset($widgetContents['btn_text']) ? $widgetContents['btn_text'] : '' }}">
                        </div>
                    </div>
                    <div class="col-sm-6 mb-2">
                        <div class="form-inner">
                            <label>{{ translate('Button URL') }}</label>
                            <input type="text" class="username-input" placeholder="{{ translate('Button URL') }}" name="content[0][btn_url]" value="{{ isset($widgetContents['btn_url']) ? $widgetContents['btn_url'] : '' }}">
                        </div>
                    </div>
                </div>
                <div class="button-area text-end">
                    <button type="submit" class="eg-btn btn--green medium-btn shadow">{{ translate('Update') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@else
<div class="sortable-item accordion-item allowPrimary" data-code="{{ $randomId }}">
    <div class="accordion-header" id="herosection">
        <div class="section-name"> {{ $widgetName }}
            <div class="collapsed d-flex">
                <div class="form-check form-switch me-2">
                    <input class="form-check-input status-change" data-action="{{ route('dashboard.pages.widget.status.change', $randomId) }}" checked type="checkbox" role="switch" id="{{ $randomId }}">
                    <label class="form-check-label d-none" for="{{ $randomId }}"> </label>
                </div>
                <div class="collapsed-action-btn edit-action action-icon me-2">
                    <i class="bi bi-pencil-square"></i>
                </div>
                <div class="action-icon delete-action" data-id="{{ $randomId }}">
                    <i class="bi bi-trash"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="accordion-collapse collapse show">
        <div class="accordion-body">
            <form eenctype="multipart/form-data" data-action="{{ route('dashboard.pages.widget.save') }}" class="form" method="POST">
                @csrf
                <input type="hidden" name="ui_card_number" value="{{ $randomId }}">
                <input type="hidden" name="page_id" value="{{ $pageId }}">
                <input type="hidden" name="widget_slug" class="widget-slug" value="{{ $slug }}">
                <div class="row">
                    <div class="col-sm-12 mb-2">
                        <div class="form-inner">
                            <label>{{ translate('Title') }}</label>
                            <input type="text" class="username-input" placeholder="{{ translate('Enter Title') }}" name="content[0][title]">
                        </div>
                    </div>
                    <div class="col-sm-12 mb-2">
                        <div class="form-inner">
                            <label>{{ translate('Sub Title') }}</label>
                            <input type="text" class="username-input" placeholder="{{ translate('Enter Sub Title') }}" name="content[0][sub_title]">
                        </div>
                    </div>
                    <div class="col-sm-6 mb-2">
                        <div class="form-inner">
                            <label>{{translate('Image')}}</label>
                            <div class="d-flex align-items-center">
                                <input type="file" class="username-input widget-image-upload" name="image" data-folder="/uploads/files/">
                                <input type="hidden" name="content[0][video_img][img]" id="old_file">
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 mb-2">
                        <div class="form-inner">
                            <label>{{ translate('Youtube Video Link') }}</label>
                            <input type="text" class="username-input" placeholder="{{ translate('Youtube Video Link') }}" name="content[0][video_link]">
                        </div>
                    </div>
                    <div class="col-sm-6 mb-2">
                        <div class="form-inner">
                            <label>{{ translate('Question') }}</label>
                            <input type="text" class="username-input" placeholder="{{ translate('Enter Question') }}" name="content[0][question]">
                        </div>
                    </div>
                    <div class="col-sm-6 mb-2">
                        <div class="form-inner">
                            <label>{{ translate('Button Text') }}</label>
                            <input type="text" class="username-input" placeholder="{{ translate('Button Text') }}" name="content[0][btn_text]">
                        </div>
                    </div>
                    <div class="col-sm-6 mb-2">
                        <div class="form-inner">
                            <label>{{ translate('Button URL') }}</label>
                            <input type="text" class="username-input" placeholder="{{ translate('Button URL') }}" name="content[0][btn_url]">
                        </div>
                    </div>
                </div>
                <div class="button-area text-end">
                    <button type="submit" class="eg-btn btn--green medium-btn shadow">{{ translate('Save') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endif
