@if (@isset($widgetContent))
<div class="sortable-item accordion-item allowPrimary" data-code="{{ $widgetContent->ui_card_number }}">
    <div class="accordion-header">
        <div class="section-name"> {{ $widgetContent->widget?->widget_name }}
            <div class="collapsed d-flex">
                <div class="form-check form-switch me-2">
                    <input class="form-check-input status-change" data-action="{{ route('dashboard.pages.widget.status.change', $widgetContent->id) }}" {{ $widgetContent->status == 1 ? 'checked' : '' }} type="checkbox" role="switch" id="{{ $widgetContent->id }}">
                    <label class="form-check-label d-none" for="{{ $widgetContent->id }}"> </label>
                </div>
                <div class="collapsed-action-btn edit-action action-icon me-2">
                    <i class="bi bi-pencil-square"></i>
                </div>
                <div class="action-icon delete-action" data-id="{{ $widgetContent->id }}">
                    <i class="bi bi-trash"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="accordion-collapse collapse ">
        <div class="accordion-body">
            @php
            $widgetContents= $widgetContent->getTranslation("widget_content",$lang);
            @endphp
            <form enctype="multipart/form-data" data-action="{{ route('dashboard.pages.widget.save') }}" class="form" method="POST">
                @csrf
                <input type="hidden" name="ui_card_number" value="{{ $widgetContent->ui_card_number }}">
                <input type="hidden" name="page_id" value="{{ $widgetContent->page_id }}">
                <input type="hidden" name="widget_slug" class="widget-slug" value="{{ $widgetContent->widget_slug }}">
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-inner mb-3">
                            <label>{{ translate('Form Title') }}</label>
                            <input type="text" class="username-input" placeholder="{{ translate('Enter Form Title') }}" name="content[0][form_title]" value="{{ isset($widgetContents['form_title']) ? $widgetContents['form_title'] : '' }}">
                        </div>
                    </div>
                    <div class="col-sm-6  mb-3">
                        <div class="form-inner">
                            <label>{{ translate('Form Sub Title') }}</label>
                            <input type="text" class="username-input" placeholder="{{ translate('Enter Form Sub Title') }}" name="content[0][form_sub_title]" value="{{ isset($widgetContents['form_sub_title']) ? $widgetContents['form_sub_title'] : '' }}">
                        </div>
                    </div>
                    <hr>
                    <div class="col-sm-12">
                        <div class="form-inner mb-3">
                            <label>{{ translate('Location Title') }}</label>
                            <input type="text" class="username-input" placeholder="{{ translate('Enter Location Title') }}" name="content[0][location_title]" value="{{ isset($widgetContents['location_title']) ? $widgetContents['location_title'] : '' }}">
                        </div>
                    </div>
                    <div class="col-sm-6 mb-3">
                        <div class="form-inner">
                            <label>{{ translate('Open Time') }}</label>
                            <input type="text" class="username-input" placeholder="{{ translate('Enter Open Time') }}" name="content[0][open_time]" value="{{ isset($widgetContents['open_time']) ? $widgetContents['open_time'] : '' }}">
                        </div>
                    </div>
                    <div class="col-sm-6 mb-3">
                        <div class="form-inner">
                            <label>{{ translate('Open Days') }}</label>
                            <input type="text" class="username-input" placeholder="{{ translate('Enter Open Days') }}" name="content[0][open_days]" value="{{ isset($widgetContents['open_days']) ? $widgetContents['open_days'] : '' }}">
                        </div>
                    </div>
                    <div class="col-sm-12 mb-3">
                        <div class="form-inner">
                            <label>{{ translate('Map Iframe Link') }}</label>
                            <textarea rows="5" class="username-input" placeholder="{{ translate('Enter Iframe Link') }}" name="content[0][iframe_link]">{{ isset($widgetContents['iframe_link']) ? $widgetContents['iframe_link'] : '' }} </textarea>
                        </div>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-sm-2">
                        <label> <b>{{ translate('Contact Number') }}</b>:</label>
                    </div>
                    <div class="col-sm-8">
                        <div class="phone-area">
                            @if (isset($widgetContents['phones']))
                            @php
                            $count = 0;
                            @endphp
                            @foreach ($widgetContents['phones'] as $key => $phone)
                            @php
                            $count++;
                            @endphp
                            <div class="row align-items-center content">
                                <div class="col-sm-11">
                                    <div class="row">
                                        <div class="col-sm-6 mb-2">
                                            <div class="form-inner">
                                                <input type="text" class="username-input" placeholder="{{ translate('Enter Title') }}" name="content[0][phones][{{ $count }}][title]" value="{{ isset($phone['title']) ? $phone['title'] : '' }}">
                                            </div>
                                        </div>
                                        <div class="col-sm-6 mb-2">
                                            <div class="form-inner">
                                                <input type="text" class="username-input" placeholder="{{ translate('Enter Phone Number') }}" name="content[0][phones][{{ $count }}][phone_number]" value="{{ isset($phone['phone_number']) ? $phone['phone_number'] : '' }}">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-1">
                                    <button class="remove-information remove text-danger border-0">
                                        <i class="bi  bi-trash"></i>
                                    </button>
                                </div>
                            </div>
                            @endforeach
                            @endif
                        </div>
                        <button type="button" class="add-phone-btn eg-btn btn--primary back-btn">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-plus" viewBox="0 0 16 16">
                                <path d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4z" />
                            </svg>
                        </button>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-sm-2">
                        <label> <b>{{ translate('Email') }}</b>:</label>
                    </div>
                    <div class="col-sm-8">
                        <div class="email-area">
                            @if (isset($widgetContents['emails']))
                            @php
                            $count = 0;
                            @endphp
                            @foreach ($widgetContents['emails'] as $key => $email)
                            @php
                            $count++;
                            @endphp
                            <div class="row align-items-center content">
                                <div class="col-sm-11">
                                    <div class="row">
                                        <div class="col-sm-6 mb-2">
                                            <div class="form-inner">
                                                <input type="text" class="username-input" placeholder="{{ translate('Enter Title') }}" name="content[0][emails][{{ $count }}][title]" value="{{ isset($email['title']) ? $email['title'] : '' }}">
                                            </div>
                                        </div>
                                        <div class="col-sm-6 mb-2">
                                            <div class="form-inner">
                                                <input type="email" class="username-input" placeholder="{{ translate('Enter Email') }}" name="content[0][emails][{{ $count }}][email]" value="{{ isset($email['email']) ? $email['email'] : '' }}">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-1">
                                    <button class="remove-information remove text-danger border-0">
                                        <i class="bi  bi-trash"></i>
                                    </button>
                                </div>
                            </div>
                            @endforeach
                            @endif
                        </div>
                        <button type="button" class="add-email-btn eg-btn btn--primary back-btn">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-plus" viewBox="0 0 16 16">
                                <path d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4z" />
                            </svg>
                        </button>
                    </div>
                </div>
                <div class="button-area text-end">
                    <button type="submit" class="eg-btn btn--green medium-btn shadow">{{ translate('Update') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@else
<div class="sortable-item accordion-item allowPrimary" data-code="{{ $randomId }}">
    <div class="accordion-header" id="herosection">
        <div class="section-name"> {{ $widgetName }}
            <div class="collapsed d-flex">
                <div class="form-check form-switch me-2">
                    <input class="form-check-input status-change" data-action="{{ route('dashboard.pages.widget.status.change', $randomId) }}" checked type="checkbox" role="switch" id="{{ $randomId }}">
                    <label class="form-check-label d-none" for="{{ $randomId }}"> </label>
                </div>
                <div class="collapsed-action-btn edit-action action-icon me-2">
                    <i class="bi bi-pencil-square"></i>
                </div>
                <div class="action-icon delete-action" data-id="{{ $randomId }}">
                    <i class="bi bi-trash"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="accordion-collapse collapse show">
        <div class="accordion-body">
            <form eenctype="multipart/form-data" data-action="{{ route('dashboard.pages.widget.save') }}" class="form" method="POST">
                @csrf
                <input type="hidden" name="ui_card_number" value="{{ $randomId }}">
                <input type="hidden" name="page_id" value="{{ $pageId }}">
                <input type="hidden" name="widget_slug" class="widget-slug" value="{{ $slug }}">
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-inner mb-3">
                            <label>{{ translate('Form Title') }}</label>
                            <input type="text" class="username-input" placeholder="{{ translate('Enter Form Title') }}" name="content[0][form_title]">
                        </div>
                    </div>
                    <div class="col-sm-6  mb-3">
                        <div class="form-inner">
                            <label>{{ translate('Form Sub Title') }}</label>
                            <input type="text" class="username-input" placeholder="{{ translate('Enter Form Sub Title') }}" name="content[0][form_sub_title]">
                        </div>
                    </div>
                    <hr>
                    <div class="col-sm-12">
                        <div class="form-inner mb-3">
                            <label>{{ translate('Location Title') }}</label>
                            <input type="text" class="username-input" placeholder="{{ translate('Enter Location Title') }}" name="content[0][location_title]">
                        </div>
                    </div>
                    <div class="col-sm-6 mb-3">
                        <div class="form-inner">
                            <label>{{ translate('Open Time') }}</label>
                            <input type="text" class="username-input" placeholder="{{ translate('Enter Open Time') }}" name="content[0][open_time]">
                        </div>
                    </div>
                    <div class="col-sm-6 mb-3">
                        <div class="form-inner">
                            <label>{{ translate('Open Days') }}</label>
                            <input type="text" class="username-input" placeholder="{{ translate('Enter Open Days') }}" name="content[0][open_days]">
                        </div>
                    </div>
                    <div class="col-sm-12 mb-3">
                        <div class="form-inner">
                            <label>{{ translate('Map Iframe Link') }}</label>
                            <textarea type="text" rows="5" class="username-input" placeholder="{{ translate('Enter Iframe Link') }}" name="content[0][iframe_link]"></textarea>
                        </div>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-sm-2">
                        <label> <b>{{ translate('Contact Number') }}</b>:</label>
                    </div>
                    <div class="col-sm-8">
                        <div class="phone-area">

                        </div>
                        <button type="button" class="add-phone-btn eg-btn btn--primary back-btn">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-plus" viewBox="0 0 16 16">
                                <path d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4z" />
                            </svg>
                        </button>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-sm-2">
                        <label> <b>{{ translate('Email') }}</b>:</label>
                    </div>
                    <div class="col-sm-8">

                        <div class="email-area">

                        </div>
                        <button type="button" class="add-email-btn eg-btn btn--primary back-btn">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-plus" viewBox="0 0 16 16">
                                <path d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4z" />
                            </svg>
                        </button>
                    </div>
                </div>
                <div class="button-area text-end">
                    <button type="submit" class="eg-btn btn--green medium-btn shadow">{{ translate('Save') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endif
