@if (@isset($widgetContent))
<div class="sortable-item accordion-item allowPrimary" data-code="{{ $widgetContent->ui_card_number }}">
    <div class="accordion-header">
        <div class="section-name"> {{ $widgetContent->widget?->widget_name }}
            <div class="collapsed d-flex">
                <div class="form-check form-switch me-2">
                    <input class="form-check-input status-change" data-action="{{ route('dashboard.pages.widget.status.change', $widgetContent->id) }}" {{ $widgetContent->status == 1 ? 'checked' : '' }} type="checkbox" role="switch" id="{{ $widgetContent->id }}">
                    <label class="form-check-label d-none" for="{{ $widgetContent->id }}"> </label>
                </div>
                <div class="collapsed-action-btn edit-action action-icon me-2">
                    <i class="bi bi-pencil-square"></i>
                </div>
                <div class="action-icon delete-action" data-id="{{ $widgetContent->id }}">
                    <i class="bi bi-trash"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="accordion-collapse collapse ">
        <div class="accordion-body">
            @php
            $widgetContents= $widgetContent->getTranslation("widget_content",$lang);
            @endphp
            <form enctype="multipart/form-data" data-action="{{ route('dashboard.pages.widget.save') }}" class="form" method="POST">
                @csrf
                <input type="hidden" name="ui_card_number" value="{{ $widgetContent->ui_card_number }}">
                <input type="hidden" name="page_id" value="{{ $widgetContent->page_id }}">
                <input type="hidden" name="widget_slug" class="widget-slug" value="{{ $widgetContent->widget_slug }}">
                <div class="row">
                    <div class="col-sm-6 mb-2">
                        <div class="form-inner">
                            <label>{{ translate('Display per Page') }}</label>
                            <input type="number" class="username-input" placeholder="{{ translate('Display per Page') }}" name="content[0][per_page]" value="{{ isset($widgetContents['per_page']) ? $widgetContents['per_page'] : '' }}">
                        </div>
                    </div>
                    <div class="col-sm-6 mb-2">
                        <div class="form-inner">
                            <label>{{ translate('Order') }}</label>
                            <select name="content[0][order_by]" class="select2">
                                <option value="">{{ translate('Select Option') }}</option>
                                <option value="asc" {{ isset($widgetContents['order_by']) && $widgetContents['order_by'] == 'asc' ? 'selected' : '' }}>{{ translate('ASC') }}</option>
                                <option value="desc" {{ isset($widgetContents['order_by']) && $widgetContents['order_by'] == 'desc' ? 'selected' : '' }}>{{ translate('DESC') }}</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="button-area text-end">
                    <button type="submit" class="eg-btn btn--green medium-btn shadow">{{ translate('Update') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@else
<div class="sortable-item accordion-item allowPrimary" data-code="{{ $randomId }}">
    <div class="accordion-header" id="herosection">
        <div class="section-name"> {{ $widgetName }}
            <div class="collapsed d-flex">
                <div class="form-check form-switch me-2">
                    <input class="form-check-input status-change" data-action="{{ route('dashboard.pages.widget.status.change', $randomId) }}" checked type="checkbox" role="switch" id="{{ $randomId }}">
                    <label class="form-check-label d-none" for="{{ $randomId }}"> </label>
                </div>
                <div class="collapsed-action-btn edit-action action-icon me-2">
                    <i class="bi bi-pencil-square"></i>
                </div>
                <div class="action-icon delete-action" data-id="{{ $randomId }}">
                    <i class="bi bi-trash"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="accordion-collapse collapse show">
        <div class="accordion-body">
            <form eenctype="multipart/form-data" data-action="{{ route('dashboard.pages.widget.save') }}" class="form" method="POST">
                @csrf
                <input type="hidden" name="ui_card_number" value="{{ $randomId }}">
                <input type="hidden" name="page_id" value="{{ $pageId }}">
                <input type="hidden" name="widget_slug" class="widget-slug" value="{{ $slug }}">
                <div class="row">
                    <div class="col-sm-6 mb-2">
                        <div class="form-inner">
                            <label>{{ translate('Display per Page') }}</label>
                            <input type="number" class="username-input" placeholder="{{ translate('Display per Page') }}" name="content[0][per_page]">
                        </div>
                    </div>
                    <div class="col-sm-6 mb-2">
                        <div class="form-inner">
                            <label>{{ translate('Order') }}</label>
                            <select name="content[0][order_by]" class="select2">
                                <option value="">{{ translate('Select Option') }}</option>
                                <option value="asc">{{ translate('ASC') }}</option>
                                <option value="desc">{{ translate('DESC') }}</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="button-area text-end">
                    <button type="submit" class="eg-btn btn--green medium-btn shadow">{{ translate('Save') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endif
