<div class="sidebar-wrapper">
    <div class="sidebar">
        <div class="sidebar-menu-wrapper pb-110">
            <ul class="side-menu-list gap-3">
                <li class="{{ Route::is('dashboard.index') ? 'active' : '' }}">
                    <a href="{{ route('dashboard.index') }}">
                        <svg width="30" height="30" viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M14.0449 0.140627C13.8574 0.216799 13.6055 0.351564 13.4883 0.433596C13.3652 0.515627 10.4062 3.45117 6.90233 6.95508C1.76952 12.0996 0.509752 13.3887 0.386705 13.6348C-0.175796 14.7715 0.0117046 16.0137 0.873033 16.8809C1.4121 17.4141 2.09764 17.6953 2.8828 17.6953H3.28124V22.3828C3.28124 25.5527 3.30467 27.1641 3.34569 27.375C3.56835 28.4414 4.42967 29.4082 5.49608 29.7773C5.8828 29.9121 5.9121 29.9121 8.74218 29.9121C11.5312 29.9121 11.5957 29.9121 11.7539 29.7891C11.8418 29.7246 11.9707 29.5957 12.0351 29.5078C12.1582 29.3496 12.1582 29.2734 12.1875 25.4355L12.2168 21.5215L12.3926 21.2344C12.6152 20.877 13.0664 20.5898 13.5 20.5371C13.6641 20.5137 14.4844 20.5078 15.3223 20.5195L16.8457 20.5371L17.1562 20.707C17.4492 20.8711 17.6367 21.0645 17.8183 21.3867C17.8828 21.5098 17.9062 22.2305 17.9297 25.4414C17.959 29.2734 17.959 29.3496 18.082 29.5078C18.1465 29.5957 18.2754 29.7246 18.3633 29.7891C18.5215 29.9121 18.5859 29.9121 21.375 29.9121C24.2051 29.9121 24.2344 29.9121 24.6211 29.7773C25.6875 29.4082 26.5488 28.4414 26.7715 27.375C26.8125 27.1641 26.8359 25.5527 26.8359 22.3828V17.6953H27.2344C28.3359 17.6953 29.2969 17.1094 29.7715 16.1426C29.9707 15.7383 29.9707 15.7266 29.9707 14.9414C29.9707 13.6055 30.6445 14.3965 23.1211 6.87891C15.6445 -0.603514 16.3945 0.0410175 15.1172 0.0117207C14.4551 1.90735e-06 14.3555 0.0117207 14.0449 0.140627ZM15.4922 1.81641C15.8379 1.98047 28.084 14.2441 28.2129 14.543C28.3359 14.8418 28.3242 15.0938 28.1777 15.3867C27.9609 15.8379 27.7793 15.9023 26.6484 15.9375C25.5879 15.9668 25.5117 15.9902 25.2305 16.3711C25.1074 16.5293 25.1074 16.5938 25.0781 21.8438L25.0488 27.1582L24.8848 27.4336C24.7969 27.5859 24.6387 27.7793 24.5332 27.8555C24.123 28.1719 24 28.1836 21.7617 28.1836H19.6875V24.9023C19.6875 22.752 19.6641 21.5215 19.623 21.3164C19.3945 20.2148 18.5098 19.2656 17.373 18.9082C16.9863 18.7852 16.8574 18.7793 15.0586 18.7793C12.9609 18.7793 12.8555 18.791 12.1055 19.1719C11.3613 19.5469 10.6699 20.4727 10.4941 21.3164C10.4531 21.5215 10.4297 22.752 10.4297 24.9023V28.1836H8.35546C6.11718 28.1836 5.99413 28.1719 5.58397 27.8555C5.4785 27.7793 5.3203 27.5859 5.23241 27.4336L5.06835 27.1582L5.03905 21.8438C5.00975 16.5938 5.00975 16.5293 4.88671 16.3711C4.60546 15.9902 4.52928 15.9668 3.46874 15.9375C2.33788 15.9023 2.15624 15.8379 1.93944 15.3867C1.79296 15.0938 1.78124 14.8418 1.90428 14.543C2.02733 14.25 14.2793 1.98633 14.6191 1.81641C14.918 1.66992 15.1933 1.66992 15.4922 1.81641Z" />
                        </svg>
                        <h6>{{ translate('Dashboard') }}</h6>
                    </a>
                </li>
                @admin
                <li class="{{ Route::is('dashboard.artwork.categories.*') ? 'active' : '' }}">
                    <a href="{{ route('dashboard.artwork.categories.index') }}">
                        <svg width="30" height="30" viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M2.1879 0.0588875C1.74013 0.16722 1.08291 0.549993 0.765139 0.896654C0.606252 1.06999 0.367922 1.43109 0.245146 1.69831L0.0140381 2.18219V6.91268V11.6432L0.245146 12.1271C0.56292 12.7987 0.967359 13.2176 1.62457 13.5426L2.17345 13.8098H6.91117H11.6489L12.1978 13.5426C12.855 13.2176 13.2594 12.7987 13.5772 12.1271L13.8083 11.6432V6.90546V2.17497L13.5411 1.62609C13.2161 0.968876 12.7972 0.564437 12.1255 0.246663L11.6417 0.0155554L7.05561 0.00111103C4.43398 -0.00611115 2.34678 0.0227776 2.1879 0.0588875ZM11.49 1.22165C11.8872 1.3372 12.4866 1.93664 12.6022 2.33386C12.725 2.75996 12.725 11.0654 12.6022 11.4915C12.4866 11.8887 11.8872 12.4882 11.49 12.6037C11.2733 12.6687 10.06 12.6904 6.91117 12.6904C3.76232 12.6904 2.549 12.6687 2.33234 12.6037C1.93512 12.4882 1.33569 11.8887 1.22013 11.4915C1.09736 11.0654 1.09736 2.75996 1.22013 2.33386C1.32846 1.96553 1.93512 1.34443 2.28901 1.22887C2.66456 1.11332 11.0928 1.1061 11.49 1.22165Z" />
                            <path
                                d="M18.3655 0.0588875C17.9177 0.16722 17.2605 0.549993 16.9428 0.896654C16.7839 1.06999 16.5455 1.43109 16.4228 1.69831L16.1917 2.18219V6.91268V11.6432L16.4228 12.1271C16.7405 12.7987 17.145 13.2176 17.8022 13.5426L18.3511 13.8098H23.0888H27.8265L28.3754 13.5426C29.0326 13.2176 29.437 12.7987 29.7548 12.1271L29.9859 11.6432V6.90546V2.17497L29.7187 1.62609C29.3937 0.968876 28.9748 0.564437 28.3032 0.246663L27.8193 0.0155554L23.2332 0.00111103C20.6116 -0.00611115 18.5244 0.0227776 18.3655 0.0588875ZM27.6676 1.22165C28.0648 1.3372 28.6643 1.93664 28.7798 2.33386C28.9026 2.75996 28.9026 11.0654 28.7798 11.4915C28.6643 11.8887 28.0648 12.4882 27.6676 12.6037C27.2415 12.7265 18.9361 12.7265 18.51 12.6037C18.1127 12.4882 17.5133 11.8887 17.3977 11.4915C17.275 11.0654 17.275 2.75996 17.3977 2.33386C17.5061 1.96553 18.1127 1.34443 18.4666 1.22887C18.8422 1.11332 27.2704 1.1061 27.6676 1.22165Z" />
                            <path
                                d="M2.1879 16.2365C1.74013 16.3448 1.08291 16.7276 0.765139 17.0743C0.606252 17.2476 0.367922 17.6087 0.245146 17.8759L0.0140381 18.3598V23.0903V27.8208L0.245146 28.3047C0.56292 28.9763 0.967359 29.3952 1.62457 29.7202L2.17345 29.9874H6.91117H11.6489L12.1978 29.7202C12.855 29.3952 13.2594 28.9763 13.5772 28.3047L13.8083 27.8208V23.0831V18.3526L13.5411 17.8037C13.2161 17.1465 12.7972 16.742 12.1255 16.4243L11.6417 16.1932L7.05561 16.1787C4.43398 16.1715 2.34678 16.2004 2.1879 16.2365ZM11.49 17.3993C11.8872 17.5148 12.4866 18.1142 12.6022 18.5115C12.725 18.9376 12.725 27.243 12.6022 27.6691C12.4866 28.0663 11.8872 28.6658 11.49 28.7813C11.0639 28.9041 2.75845 28.9041 2.33234 28.7813C1.93512 28.6658 1.33569 28.0663 1.22013 27.6691C1.09736 27.243 1.09736 18.9376 1.22013 18.5115C1.32846 18.1431 1.93512 17.522 2.28901 17.4065C2.66456 17.2909 11.0928 17.2837 11.49 17.3993Z" />
                            <path
                                d="M22.0559 16.2365C21.1315 16.3737 19.9543 16.8359 19.1237 17.3992C18.5315 17.7965 17.5204 18.8942 17.1593 19.5153C16.4154 20.8081 16.1916 21.6458 16.1988 23.0903C16.1988 24.2458 16.2927 24.7441 16.6682 25.683C17.311 27.3008 18.7482 28.7741 20.3443 29.453C21.2976 29.8574 21.9259 29.9802 23.0887 29.9802C24.5331 29.9874 25.3709 29.7563 26.6636 29.0196C27.4509 28.5646 28.5631 27.4524 29.0181 26.6652C29.7547 25.3869 29.9786 24.5419 29.9786 23.0903C29.9786 21.6386 29.7475 20.772 29.0181 19.5153C28.5703 18.7426 27.5159 17.6809 26.707 17.1826C25.342 16.3448 23.652 16.0054 22.0559 16.2365ZM24.4609 17.4787C25.1831 17.6809 25.6742 17.8903 26.2159 18.2514C29.2997 20.2592 29.7547 24.5708 27.162 27.1636C24.5692 29.7563 20.2576 29.3013 18.2499 26.2175C16.8632 24.1086 17.0438 21.3064 18.6832 19.3709C19.5498 18.3526 20.6548 17.7026 22.0054 17.4137C22.5831 17.2909 23.8976 17.327 24.4609 17.4787Z" />
                        </svg>
                        <h6>{{ translate('Categories') }}</h6>
                    </a>
                </li>
                @endadmin

                @adminOrAgent
                <li class="{{ Route::is('dashboard.artist.*') ? 'active' : '' }}">
                    <a href="{{ route('dashboard.artist.index') }}">
                        <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor"
                            class="bi bi-person-square" viewBox="0 0 16 16">
                            <path d="M11 6a3 3 0 1 1-6 0 3 3 0 0 1 6 0" />
                            <path
                                d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2zm12 1a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1v-1c0-1-1-4-6-4s-6 3-6 4v1a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1z" />
                        </svg>
                        <h6>{{ translate('Artists') }}</h6>
                    </a>
                </li>
                @endadminOrAgent
                <li class="{{ Route::is('dashboard.artworks.*') ? 'active' : '' }}">
                    <a href="{{ route('dashboard.artworks.index') }}">
                        <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor"
                            class="bi bi-palette" viewBox="0 0 16 16">
                            <path
                                d="M8 5a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3m4 3a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3M5.5 7a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0m.5 6a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3" />
                            <path
                                d="M16 8c0 3.15-1.866 2.585-3.567 2.07C11.42 9.763 10.465 9.473 10 10c-.603.683-.475 1.819-.351 2.92C9.826 14.495 9.996 16 8 16a8 8 0 1 1 8-8m-8 7c.611 0 .654-.171.655-.176.078-.146.124-.464.07-1.119-.014-.168-.037-.37-.061-.591-.052-.464-.112-1.005-.118-1.462-.01-.707.083-1.61.704-2.314.369-.417.845-.578 1.272-.618.404-.038.812.026 1.16.104.343.077.702.186 1.025.284l.028.008c.346.105.658.199.953.266.653.148.904.083.991.024C14.717 9.38 15 9.161 15 8a7 7 0 1 0-7 7" />
                        </svg>
                        <h6>{{ translate('Artwork') }}</h6>
                    </a>
                </li>


                <li class="{{ Route::is('dashboard.order.list') ? 'active' : '' }}">
                    <a href="{{route('dashboard.order.list')}}">
                        <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor"
                            class="bi bi-basket" viewBox="0 0 16 16">
                            <path
                                d="M5.757 1.071a.5.5 0 0 1 .172.686L3.383 6h9.234L10.07 1.757a.5.5 0 1 1 .858-.514L13.783 6H15a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1v4.5a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 1 13.5V9a1 1 0 0 1-1-1V7a1 1 0 0 1 1-1h1.217L5.07 1.243a.5.5 0 0 1 .686-.172zM2 9v4.5A1.5 1.5 0 0 0 3.5 15h9a1.5 1.5 0 0 0 1.5-1.5V9H2zM1 7v1h14V7H1zm3 3a.5.5 0 0 1 .5.5v3a.5.5 0 0 1-1 0v-3A.5.5 0 0 1 4 10zm2 0a.5.5 0 0 1 .5.5v3a.5.5 0 0 1-1 0v-3A.5.5 0 0 1 6 10zm2 0a.5.5 0 0 1 .5.5v3a.5.5 0 0 1-1 0v-3A.5.5 0 0 1 8 10zm2 0a.5.5 0 0 1 .5.5v3a.5.5 0 0 1-1 0v-3a.5.5 0 0 1 .5-.5zm2 0a.5.5 0 0 1 .5.5v3a.5.5 0 0 1-1 0v-3a.5.5 0 0 1 .5-.5z" />
                        </svg>
                        <h6>{{ translate('Orders') }}</h6>
                    </a>
                </li>
                <li class="{{ Route::is('dashboard.bidding.list') ? 'active' : '' }}">
                    <a href="{{route('dashboard.bidding.list')}}">
                        <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor"
                            class="bi bi-person-raised-hand" viewBox="0 0 16 16">
                            <path
                                d="M6 6.207v9.043a.75.75 0 0 0 1.5 0V10.5a.5.5 0 0 1 1 0v4.75a.75.75 0 0 0 1.5 0v-8.5a.25.25 0 1 1 .5 0v2.5a.75.75 0 0 0 1.5 0V6.5a3 3 0 0 0-3-3H6.236a.998.998 0 0 1-.447-.106l-.33-.165A.83.83 0 0 1 5 2.488V.75a.75.75 0 0 0-1.5 0v2.083c0 .715.404 1.37 1.044 1.689L5.5 5c.32.32.5.754.5 1.207Z" />
                            <path d="M8 3a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Z" />
                        </svg>
                        <h6>{{ translate('Bidding') }}</h6>
                    </a>
                </li>
                <li class="{{ Route::is('dashboard.winner.list') ? 'active' : '' }}">
                    <a href="{{route('dashboard.winner.list')}}">
                        <svg width="30" height="30" viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M6.49215 0.533203C6.3398 0.621094 6.28121 0.9375 6.24019 1.97461L6.19918 2.92969H4.89254H3.58004L3.46285 3.08203C3.1816 3.43945 3.37496 5.49023 3.82027 6.82031C4.44137 8.69531 5.77144 10.3477 7.48238 11.3672C7.8691 11.5957 7.92769 11.6543 8.17379 12.0938C8.63668 12.9141 9.20504 13.6582 9.9023 14.3555C10.8339 15.2871 11.789 15.9199 12.832 16.2949C13.0429 16.3652 13.2304 16.459 13.2539 16.4883C13.2773 16.5234 13.3007 17.666 13.3007 19.0254V21.498L11.9472 21.5156C10.6054 21.5332 10.5937 21.5332 10.4824 21.6738C10.3828 21.7969 10.3711 21.9141 10.3711 23.0039V24.1934L9.26363 24.2109C8.2734 24.2285 8.14449 24.2402 8.03316 24.3398C7.91012 24.4512 7.91012 24.4922 7.91012 26.5547V28.6523H5.30855C3.61519 28.6523 2.6484 28.6758 2.53121 28.7168C2.23824 28.8164 2.16793 29.168 2.39058 29.4258C2.47262 29.5254 3.14644 29.5312 15 29.5312C27.4746 29.5312 27.5214 29.5312 27.6269 29.4141C27.7734 29.25 27.7617 28.9688 27.6035 28.8105C27.4804 28.6816 27.4687 28.6816 24.7558 28.6641L22.0312 28.6465V26.5781C22.0312 24.5742 22.0253 24.5039 21.9082 24.3516L21.791 24.1992H20.6836H19.5761L19.5586 22.9746C19.541 21.8672 19.5293 21.7383 19.4296 21.627C19.3242 21.5098 19.2656 21.5039 17.9765 21.5039H16.6406V18.9668V16.4238L17.2207 16.207C18.3046 15.7969 19.2011 15.1875 20.0976 14.2559C20.8476 13.4824 21.2461 12.9375 21.8789 11.8242C21.9902 11.6309 22.1191 11.502 22.3535 11.3672C23.7246 10.582 25.0019 9.1875 25.6992 7.71094C26.2617 6.50977 26.4785 5.5957 26.5253 4.18359C26.5722 2.82422 26.6953 2.92969 25.0312 2.92969H23.748L23.707 1.89258C23.6777 1.05469 23.6484 0.820312 23.5664 0.673828L23.4609 0.498047L15.0234 0.486328C9.45699 0.474609 6.5566 0.492188 6.49215 0.533203ZM22.875 1.85742C22.9394 2.67188 22.9218 4.94531 22.8515 5.68359C22.7109 7.07227 22.3769 8.61914 21.9726 9.72656C21.7148 10.4414 21.0996 11.666 20.6953 12.2754C19.6464 13.8516 18.2226 15 16.6992 15.498C16.3418 15.6094 16.0371 15.8145 15.9257 16.0137C15.8671 16.1074 15.8437 16.8105 15.8203 18.8086L15.791 21.4746L15.0175 21.4922L14.2382 21.5098V18.9258C14.2382 16.5 14.2324 16.3301 14.1269 16.125C13.9511 15.791 13.7695 15.6562 13.1777 15.4336C9.9609 14.2383 7.74019 10.7051 7.17769 5.88281C7.07808 5.03906 7.04879 2.53125 7.12496 1.74609L7.16597 1.34766H15H22.8339L22.875 1.85742ZM6.17574 4.31836C6.25777 5.57227 6.3398 6.39258 6.45113 7.02539C6.5859 7.81055 6.9023 9.05273 7.11324 9.63867C7.19527 9.86133 7.25387 10.0488 7.24801 10.0605C7.20699 10.0957 6.38668 9.33984 6.11129 9.01758C4.99215 7.69922 4.37105 6.16406 4.24801 4.37695L4.20699 3.80859H5.17379H6.14058L6.17574 4.31836ZM25.7519 4.37695C25.6054 6.46875 24.8027 8.21484 23.3554 9.5918C23.039 9.89062 22.7695 10.1309 22.7519 10.1191C22.7402 10.1016 22.7812 9.96094 22.8457 9.80273C23.291 8.66602 23.789 6.04688 23.789 4.80469C23.789 4.59375 23.8066 4.2832 23.8242 4.11328L23.8652 3.80859H24.832H25.7929L25.7519 4.37695ZM18.6328 23.291V24.1992H14.9707H11.3086V23.291V22.3828H14.9707H18.6328V23.291ZM21.1523 26.8652V28.6523H15H8.84762V26.8652V25.0781H15H21.1523V26.8652Z" />
                            <path
                                d="M14.8066 3.52734C14.7539 3.56836 14.4551 4.13086 14.1445 4.77539C13.8281 5.41992 13.5527 5.96484 13.5234 5.98242C13.4941 6 12.9023 6.09961 12.2051 6.20508C11.5137 6.31055 10.8809 6.42188 10.8047 6.45703C10.6465 6.5332 10.5469 6.7793 10.6055 6.94336C10.6465 7.04883 11.2207 7.62891 12.2402 8.5957L12.6211 8.95312L12.4043 10.2305C12.2813 10.9395 12.1875 11.584 12.1875 11.6719C12.1875 11.8887 12.3809 12.0703 12.6035 12.0703C12.7266 12.0703 13.1895 11.8594 13.9512 11.4551C14.5957 11.1152 15.1465 10.8398 15.1758 10.8398C15.2109 10.8398 15.7207 11.1152 16.3125 11.4551C17.4492 12.1055 17.6543 12.1699 17.8711 11.9531C17.9356 11.8887 17.9883 11.7656 17.9883 11.6719C17.9883 11.584 17.8945 10.9395 17.7715 10.2305L17.5547 8.95312L17.9063 8.625C18.832 7.75195 19.4766 7.10742 19.5469 6.97852C19.6406 6.79688 19.5527 6.53906 19.3652 6.45703C19.2891 6.42188 18.6563 6.30469 17.959 6.19922C17.2676 6.09961 16.6758 6 16.6523 5.98242C16.6231 5.96484 16.3477 5.41992 16.0313 4.77539C15.7207 4.13086 15.4219 3.56836 15.3691 3.52734C15.3164 3.49219 15.1875 3.45703 15.0879 3.45703C14.9883 3.45703 14.8594 3.49219 14.8066 3.52734ZM15.5273 5.85352C15.7793 6.36914 16.0195 6.80273 16.0488 6.82031C16.0781 6.84375 16.4824 6.9082 16.9453 6.97266C17.4082 7.03711 17.8711 7.10156 17.9824 7.11914L18.1816 7.1543L17.4375 7.9043C16.582 8.77148 16.6231 8.63672 16.8457 9.83789C16.9277 10.2715 16.9922 10.6699 16.9922 10.7227C16.9922 10.8047 16.8047 10.7227 16.1309 10.3652C15.6504 10.1133 15.1934 9.90234 15.0996 9.90234C15.0117 9.90234 14.5137 10.1133 13.9981 10.377C13.0664 10.8398 13.0547 10.8457 13.0898 10.6816C13.2656 9.80859 13.418 8.80664 13.3945 8.70117C13.377 8.63086 13.0313 8.26172 12.627 7.88086C12.2227 7.5 11.9004 7.17773 11.918 7.16602C11.9297 7.14844 12.3809 7.07812 12.9141 7.00195C13.459 6.92578 13.9453 6.83203 14.0215 6.7793C14.0918 6.73242 14.3438 6.30469 14.5898 5.80664C14.8301 5.32031 15.0352 4.92188 15.041 4.92188C15.0527 4.92188 15.2695 5.34375 15.5273 5.85352Z" />
                        </svg>
                        <h6>{{translate('Winner')}}</h6>
                    </a>
                </li>
                @admin

                <li class="{{ Route::is('dashboard.deposits.list') ? 'active' : '' }}">
                    <a href="{{ route('dashboard.deposits.list') }}">
                        <svg width="30" height="30" viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg">
                            <g clip-path="url(#clip0_692_2355)">
                                <path
                                    d="M4.98884 0.0953236C4.28571 0.256681 3.75 0.635256 3.42857 1.20622L3.24777 1.51653L3.22768 8.20053L3.21429 14.8907H1.60714H0V17.8697V20.8486H15H30V17.8697V14.8907H28.3929H26.7857L26.7723 8.35569L26.7522 1.82683L26.5982 1.47308C26.404 1.03245 25.9688 0.573195 25.5335 0.349773C24.7902 -0.0225945 25.2991 -0.00397491 14.8996 0.0022316C6.87054 0.0084362 5.33036 0.0208492 4.98884 0.0953236ZM7.39955 1.21863C7.27902 1.82683 6.77679 2.47848 6.13393 2.86326C5.71875 3.1115 4.82143 3.4094 4.47991 3.4094H4.28571V2.62742C4.28571 1.55376 4.40625 1.33034 5.10268 1.10692C5.38393 1.02004 5.67188 0.995213 6.45536 0.989006H7.44643L7.39955 1.21863ZM21.4955 1.1876C21.4955 1.47308 21.8371 2.35435 22.1049 2.76396C22.808 3.83762 24.1808 4.7251 25.3661 4.87405L25.7143 4.91749V12.3835V19.8557H23.7054H21.6964L22.0714 19.3405C22.7277 18.4407 23.1629 17.4849 23.4174 16.3802C23.5848 15.6479 23.5781 14.0777 23.4107 13.3392C23.0424 11.7504 22.279 10.4472 21.0335 9.29902C19.7946 8.14468 18.3951 7.43718 16.6741 7.09584C15.8772 6.93448 14.1228 6.93448 13.3259 7.09584C11.5915 7.44339 10.2254 8.13227 8.96652 9.29902C7.70759 10.4658 6.96429 11.7318 6.58929 13.3392C6.42188 14.0777 6.41518 15.6479 6.58259 16.3802C6.83705 17.4849 7.27232 18.4407 7.92857 19.3405L8.30357 19.8557H6.29464H4.28571L4.29911 12.1414L4.3192 4.43341L4.52009 4.41479C5.34375 4.34652 6.46875 3.92451 7.07812 3.45905C7.77455 2.92532 8.30357 2.11852 8.45759 1.35517L8.53795 0.989006H15.0134H21.4955V1.1876ZM24.8438 1.13795C25.5469 1.47929 25.7143 1.85786 25.7143 3.08047C25.7143 4.03001 25.7478 3.99277 25.058 3.77556C23.8259 3.39078 22.7812 2.2985 22.5871 1.1876L22.5469 0.976593L23.5781 1.00142C24.4219 1.02004 24.6496 1.04486 24.8438 1.13795ZM16.1384 8.03297C17.7121 8.25018 19.1451 8.92665 20.2902 9.9879C23.0759 12.5697 23.2366 16.6223 20.6585 19.4212L20.2634 19.8557H15H9.7433L9.42857 19.5205C8.22321 18.2483 7.60714 16.8271 7.52009 15.139C7.39286 12.4828 8.97991 9.96307 11.5781 8.72185C13.0045 8.03917 14.5446 7.80334 16.1384 8.03297ZM3.21429 17.8697V19.8557H2.14286H1.07143V17.8697V15.8837H2.14286H3.21429V17.8697ZM28.9286 17.8697V19.8557H27.8571H26.7857V17.8697V15.8837H27.8571H28.9286V17.8697Z" />
                                <path
                                    d="M12.2678 12.2284C11.2634 12.4083 10.433 13.1593 10.1719 14.1088L10.0982 14.3943H9.62945C9.22766 14.3943 9.1473 14.4129 9.00668 14.5495C8.7857 14.7481 8.7857 15.0335 9.00668 15.2321C9.1473 15.3687 9.22766 15.3873 9.62945 15.3873H10.0982L10.1719 15.6728C10.5134 16.9264 11.7589 17.7208 13.1786 17.5967C13.6942 17.5532 14.183 17.3236 14.5111 16.9699C14.712 16.7526 15.1004 16.0824 15.3281 15.5549L15.4018 15.3873H17.1094H18.8236L18.7835 15.5238C18.5826 16.1258 17.7857 16.6285 17.029 16.6285C16.5335 16.6285 16.2991 17.156 16.6473 17.4788C16.808 17.6277 16.8549 17.6339 17.2299 17.6029C17.8393 17.547 18.2879 17.4043 18.7634 17.1064C19.279 16.7899 19.7076 16.2375 19.8281 15.7286L19.9085 15.3873H20.3705C20.7723 15.3873 20.8527 15.3687 20.9933 15.2321C21.1004 15.1391 21.1607 15.0087 21.1607 14.8908C21.1607 14.7729 21.1004 14.6426 20.9933 14.5495C20.8527 14.4129 20.7723 14.3943 20.3705 14.3943H19.9085L19.8281 14.053C19.7076 13.5441 19.279 12.9917 18.7634 12.6752C18.2009 12.3277 17.7187 12.1911 17.0089 12.1911C16.5 12.1911 16.3995 12.2098 16.0781 12.3773C15.8839 12.4766 15.6161 12.6752 15.4888 12.8117C15.2812 13.0228 14.9263 13.6434 14.6786 14.2205L14.5982 14.3943H12.8906H11.183L11.25 14.2392C11.5312 13.5441 12.1473 13.1531 12.9375 13.1531C13.2656 13.1531 13.5268 12.9359 13.5268 12.6566C13.5268 12.5387 13.4665 12.4083 13.3594 12.3153C13.1853 12.1477 12.8504 12.1229 12.2678 12.2284ZM17.8527 13.3331C18.3214 13.5317 18.6495 13.8482 18.7835 14.2516L18.8236 14.3943H17.3169C16.3259 14.3943 15.8036 14.3695 15.8036 14.3323C15.8036 14.295 15.8906 14.1088 15.9978 13.9102C16.1853 13.5627 16.3728 13.3703 16.6406 13.2214C16.8348 13.1158 17.4643 13.1779 17.8527 13.3331ZM14.1964 15.4494C14.1964 15.5611 13.8549 16.1569 13.7009 16.3058C13.3794 16.6409 12.9643 16.7092 12.3348 16.5354C11.8125 16.3865 11.471 16.0762 11.25 15.5424L11.183 15.3873H12.6897C13.6808 15.3873 14.1964 15.4121 14.1964 15.4494Z" />
                                <path
                                    d="M12.0267 21.972L11.8526 22.0961V23.4615V24.8206H10.9553C10.1517 24.8206 10.0445 24.833 9.88382 24.9509C9.7499 25.044 9.70972 25.1309 9.70972 25.3047C9.70972 25.5281 9.81686 25.6336 12.0066 27.663C13.982 29.4938 14.3303 29.7855 14.4977 29.7855C14.6718 29.7855 15.02 29.4876 17.0222 27.6258C18.7432 26.037 19.3526 25.435 19.3526 25.3295C19.3526 25.2488 19.2655 25.0999 19.1584 25.0006L18.9642 24.8206H18.0869H17.2097V23.5111V22.2016L17.0155 22.0216L16.8213 21.8417H14.5111C12.2811 21.8417 12.2008 21.8479 12.0267 21.972ZM16.1383 24.169C16.1383 25.5095 16.1383 25.5095 16.3057 25.6584C16.4463 25.795 16.5267 25.8136 16.9887 25.8136H17.5111L16.0378 27.1789C15.2276 27.9299 14.5378 28.5443 14.4977 28.5443C14.4575 28.5443 13.7678 27.9299 12.9575 27.1789L11.4843 25.8136H11.9999C12.4486 25.8136 12.5423 25.795 12.703 25.6646L12.8905 25.5157L12.9106 24.1752L12.9307 22.8347H14.5378H16.1383V24.169Z" />
                            </g>
                            <defs>
                                <clipPath id="clip0_692_2355">
                                    <rect width="30" height="30" fill="white" />
                                </clipPath>
                            </defs>
                        </svg>
                        <h6>{{translate('Deposits')}}</h6>
                    </a>
                </li>

                <li class="{{ Route::is('dashboard.art-gallery.*') ? 'active' : '' }}">
                    <a href="{{ route('dashboard.art-gallery.index') }}">
                        <svg width="30" height="30" viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M11.209 0.0820312C10.6172 0.199219 10.2422 0.328125 9.63868 0.632812C8.94141 0.996094 8.33789 1.45898 7.69336 2.13281C7.08399 2.76562 6.80274 3.25781 6.64453 3.9668C6.46875 4.75195 6.52735 5.05078 7.3418 7.82227C8.05664 10.2598 8.06836 10.2949 8.16797 11.3086C8.27344 12.3809 8.36719 12.9023 8.52539 13.3945C8.79493 14.1914 9.41016 15.1641 10.0137 15.7207L10.3125 16.002L10.3008 16.9805L10.2832 17.959L7.64649 18.8848C6.19922 19.3887 4.82227 19.8984 4.58789 20.0039C2.88281 20.8125 1.64063 22.3359 1.125 24.2461C0.978516 24.8086 0.972656 24.8438 0.949219 27.2578L0.925781 29.7012L1.07813 29.8535L1.22461 30H8.4375H15.6504L15.791 29.8535C15.8848 29.7656 15.9375 29.6426 15.9375 29.5312C15.9375 29.4199 15.8848 29.2969 15.791 29.209C15.6621 29.0742 15.6035 29.0625 15.0879 29.0625H14.5313V26.5488V24.0293L15.3516 22.623C15.8379 21.791 16.1719 21.1582 16.1719 21.0645C16.1719 20.748 15.7617 20.5254 15.4688 20.6836C15.4102 20.7129 15.082 21.2285 14.7363 21.8262C14.3848 22.4238 14.0801 22.9043 14.0566 22.8984C14.0274 22.8867 13.3828 21.8203 12.627 20.5195L11.25 18.1582V17.3906C11.25 16.9746 11.2676 16.6406 11.2969 16.6523C12.9609 17.4902 14.8301 17.5605 16.4004 16.8398C16.6406 16.7285 16.8399 16.6406 16.8516 16.6406C16.8633 16.6406 16.875 16.7344 16.875 16.8457C16.875 17.2852 17.3672 17.502 17.666 17.1973C17.8008 17.0684 17.8125 17.0098 17.8125 16.5059V15.9492L18.0117 15.7969C18.334 15.5566 18.9609 14.7246 19.2481 14.1738C19.6289 13.4355 19.7871 12.8145 19.9453 11.3965L20.0801 10.166L20.8067 7.73438L21.5274 5.30273L21.5332 4.6582C21.5332 3.60938 21.2578 2.98242 20.4024 2.0918C19.7578 1.42969 19.1133 0.949219 18.3691 0.580078C17.4961 0.152344 17.0215 0.0410156 15.9961 0.0351562C15.1816 0.0292969 15.1231 0.0410156 14.6074 0.222656L14.0625 0.416016L13.5234 0.228516C13.0606 0.0703125 12.8789 0.0410156 12.3047 0.0234375C11.8945 0.0117188 11.4668 0.0351562 11.209 0.0820312ZM12.832 0.996094C12.9785 1.03125 13.2305 1.11328 13.3887 1.18359C13.7813 1.34766 14.3496 1.34766 14.7246 1.18359C15.627 0.785156 16.8926 0.884766 18.0176 1.44727C18.9785 1.92773 20.0098 2.87695 20.3789 3.62695C20.584 4.04297 20.5957 4.0957 20.5957 4.62305C20.5899 5.16211 20.5664 5.26758 19.9863 7.20703C19.6524 8.32031 19.3652 9.26367 19.3418 9.30469C19.2832 9.41016 18.8672 8.94141 18.6914 8.57227C18.5156 8.20312 18.3984 7.61719 18.3984 7.11328C18.3984 6.54492 18.3164 6.47461 17.6074 6.42188C16.2422 6.32227 15.2344 5.82422 14.4727 4.86914C14.2969 4.65234 14.2324 4.61133 14.0625 4.61133C13.8926 4.61133 13.8281 4.65234 13.6523 4.86914C12.8789 5.83594 11.8887 6.32812 10.5117 6.42188C10.0371 6.45703 9.94922 6.48047 9.83204 6.60352C9.72657 6.7207 9.70313 6.80273 9.71485 7.06641C9.73829 7.58203 9.6211 8.13867 9.4043 8.58398C9.1875 9.0293 8.8125 9.45703 8.76563 9.31055C8.74805 9.26367 8.4668 8.32031 8.13868 7.20703C7.46485 4.91602 7.41797 4.63477 7.60547 4.00195C7.76953 3.47461 7.99805 3.12305 8.52539 2.60742C9.64454 1.5 10.8106 0.960938 12.1289 0.943359C12.3691 0.943359 12.6856 0.966797 12.832 0.996094ZM14.4141 6.16992C15.0293 6.72656 16.002 7.1543 16.957 7.28906L17.4316 7.35938L17.5254 7.88086C17.7188 8.92383 18.0938 9.57422 18.8555 10.2012L19.1074 10.4062L19.0137 11.3086C18.8906 12.4746 18.7441 13.0898 18.457 13.6699C17.7422 15.0938 16.5 16.0195 14.9121 16.3184C13.0898 16.6641 11.1563 15.873 10.0488 14.3262C9.49805 13.5527 9.29297 12.9375 9.14063 11.584C9.07618 11.0332 9.02344 10.5352 9.02344 10.4824C9.02344 10.4355 9.15235 10.2832 9.31641 10.1543C10.0723 9.53906 10.4883 8.73047 10.6348 7.61133L10.6699 7.3418L11.0449 7.30664C11.959 7.21875 13.0781 6.74414 13.6875 6.18164C13.875 6.00586 14.0449 5.86523 14.0508 5.85938C14.0625 5.85938 14.2266 6 14.4141 6.16992ZM11.9473 21.2051C12.6973 22.4941 13.3066 23.5723 13.3008 23.5957C13.2832 23.6543 11.1973 24.252 11.168 24.2051C11.1563 24.1875 11.0625 23.6426 10.957 22.998L10.7637 21.8262L9.65039 20.7012C8.90039 19.9453 8.56055 19.5645 8.61914 19.541C9.41016 19.248 10.4707 18.8789 10.5176 18.873C10.5527 18.8672 11.1973 19.9219 11.9473 21.2051ZM8.70704 21.1055L9.88477 22.2949L10.1074 23.6426C10.2246 24.3809 10.3594 25.0488 10.4063 25.1191C10.5586 25.3594 10.7461 25.3418 12.1699 24.9316C12.9082 24.7207 13.5352 24.5508 13.5527 24.5508C13.5762 24.5508 13.5938 25.5645 13.5938 26.8066V29.0625H12.8906H12.1875V28.2715C12.1875 27.5039 12.1816 27.4688 12.041 27.334L11.9004 27.1875H9.375H6.84961L6.70899 27.334C6.56836 27.4688 6.5625 27.5039 6.5625 28.2715V29.0625H5.86524H5.16797L5.14453 27.1758C5.1211 25.4648 5.10352 25.2363 4.99219 24.8145C4.72852 23.8535 4.23633 22.875 3.65625 22.166L3.45117 21.9199L3.87891 21.5684C4.4707 21.082 5.06836 20.7832 6.35742 20.3262C6.9668 20.1094 7.48243 19.9277 7.5 19.9277C7.51758 19.9219 8.0625 20.4551 8.70704 21.1055ZM3.25195 23.2031C3.59766 23.7246 3.89649 24.375 4.05469 24.9492C4.16602 25.3535 4.1836 25.5938 4.20703 27.2344L4.23047 29.0625H3.05274H1.875V27.2227C1.875 25.2246 1.92188 24.7441 2.20313 23.9531C2.41992 23.3438 2.8125 22.6582 2.90625 22.7344C2.94141 22.7695 3.09961 22.9805 3.25195 23.2031ZM11.25 28.5938V29.0625H9.375H7.5V28.5938V28.125H9.375H11.25V28.5938Z" />
                            <path
                                d="M11.3145 2.02154C10.5821 2.1856 9.76178 2.66021 9.19342 3.25786C8.54889 3.93755 8.39068 4.377 8.70709 4.6231C8.98834 4.84575 9.21099 4.76958 9.48638 4.37115C10.002 3.627 10.8926 3.04107 11.6895 2.92388C12.2754 2.83599 12.3692 2.80083 12.4981 2.62505C12.6329 2.44341 12.6036 2.23247 12.4102 2.05083C12.2579 1.91021 11.8829 1.89849 11.3145 2.02154Z" />
                            <path
                                d="M11.6895 3.59766C11.1211 3.7793 10.5996 4.14844 10.2832 4.59961C10.0547 4.91602 10.0313 5.0625 10.1719 5.26172C10.3945 5.57813 10.7637 5.53125 11.0274 5.16211C11.3027 4.75781 11.7598 4.50586 12.375 4.42383C12.8379 4.36524 13.0254 3.9961 12.7676 3.66797C12.6621 3.53321 12.6094 3.51563 12.2871 3.52149C12.0879 3.52149 11.8184 3.55664 11.6895 3.59766Z" />
                            <path
                                d="M12.1582 8.95898C11.8945 9.07617 11.748 9.31055 11.748 9.61523C11.748 9.86133 11.7773 9.92578 11.9414 10.0898C12.1055 10.2539 12.1699 10.2832 12.4219 10.2832C12.6738 10.2832 12.7383 10.2539 12.9023 10.0898C13.0664 9.92578 13.0957 9.86133 13.0957 9.60937C13.0957 9.36328 13.0664 9.29297 12.9141 9.13476C12.7207 8.9414 12.375 8.86523 12.1582 8.95898Z" />
                            <path
                                d="M15.4395 8.95898C15.1758 9.07617 15.0293 9.31055 15.0293 9.61523C15.0293 9.86133 15.0586 9.92578 15.2227 10.0898C15.3867 10.2539 15.4512 10.2832 15.7031 10.2832C15.9551 10.2832 16.0195 10.2539 16.1836 10.0898C16.3477 9.92578 16.377 9.86133 16.377 9.60937C16.377 9.36328 16.3477 9.29297 16.1953 9.13476C16.002 8.9414 15.6562 8.86523 15.4395 8.95898Z" />
                            <path
                                d="M13.7402 10.459C13.5996 10.5938 13.5938 10.623 13.5938 11.4844C13.5938 12.3457 13.5996 12.375 13.7402 12.5098C13.8281 12.6035 13.9512 12.6562 14.0625 12.6562C14.1738 12.6562 14.2969 12.6035 14.3848 12.5098C14.5254 12.375 14.5312 12.3457 14.5312 11.4844C14.5312 10.623 14.5254 10.5938 14.3848 10.459C14.2969 10.3652 14.1738 10.3125 14.0625 10.3125C13.9512 10.3125 13.8281 10.3652 13.7402 10.459Z" />
                            <path
                                d="M12.3339 13.2715C11.6718 13.9278 13.371 14.7715 14.7246 14.4493C15.6796 14.2266 16.1835 13.7051 15.8203 13.3125C15.6503 13.1309 15.4218 13.0899 15.2402 13.2012C14.4843 13.6875 13.6054 13.711 13.0136 13.2715C12.7558 13.084 12.5156 13.084 12.3339 13.2715Z" />
                            <path
                                d="M18.668 17.4082C18.3047 17.4961 17.7715 17.8066 17.5137 18.0879C17.3848 18.2285 17.1914 18.5215 17.0918 18.7383C16.916 19.1133 16.9043 19.166 16.8867 20.0098C16.8633 21.0176 16.9453 21.5332 17.2207 22.125C17.4141 22.541 17.7715 22.957 18.0762 23.1211L18.2812 23.2324V25.207V27.1875H17.7246C17.209 27.1875 17.1504 27.1992 17.0215 27.334C16.875 27.4746 16.875 27.4863 16.875 28.5938C16.875 29.7012 16.875 29.7129 17.0215 29.8535L17.1621 30H22.9687H28.7754L28.916 29.8535C29.0625 29.7129 29.0625 29.7012 29.0625 28.5938C29.0625 27.4863 29.0625 27.4746 28.916 27.334C28.7871 27.1992 28.7285 27.1875 28.2129 27.1875H27.6562V25.207V23.2324L27.8613 23.1211C28.166 22.957 28.5234 22.541 28.7168 22.125C28.9922 21.5332 29.0742 21.0176 29.0508 20.0039L29.0332 19.125L28.8164 18.6797C28.5527 18.1465 28.2129 17.8184 27.668 17.5605L27.2754 17.373L23.0859 17.3613C20.6777 17.3555 18.8027 17.3789 18.668 17.4082ZM20.625 19.2188V20.1562H19.2187H17.8125V19.8281C17.8125 19.6465 17.8418 19.3887 17.8828 19.2539C17.9707 18.9551 18.4629 18.4512 18.75 18.3574C18.8613 18.3223 19.3301 18.293 19.793 18.2871L20.625 18.2812V19.2188ZM24.375 19.2188V20.1562H22.9687H21.5625V19.2188V18.2812H22.9687H24.375V19.2188ZM27.1523 18.3516C27.4746 18.4453 27.9609 18.9316 28.0547 19.2539C28.0957 19.3887 28.125 19.6465 28.125 19.8281V20.1562H26.7187H25.3125V19.2188V18.2812H26.1094C26.5664 18.2812 27.0117 18.3105 27.1523 18.3516ZM20.5371 21.2754C20.2734 22.459 19.0312 22.9043 18.2988 22.0723C18.1406 21.8906 17.8711 21.3105 17.8711 21.1523C17.8711 21.1172 18.3984 21.0938 19.2246 21.0938H20.5781L20.5371 21.2754ZM24.2871 21.2754C24.0234 22.459 22.7812 22.9043 22.0488 22.0723C21.8906 21.8906 21.6211 21.3105 21.6211 21.1523C21.6211 21.1172 22.1484 21.0938 22.9746 21.0938H24.3281L24.2871 21.2754ZM28.0664 21.1523C28.0664 21.3105 27.7969 21.8906 27.6387 22.0723C27.1465 22.6348 26.291 22.6348 25.7988 22.0723C25.6406 21.8906 25.3711 21.3105 25.3711 21.1523C25.3711 21.1172 25.8926 21.0938 26.7187 21.0938C27.5449 21.0938 28.0664 21.1172 28.0664 21.1523ZM21.3867 22.752C21.5801 22.9629 21.7969 23.127 22.043 23.2383C22.3711 23.3906 22.4766 23.4082 22.9687 23.4082C23.4609 23.4082 23.5664 23.3906 23.8945 23.2383C24.1406 23.1211 24.3574 22.9629 24.5508 22.752L24.8437 22.4297L25.1367 22.752C25.4648 23.1094 25.9512 23.3613 26.4258 23.4199L26.7187 23.4551V25.3184V27.1875H25.7812H24.8437V25.9277C24.8437 24.6621 24.8437 24.6621 24.6973 24.5215L24.5566 24.375H22.9687H21.3809L21.2402 24.5215C21.0937 24.6621 21.0937 24.6621 21.0937 25.9277V27.1875H20.1562H19.2187V25.3184V23.4551L19.5176 23.4199C19.9863 23.3613 20.4961 23.0918 20.8008 22.7461C20.9473 22.582 21.0703 22.4473 21.082 22.4414C21.0937 22.4414 21.2285 22.582 21.3867 22.752ZM23.9062 26.25V27.1875H22.9687H22.0312V26.25V25.3125H22.9687H23.9062V26.25ZM28.125 28.5938V29.0625H22.9687H17.8125V28.5938V28.125H22.9687H28.125V28.5938Z" />
                        </svg>
                        <h6>{{ translate('Art Gallery') }}</h6>
                    </a>
                </li>
                <li class="{{ Route::is('dashboard.customer.*') ? 'active' : '' }}">
                    <a href="{{ route('dashboard.customer.index') }}">
                        <svg width="30" height="30" viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M7.76367 0.527342C6.91406 0.662107 6.22852 0.966795 5.38477 1.58789C5.08594 1.81054 4.80469 1.99219 4.76953 1.99219C4.73438 1.99219 4.52344 2.08594 4.29492 2.19726C3.33984 2.67773 2.69531 3.70898 2.69531 4.76953C2.69531 5.36133 2.8125 5.74219 3.27539 6.67383L3.68555 7.48828L3.45703 7.52929C3.14062 7.58203 2.73047 7.85742 2.53711 8.15039C2.39062 8.37304 2.37305 8.44922 2.37305 8.91211C2.37305 9.38672 2.38477 9.43945 2.54883 9.67383C2.77734 10.002 3.17578 10.248 3.55078 10.2891L3.84375 10.3242L3.95508 10.7168C4.24219 11.7363 4.93359 12.6738 5.84766 13.2715L6.09375 13.4355V14.0625V14.6895L3.94336 15.5801C2.75391 16.0723 1.64648 16.5703 1.47656 16.6816C1.10742 16.9336 0.873047 17.2148 0.65625 17.6777L0.498047 18.0176L0.480469 21.5215L0.462891 25.0195L0.609375 25.166L0.755859 25.3125H2.49023H4.21875V27.2754V29.2441L4.36523 29.3848L4.50586 29.5312H15H25.4941L25.6348 29.3848L25.7812 29.2441V27.2754V25.3125H27.5098H29.2441L29.3848 25.166L29.5312 25.0254V21.668C29.5312 18.1582 29.5195 18.0117 29.2676 17.5195C29.0918 17.1797 28.8457 16.9043 28.5234 16.6816C28.3535 16.5703 27.2461 16.0723 26.0625 15.5801L23.9062 14.6836V14.0625V13.4355L24.1582 13.2715C25.0664 12.6738 25.7578 11.7363 26.0449 10.7168L26.1562 10.3242L26.4492 10.2891C27.1172 10.2129 27.6094 9.67383 27.6445 8.9707C27.6621 8.63672 27.6445 8.54297 27.498 8.26172C27.3047 7.89258 26.918 7.59375 26.543 7.52929C26.4141 7.50586 26.3086 7.48242 26.3086 7.4707C26.3086 7.45898 26.4316 7.16601 26.5781 6.81445C26.9121 6.04687 27 5.73047 27.0469 5.15625C27.123 4.14258 26.6836 3 25.9277 2.25586C25.4707 1.80469 25.1074 1.59375 23.8477 1.03711C22.8398 0.597654 22.4004 0.498045 21.5332 0.503904C20.373 0.521482 19.582 0.802732 18.5098 1.58789C18.2109 1.81054 17.9297 1.99219 17.8945 1.99219C17.6836 1.99219 16.9805 2.43164 16.6582 2.77148C16.043 3.41015 15.7793 4.11328 15.8379 4.98047C15.8555 5.25586 15.8906 5.53711 15.9141 5.61328C15.9492 5.73633 15.9375 5.74219 15.7852 5.70117C15.5449 5.64258 14.373 5.66015 14.0742 5.73047L13.8223 5.78906L13.8691 5.57226C13.9453 5.22656 13.9102 4.39453 13.7988 3.98437C13.5645 3.08203 12.8848 2.16211 12.123 1.71094C11.6074 1.40625 10.0312 0.726561 9.5918 0.621092C9.09375 0.498045 8.23242 0.457029 7.76367 0.527342ZM9.43359 1.55273C9.97852 1.69336 11.584 2.44922 11.9238 2.72461C12.7148 3.375 13.1133 4.37695 12.9551 5.33203C12.8379 6.04687 12.7676 6.1582 12.1523 6.60351C11.5488 7.03711 11.5371 7.04297 10.8926 7.34765C9.66211 7.92773 9 9.35156 9.3457 10.6816C9.39258 10.8633 9.61523 11.3848 9.84375 11.8359L10.2539 12.6562H9.95508C9.47461 12.6562 9.19922 12.7676 8.87695 13.0957C8.2793 13.6875 8.2793 14.4375 8.87695 15.0293C9.2168 15.375 9.47461 15.4687 10.043 15.4687C10.3418 15.4687 10.4297 15.4863 10.4297 15.5508C10.4297 15.75 10.8105 16.6641 11.0391 17.0273C11.3379 17.4844 11.9062 18.0762 12.3457 18.3809L12.6562 18.5918V19.1953V19.7988L12.3516 19.8867C12.1816 19.9336 10.6992 20.3437 9.05273 20.8008C7.41211 21.252 5.94727 21.668 5.80078 21.7148C4.86328 22.043 4.21875 22.9746 4.21875 24V24.375H2.8125H1.40039L1.41797 21.2871C1.43555 18.2168 1.43555 18.1934 1.56445 17.9473C1.63477 17.8184 1.79297 17.6309 1.9043 17.5312C2.0332 17.4258 3.02344 16.9805 4.48828 16.377C6.02344 15.7383 6.89062 15.3457 6.94922 15.2695C7.01367 15.1758 7.03125 14.918 7.03125 14.0918C7.03125 12.873 7.03711 12.8848 6.51562 12.5918C6.33398 12.4863 5.99414 12.2109 5.76562 11.9824C5.25586 11.4668 4.9043 10.8105 4.76953 10.1074C4.64648 9.47461 4.53516 9.375 3.97852 9.375C3.62109 9.375 3.55078 9.35742 3.42773 9.22851C3.23438 9.04101 3.23438 8.77148 3.42773 8.58398C3.55078 8.45508 3.62109 8.4375 3.98438 8.4375C4.34766 8.4375 4.41797 8.41992 4.54102 8.29101C4.66406 8.17383 4.6875 8.09179 4.6875 7.78125C4.6875 7.43554 4.6582 7.34765 4.17773 6.36328L3.66211 5.30859V4.78125C3.66211 4.2832 3.67383 4.21875 3.86133 3.8789C4.10156 3.43945 4.36523 3.19922 4.80469 3.00586C5.39062 2.74804 5.47266 2.70117 6.03516 2.28515C6.61523 1.85742 7.24219 1.57031 7.80469 1.46484C8.21484 1.39453 8.97656 1.43554 9.43359 1.55273ZM22.5586 1.55273C23.1035 1.69336 24.709 2.44922 25.0488 2.72461C25.6289 3.19922 25.957 3.77929 26.0859 4.55273C26.1797 5.10937 26.0742 5.625 25.6641 6.58008C25.3535 7.29492 25.3125 7.4414 25.3125 7.76953C25.3125 8.09765 25.3359 8.16797 25.459 8.29101C25.582 8.41992 25.6523 8.4375 26.0156 8.4375C26.3789 8.4375 26.4492 8.45508 26.5723 8.58398C26.7656 8.77148 26.7656 9.04101 26.5723 9.22851C26.4492 9.35742 26.3789 9.375 26.0215 9.375C25.4648 9.375 25.3535 9.47461 25.2305 10.1074C25.0957 10.8105 24.7441 11.4668 24.2344 11.9824C24.0059 12.2168 23.666 12.4922 23.4785 12.5977C22.9629 12.8848 22.9688 12.873 22.9688 14.0977C22.9688 15.0293 22.9805 15.1758 23.0742 15.2812C23.1328 15.3516 24.1699 15.8203 25.5293 16.3828C26.9824 16.9863 27.9609 17.4258 28.0957 17.5312C28.207 17.6309 28.3652 17.8184 28.4355 17.9473C28.5645 18.1934 28.5645 18.2168 28.582 21.2812L28.5996 24.375H27.1875H25.7812V24C25.7812 23.0859 25.2598 22.2246 24.4512 21.8027C24.3809 21.7676 22.7988 21.3164 20.9355 20.8008C19.0723 20.2793 17.502 19.8457 17.4492 19.8281C17.3555 19.7988 17.3438 19.7168 17.3438 19.1953V18.5918L17.666 18.375C18.1055 18.0703 18.7441 17.3848 19.0312 16.9043C19.1602 16.6816 19.3418 16.2715 19.4355 15.9902L19.5996 15.4687H19.9746C20.5312 15.4687 20.7891 15.3691 21.123 15.0293C21.7207 14.4375 21.7207 13.6875 21.123 13.0957C20.8008 12.7676 20.5254 12.6562 20.0449 12.6562C19.8809 12.6562 19.7461 12.6445 19.7461 12.6328C19.7461 12.6211 19.8691 12.3223 20.0156 11.9707C20.3496 11.2031 20.4375 10.8867 20.4844 10.3125C20.5605 9.29883 20.1328 8.17969 19.3652 7.41211C18.9727 7.01953 18.8438 6.9375 18.0527 6.55078L17.1738 6.12304L16.9805 5.71289C16.8047 5.34375 16.7871 5.25 16.7871 4.77539C16.7871 4.28906 16.7988 4.21875 16.9863 3.8789C17.2266 3.43945 17.4902 3.19922 17.9297 3.00586C18.5156 2.74804 18.5977 2.70117 19.1602 2.28515C19.7402 1.85742 20.3672 1.57031 20.9297 1.46484C21.3398 1.39453 22.1016 1.43554 22.5586 1.55273ZM16.0078 6.70898C16.5234 6.84375 18.1582 7.61719 18.4863 7.88086C19.4883 8.70117 19.834 10.0957 19.3125 11.2266L19.1777 11.5137L18.9082 10.9746C18.498 10.166 18.3691 10.1367 17.6074 10.6992C16.6289 11.4199 16.1367 11.6309 15.2695 11.6953C14.2852 11.7715 13.4766 11.502 12.4922 10.7754C11.6133 10.125 11.502 10.1426 11.0742 11.0098C10.9336 11.3027 10.7988 11.543 10.7812 11.543C10.7578 11.543 10.623 11.2969 10.4824 10.998C10.2363 10.4824 10.2246 10.4355 10.2246 9.93164C10.2246 9.44531 10.2363 9.375 10.4238 9.03515C10.6582 8.60156 10.916 8.36133 11.3672 8.15039C11.6367 8.02148 11.7715 7.99804 12.1875 7.99804C12.6211 7.99804 12.7383 8.02148 13.0664 8.17969C13.4531 8.36133 13.7402 8.5957 14.0098 8.95898L14.1562 9.1582L14.5195 8.91211C14.7188 8.77734 14.8828 8.64258 14.8828 8.61914C14.8828 8.53125 14.4434 7.99804 14.1855 7.78125C13.9102 7.54687 13.3066 7.20703 13.1602 7.20703C12.9141 7.20703 13.125 7.04297 13.6113 6.84961C14.3145 6.5625 15.252 6.50976 16.0078 6.70898ZM12.4219 11.8652C13.2656 12.4219 13.9512 12.6211 15 12.6211C16.0488 12.6211 16.7344 12.4219 17.5781 11.8652C17.8477 11.6895 18.082 11.543 18.1055 11.543C18.123 11.543 18.2812 11.8301 18.4512 12.1758L18.7617 12.8086L18.7383 14.0332C18.7148 15.1816 18.7031 15.293 18.5625 15.6914C18.3457 16.3008 18.0762 16.7227 17.6367 17.168C17.1914 17.6074 16.7695 17.877 16.1602 18.0937C15.791 18.2227 15.6387 18.2461 15.0293 18.252C14.4609 18.252 14.25 18.2285 13.916 18.123C12.9609 17.8184 12.1055 17.0977 11.6719 16.2305C11.3262 15.5391 11.25 15.123 11.25 13.8457V12.7734L11.5547 12.1582C11.7246 11.8184 11.877 11.543 11.8945 11.543C11.918 11.543 12.1523 11.6895 12.4219 11.8652ZM10.3125 14.0625V14.5312H9.99023C9.59766 14.5312 9.375 14.3613 9.375 14.0625C9.375 13.7637 9.59766 13.5937 9.99023 13.5937H10.3125V14.0625ZM20.4785 13.7402C20.5723 13.8281 20.625 13.9512 20.625 14.0625C20.625 14.3613 20.4023 14.5312 20.0098 14.5312H19.6875V14.0625V13.5937H20.0098C20.2793 13.5937 20.3613 13.6172 20.4785 13.7402ZM15 19.1777C15.5273 19.1777 15.8965 19.1484 16.1016 19.0898L16.4062 19.002V19.4766V19.9512L15.7031 20.6543L15 21.3574L14.2969 20.6543L13.5938 19.9512V19.4766V19.002L13.9043 19.0898C14.1035 19.1484 14.4727 19.1777 15 19.1777ZM13.8867 21.5918C14.707 22.4004 14.8242 22.5 15 22.5C15.1758 22.5 15.293 22.4004 16.1133 21.5918L17.0273 20.6836L20.5078 21.6504C24.2051 22.6758 24.3047 22.7168 24.5918 23.1387C24.668 23.25 24.75 23.4316 24.7852 23.5488C24.8203 23.6719 24.8438 24.7383 24.8438 26.1738V28.5937H23.4375H22.0312V26.7187V24.8437H21.5625H21.0938V26.7187V28.5937H15H8.90625V26.7187V24.8437H8.4375H7.96875V26.7187V28.5937H6.5625H5.15625V26.1738C5.15625 24.7383 5.17969 23.6719 5.21484 23.5488C5.25 23.4316 5.33203 23.25 5.4082 23.1387C5.68945 22.7168 5.80078 22.6758 9.46289 21.6562C11.3672 21.123 12.9316 20.6895 12.9492 20.6895C12.9609 20.6836 13.3828 21.0937 13.8867 21.5918Z" />
                        </svg>
                        <h6>{{ translate('Customer') }}</h6>
                    </a>
                </li>
                @endadmin
                <li class="{{ Route::is('dashboard.withdraw.*') ? 'active' : '' }}">
                    <a href="{{ route('dashboard.withdraw.list') }}">
                        <svg width="30" height="30" viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M2.98828 1.99219V3.98438H3.48633H3.98438L3.99609 5.98828L4.01367 7.99805L6.52148 8.01562L9.02344 8.02734V9.88477V11.7422L8.0332 12.7441C7.10742 13.6758 7.03711 13.7578 7.00195 14.0039C6.98438 14.1504 6.97266 15.7031 6.98438 17.4609L7.00195 20.6543L8.25 24.1055L9.49219 27.5625V28.6113V29.6602L9.66211 29.8301L9.83203 30H13.002H16.166L16.3301 29.8594L16.4941 29.7188L16.5117 25.8398L16.5293 21.9609L15.9082 20.5137C15.5684 19.7227 15.293 19.0488 15.293 19.0254C15.293 19.002 16.5059 18.9844 17.9883 18.9844H20.6895L20.8301 18.8379L20.9766 18.6973V13.3652V8.02734L23.4844 8.01562L25.9863 7.99805L26.0039 5.98828L26.0156 3.98438H26.5137H27.0117V1.99219V0H15H2.98828V1.99219ZM26.0156 1.99219V2.98828H15H3.98438V1.99219V0.996094H15H26.0156V1.99219ZM25.0078 5.49023L25.0195 6.97266H22.998H20.9707L20.9883 6.48633L21.0059 6.00586L21.4922 5.98828L21.9727 5.9707V5.47852V4.98047H15H8.02734V5.47852V5.9707L8.51367 5.98828L8.99414 6.00586L9.01172 6.48633L9.0293 6.97266H7.00195H4.98047V5.51953C4.98047 4.7168 4.99805 4.04297 5.02148 4.02539C5.03906 4.00195 9.54492 3.99023 15.0234 3.99609L24.9902 4.01367L25.0078 5.49023ZM11.0039 9.50391L11.0156 13.0078H11.5137H12.0117V10.5996V8.19141L12.2344 8.39062C13.875 9.87305 16.1836 9.85547 17.8008 8.35547L17.9883 8.17969V10.5938V13.0078H18.4863H18.9844L18.9961 9.50391L19.0137 6.00586L19.5 5.98828L19.9805 5.9707V11.9824V17.9883H17.4902H15V16.8867C15 15.6621 14.9531 15.416 14.6426 15.041C14.3438 14.6836 13.9512 14.5195 13.3594 14.5078C12.75 14.502 12.498 14.5488 12.2227 14.7363L12.0117 14.877V14.4434V14.0039H11.5137H11.0156V15.498V16.9922H11.25H11.4844V17.4902V17.9883H10.752H10.0195V11.9824V5.9707L10.5059 5.98828L10.9863 6.00586L11.0039 9.50391ZM17.9121 6.19336C17.8477 6.58594 17.4727 7.25391 17.1152 7.61133C15.668 9.05273 13.2363 8.66602 12.3398 6.84961C12.2227 6.60938 12.1113 6.31641 12.0879 6.19336L12.0527 5.97656H15H17.9473L17.9121 6.19336ZM9.02344 15.9668V18.6973L9.16992 18.8379C9.31055 18.9844 9.32227 18.9844 10.4004 18.9844H11.4844V19.9805V20.9766H11.9824H12.4805V18.4922C12.4805 16.9102 12.5039 15.9434 12.5391 15.8438C12.6387 15.5859 12.7617 15.5332 13.248 15.5273C13.6055 15.5273 13.7285 15.5508 13.834 15.6387C13.9746 15.75 13.9746 15.7617 14.0039 17.2383L14.0332 18.7207L14.7832 20.4434L15.5273 22.1602L15.5156 24.5742L15.498 26.9824H12.9199H10.3418L9.1875 23.7598L8.0332 20.5371V17.3613L8.02734 14.1797L8.48438 13.7109C8.73047 13.4531 8.95312 13.2422 8.98242 13.2422C9.00586 13.2422 9.02344 14.4668 9.02344 15.9668ZM15.5156 28.4883L15.498 28.9746L12.9961 28.9922L10.4883 29.0039V28.5059V28.0078H13.0078H15.5332L15.5156 28.4883Z" />
                            <path
                                d="M6.01758 5.02148C5.99414 5.03906 5.97656 5.26758 5.97656 5.51953V5.97656H6.47461H6.97266V5.47852V4.98047H6.51562C6.26367 4.98047 6.03516 4.99805 6.01758 5.02148Z" />
                            <path
                                d="M23.0273 5.47852V5.97656H23.5254H24.0293L24.0117 5.49024L23.9941 5.00977L23.5137 4.99219L23.0273 4.97461V5.47852Z" />
                            <path
                                d="M14.5313 10.5762C13.9395 10.7637 13.5234 11.3379 13.5176 11.9824C13.5176 12.4102 13.6406 12.7266 13.9336 13.0313C14.2383 13.3477 14.543 13.4766 15 13.4766C15.457 13.4766 15.7617 13.3477 16.0664 13.0313C16.3594 12.7207 16.4824 12.4102 16.4824 11.9766C16.4766 11.332 16.0488 10.7578 15.4453 10.5762C15.0938 10.4707 14.877 10.4707 14.5313 10.5762ZM15.2285 11.5723C15.416 11.666 15.4688 11.7656 15.4688 12.0293C15.4688 12.4336 14.9355 12.6445 14.666 12.3457C14.4434 12.1055 14.4844 11.7188 14.7539 11.5781C14.9531 11.4668 15.0234 11.4668 15.2285 11.5723Z" />
                            <path
                                d="M17.9883 15V15.9961H16.9922H15.9961V16.4941V16.9922H17.4902H18.9844V15.498V14.0039H18.4863H17.9883V15Z" />
                        </svg>
                        <h6>{{ translate('Withdrawal') }}</h6>
                    </a>
                </li>

                <li class="{{ Route::is('dashboard.transactions.list') ? 'active' : '' }}">
                    <a href="{{ route('dashboard.transactions.list') }}">
                        <svg width="30" height="30" viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg">
                            <g clip-path="url(#clip0_692_2355)">
                                <path
                                    d="M4.98884 0.0953236C4.28571 0.256681 3.75 0.635256 3.42857 1.20622L3.24777 1.51653L3.22768 8.20053L3.21429 14.8907H1.60714H0V17.8697V20.8486H15H30V17.8697V14.8907H28.3929H26.7857L26.7723 8.35569L26.7522 1.82683L26.5982 1.47308C26.404 1.03245 25.9688 0.573195 25.5335 0.349773C24.7902 -0.0225945 25.2991 -0.00397491 14.8996 0.0022316C6.87054 0.0084362 5.33036 0.0208492 4.98884 0.0953236ZM7.39955 1.21863C7.27902 1.82683 6.77679 2.47848 6.13393 2.86326C5.71875 3.1115 4.82143 3.4094 4.47991 3.4094H4.28571V2.62742C4.28571 1.55376 4.40625 1.33034 5.10268 1.10692C5.38393 1.02004 5.67188 0.995213 6.45536 0.989006H7.44643L7.39955 1.21863ZM21.4955 1.1876C21.4955 1.47308 21.8371 2.35435 22.1049 2.76396C22.808 3.83762 24.1808 4.7251 25.3661 4.87405L25.7143 4.91749V12.3835V19.8557H23.7054H21.6964L22.0714 19.3405C22.7277 18.4407 23.1629 17.4849 23.4174 16.3802C23.5848 15.6479 23.5781 14.0777 23.4107 13.3392C23.0424 11.7504 22.279 10.4472 21.0335 9.29902C19.7946 8.14468 18.3951 7.43718 16.6741 7.09584C15.8772 6.93448 14.1228 6.93448 13.3259 7.09584C11.5915 7.44339 10.2254 8.13227 8.96652 9.29902C7.70759 10.4658 6.96429 11.7318 6.58929 13.3392C6.42188 14.0777 6.41518 15.6479 6.58259 16.3802C6.83705 17.4849 7.27232 18.4407 7.92857 19.3405L8.30357 19.8557H6.29464H4.28571L4.29911 12.1414L4.3192 4.43341L4.52009 4.41479C5.34375 4.34652 6.46875 3.92451 7.07812 3.45905C7.77455 2.92532 8.30357 2.11852 8.45759 1.35517L8.53795 0.989006H15.0134H21.4955V1.1876ZM24.8438 1.13795C25.5469 1.47929 25.7143 1.85786 25.7143 3.08047C25.7143 4.03001 25.7478 3.99277 25.058 3.77556C23.8259 3.39078 22.7812 2.2985 22.5871 1.1876L22.5469 0.976593L23.5781 1.00142C24.4219 1.02004 24.6496 1.04486 24.8438 1.13795ZM16.1384 8.03297C17.7121 8.25018 19.1451 8.92665 20.2902 9.9879C23.0759 12.5697 23.2366 16.6223 20.6585 19.4212L20.2634 19.8557H15H9.7433L9.42857 19.5205C8.22321 18.2483 7.60714 16.8271 7.52009 15.139C7.39286 12.4828 8.97991 9.96307 11.5781 8.72185C13.0045 8.03917 14.5446 7.80334 16.1384 8.03297ZM3.21429 17.8697V19.8557H2.14286H1.07143V17.8697V15.8837H2.14286H3.21429V17.8697ZM28.9286 17.8697V19.8557H27.8571H26.7857V17.8697V15.8837H27.8571H28.9286V17.8697Z" />
                                <path
                                    d="M12.2678 12.2284C11.2634 12.4083 10.433 13.1593 10.1719 14.1088L10.0982 14.3943H9.62945C9.22766 14.3943 9.1473 14.4129 9.00668 14.5495C8.7857 14.7481 8.7857 15.0335 9.00668 15.2321C9.1473 15.3687 9.22766 15.3873 9.62945 15.3873H10.0982L10.1719 15.6728C10.5134 16.9264 11.7589 17.7208 13.1786 17.5967C13.6942 17.5532 14.183 17.3236 14.5111 16.9699C14.712 16.7526 15.1004 16.0824 15.3281 15.5549L15.4018 15.3873H17.1094H18.8236L18.7835 15.5238C18.5826 16.1258 17.7857 16.6285 17.029 16.6285C16.5335 16.6285 16.2991 17.156 16.6473 17.4788C16.808 17.6277 16.8549 17.6339 17.2299 17.6029C17.8393 17.547 18.2879 17.4043 18.7634 17.1064C19.279 16.7899 19.7076 16.2375 19.8281 15.7286L19.9085 15.3873H20.3705C20.7723 15.3873 20.8527 15.3687 20.9933 15.2321C21.1004 15.1391 21.1607 15.0087 21.1607 14.8908C21.1607 14.7729 21.1004 14.6426 20.9933 14.5495C20.8527 14.4129 20.7723 14.3943 20.3705 14.3943H19.9085L19.8281 14.053C19.7076 13.5441 19.279 12.9917 18.7634 12.6752C18.2009 12.3277 17.7187 12.1911 17.0089 12.1911C16.5 12.1911 16.3995 12.2098 16.0781 12.3773C15.8839 12.4766 15.6161 12.6752 15.4888 12.8117C15.2812 13.0228 14.9263 13.6434 14.6786 14.2205L14.5982 14.3943H12.8906H11.183L11.25 14.2392C11.5312 13.5441 12.1473 13.1531 12.9375 13.1531C13.2656 13.1531 13.5268 12.9359 13.5268 12.6566C13.5268 12.5387 13.4665 12.4083 13.3594 12.3153C13.1853 12.1477 12.8504 12.1229 12.2678 12.2284ZM17.8527 13.3331C18.3214 13.5317 18.6495 13.8482 18.7835 14.2516L18.8236 14.3943H17.3169C16.3259 14.3943 15.8036 14.3695 15.8036 14.3323C15.8036 14.295 15.8906 14.1088 15.9978 13.9102C16.1853 13.5627 16.3728 13.3703 16.6406 13.2214C16.8348 13.1158 17.4643 13.1779 17.8527 13.3331ZM14.1964 15.4494C14.1964 15.5611 13.8549 16.1569 13.7009 16.3058C13.3794 16.6409 12.9643 16.7092 12.3348 16.5354C11.8125 16.3865 11.471 16.0762 11.25 15.5424L11.183 15.3873H12.6897C13.6808 15.3873 14.1964 15.4121 14.1964 15.4494Z" />
                                <path
                                    d="M12.0267 21.972L11.8526 22.0961V23.4615V24.8206H10.9553C10.1517 24.8206 10.0445 24.833 9.88382 24.9509C9.7499 25.044 9.70972 25.1309 9.70972 25.3047C9.70972 25.5281 9.81686 25.6336 12.0066 27.663C13.982 29.4938 14.3303 29.7855 14.4977 29.7855C14.6718 29.7855 15.02 29.4876 17.0222 27.6258C18.7432 26.037 19.3526 25.435 19.3526 25.3295C19.3526 25.2488 19.2655 25.0999 19.1584 25.0006L18.9642 24.8206H18.0869H17.2097V23.5111V22.2016L17.0155 22.0216L16.8213 21.8417H14.5111C12.2811 21.8417 12.2008 21.8479 12.0267 21.972ZM16.1383 24.169C16.1383 25.5095 16.1383 25.5095 16.3057 25.6584C16.4463 25.795 16.5267 25.8136 16.9887 25.8136H17.5111L16.0378 27.1789C15.2276 27.9299 14.5378 28.5443 14.4977 28.5443C14.4575 28.5443 13.7678 27.9299 12.9575 27.1789L11.4843 25.8136H11.9999C12.4486 25.8136 12.5423 25.795 12.703 25.6646L12.8905 25.5157L12.9106 24.1752L12.9307 22.8347H14.5378H16.1383V24.169Z" />
                            </g>
                            <defs>
                                <clipPath id="clip0_692_2355">
                                    <rect width="30" height="30" fill="white" />
                                </clipPath>
                            </defs>
                        </svg>
                        <h6>{{translate('Transactions')}}</h6>
                    </a>
                </li>

                @admin

                <li class="{{ Route::is('dashboard.menu.*') ? 'active' : '' }}">
                    <a href="{{ route('dashboard.menu.list') }}">
                        <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor"
                            class="bi bi-menu-app-fill" viewBox="0 0 16 16">
                            <path
                                d="M0 1.5A1.5 1.5 0 0 1 1.5 0h2A1.5 1.5 0 0 1 5 1.5v2A1.5 1.5 0 0 1 3.5 5h-2A1.5 1.5 0 0 1 0 3.5v-2zM0 8a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V8zm1 3v2a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-2H1zm14-1V8a1 1 0 0 0-1-1H2a1 1 0 0 0-1 1v2h14zM2 8.5a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5zm0 4a.5.5 0 0 1 .5-.5h6a.5.5 0 0 1 0 1h-6a.5.5 0 0 1-.5-.5z" />
                        </svg>
                        <h6>{{ translate('Menu') }}</h6>
                    </a>
                </li>

                <li class="{{ Route::is('dashboard.pages.*') ? 'active' : '' }}">
                    <a href="{{ route('dashboard.pages.index') }}">
                        <svg width="30" height="30" viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M0.615234 0.0820312C0.369141 0.1875 0.0703125 0.544922 0.0292969 0.773438C0.0117187 0.878906 0.00585938 6.62695 0.0117187 13.541L0.0292969 26.1152L0.199219 26.332C0.427734 26.6367 0.755859 26.7773 1.24805 26.7773H1.64062V27.1582C1.64062 27.5742 1.74609 27.8965 1.95117 28.1133C2.16211 28.3359 2.28516 28.3828 2.8125 28.418L3.31055 28.4473L3.33984 28.916C3.375 29.4727 3.49805 29.6895 3.88476 29.877C4.13672 30 4.16016 30 11.1973 30H18.2519L20.4023 27.8438L22.5586 25.6934V23.4199V21.1523H22.957C23.7949 21.1523 24.9199 20.8828 25.8281 20.4727C26.373 20.2207 26.4844 20.127 26.4844 19.9102C26.4844 19.6758 26.3906 19.5176 26.209 19.4473C26.0859 19.4004 25.9629 19.4414 25.4707 19.6641C23.3144 20.6543 20.8418 20.4141 18.9609 19.0312L18.5566 18.7383L20.7246 16.5703L22.8867 14.4082L25.8281 15.1816C28.5996 15.9141 28.7695 15.9668 28.7344 16.084C28.6348 16.4297 28.1426 17.3262 27.8086 17.7832C27.5977 18.0645 27.4219 18.3398 27.4219 18.3984C27.4219 18.5977 27.6504 18.8086 27.873 18.8086C28.1191 18.8086 28.3301 18.6035 28.7754 17.9297C29.2852 17.1621 29.6426 16.3184 29.8652 15.3398C30.0059 14.7188 30.0059 13.1426 29.8594 12.4922C29.5371 10.998 28.8457 9.73828 27.7793 8.71289C26.4961 7.47656 24.9375 6.79102 23.1914 6.69727L22.5644 6.66211L22.5469 5.27344L22.5293 3.88477L22.3594 3.66797C22.1309 3.36328 21.8027 3.22266 21.3223 3.22266H20.9355L20.9062 2.78906C20.8535 2.01562 20.5312 1.69922 19.7402 1.65234L19.2773 1.62305V1.40625C19.2773 1.03711 19.166 0.585938 19.0371 0.398438C18.9668 0.298828 18.8027 0.169922 18.668 0.111328C18.4394 0.00585938 18.0879 0 9.60937 0.00585938C2.44922 0.00585938 0.755859 0.0175781 0.615234 0.0820312ZM18.3398 0.990234C18.3691 1.05469 18.3984 1.22461 18.3984 1.37109V1.64062H13.248C8.13281 1.64062 8.10351 1.64062 7.94531 1.76367C7.75195 1.91602 7.73437 2.22656 7.91015 2.40234C8.02734 2.51953 8.10351 2.51953 13.9629 2.51953C18.5039 2.51953 19.916 2.53711 19.9687 2.58984C20.0098 2.63086 20.0391 2.78906 20.0391 2.94141V3.22266L12.0234 3.23438L4.00781 3.25195L3.76758 3.41016C3.29883 3.7207 3.33984 2.56055 3.33984 15.7559V27.5449L2.94727 27.5273L2.54883 27.5098L2.53125 15.0938C2.52539 5.96484 2.53711 2.66016 2.58398 2.60156C2.63672 2.53711 2.98242 2.51953 4.2832 2.51953C5.8418 2.51953 5.92383 2.51367 6.03516 2.40234C6.21094 2.22656 6.19336 1.91602 5.99414 1.75781C5.8418 1.63477 5.79492 1.63477 4.10156 1.65234C2.41406 1.66992 2.36719 1.67578 2.15625 1.80469C2.03906 1.88086 1.88086 2.03906 1.80469 2.15625L1.66992 2.37305L1.65234 14.1387L1.64062 25.9043L1.27148 25.8867L0.908203 25.8691L0.890625 13.4473C0.884766 6.61523 0.890625 0.990234 0.908203 0.949219C0.925781 0.896484 2.72461 0.878906 9.60351 0.878906C18.1172 0.878906 18.2754 0.878906 18.3398 0.990234ZM21.668 5.43164C21.6855 6.87891 21.7266 6.74414 21.2402 6.82617C20.8184 6.89648 20.0742 7.1543 19.5644 7.41211C17.6309 8.36719 16.2949 10.0137 15.7207 12.1289C15.5215 12.8848 15.4629 14.3555 15.6094 15.1465C16.0137 17.3379 17.3027 19.1602 19.207 20.2383C19.6992 20.5195 20.5078 20.8359 21.0059 20.9473C21.2344 20.9941 21.4746 21.0527 21.5508 21.0645L21.6797 21.0938V23.0566V25.0195H20.1445C19.2656 25.0195 18.5098 25.0488 18.3867 25.0781C18.1055 25.1602 17.8184 25.4004 17.7187 25.6465C17.6543 25.793 17.6367 26.2266 17.6367 27.4805V29.1211L10.9453 29.1094L4.24805 29.0918L4.23047 16.6699C4.22461 9.83789 4.23047 4.21289 4.24805 4.17188C4.26562 4.11328 6.04101 4.10156 12.9609 4.11328L21.6504 4.13086L21.668 5.43164ZM23.7949 7.64648C24.0644 7.69336 24.4394 7.77539 24.6211 7.83398L24.9551 7.93945L23.666 10.8105L22.3769 13.6816L20.1562 15.9023L17.9414 18.123L17.6426 17.7188C17.0801 16.957 16.6699 16.0254 16.5 15.1172C16.3828 14.502 16.377 13.3359 16.4941 12.7324C16.9863 10.1367 19.0254 8.12109 21.6387 7.64648C22.2129 7.54102 23.2031 7.54102 23.7949 7.64648ZM26.2617 8.60742C28.1719 9.85547 29.3203 12.2461 29.0801 14.4961C29.0449 14.8066 29.0098 15.0703 28.998 15.082C28.9746 15.1055 23.4316 13.6582 23.3906 13.6172C23.3555 13.5938 25.7402 8.32031 25.7871 8.32031C25.8047 8.32031 26.0215 8.44922 26.2617 8.60742ZM19.7988 27.1758L18.5449 28.4531L18.5273 27.2227C18.5156 26.2793 18.5332 25.9863 18.5859 25.9453C18.6269 25.9219 19.2012 25.8984 19.8574 25.8984H21.0469L19.7988 27.1758Z" />
                            <path
                                d="M6.80277 7.41793C6.66215 7.59957 6.65043 7.66989 6.75004 7.88082C6.79106 7.97457 6.89066 8.05075 7.02543 8.09176C7.16605 8.13278 8.69535 8.1445 11.5899 8.13278L15.9493 8.1152L16.0606 7.97457C16.2071 7.79879 16.2012 7.52926 16.0547 7.38278C15.9375 7.26559 15.8614 7.26559 11.4317 7.26559H6.91996L6.80277 7.41793Z" />
                            <path
                                d="M6.80273 10.6406C6.73242 10.7285 6.67969 10.834 6.67969 10.875C6.67969 11.039 6.82031 11.2441 6.9668 11.3086C7.07227 11.3496 8.16797 11.3672 10.541 11.3554L13.957 11.3379L14.0684 11.1972C14.2148 11.0215 14.209 10.7519 14.0625 10.6054C13.9453 10.4883 13.8691 10.4883 10.4355 10.4883H6.91992L6.80273 10.6406Z" />
                            <path
                                d="M6.80273 13.8633C6.73242 13.9511 6.67969 14.0566 6.67969 14.0976C6.67969 14.2617 6.82031 14.4668 6.9668 14.5312C7.07227 14.5722 8.0332 14.5898 10.0723 14.5781L13.0195 14.5605L13.1309 14.4199C13.2773 14.2441 13.2715 13.998 13.125 13.8398L13.0019 13.7109H9.96093H6.91992L6.80273 13.8633Z" />
                            <path
                                d="M9.78517 18.75C9.67384 18.8613 9.66798 18.9434 9.66798 20.3027V21.7383H8.67774H7.68165L7.56446 21.8906C7.44728 22.043 7.44142 22.1191 7.44142 23.6719V25.2949L7.20118 25.3301C7.07228 25.3477 6.91407 25.4062 6.84962 25.4648C6.70314 25.5996 6.70314 25.9219 6.85548 26.0742C6.97267 26.1914 7.04884 26.1914 11.1914 26.1914C15.334 26.1914 15.4102 26.1914 15.5274 26.0742C15.7969 25.8047 15.6035 25.3887 15.1875 25.3301L14.9414 25.2949V23.1152C14.9414 20.9941 14.9356 20.9297 14.8184 20.7773L14.7012 20.625H13.7051H12.7149V19.7578C12.7149 18.5508 12.832 18.6328 11.1914 18.6328C9.97852 18.6328 9.89649 18.6387 9.78517 18.75ZM11.8359 22.4121V25.3125H11.1914H10.5469V22.4121V19.5117H11.1914H11.8359V22.4121ZM14.0625 23.4082V25.3125H13.3887H12.7149V23.4082V21.5039H13.3887H14.0625V23.4082ZM9.66798 23.9648V25.3125H8.99415H8.32032V23.9648V22.6172H8.99415H9.66798V23.9648Z" />
                        </svg>
                        <h6>{{ translate('Pages') }}</h6>
                    </a>
                </li>
                <li class="{{ Route::is('dashboard.blogs.*') ? 'active' : '' }}">
                    <a href="{{ route('dashboard.blogs.index') }}">
                        <svg width="30" height="30" viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg">
                            <g clip-path="url(#clip0_692_2372)">
                                <path
                                    d="M4.2832 0.0820312C3.97851 0.251953 3.99023 0.111328 3.98437 5.01562V9.5918L3.59179 9.66211C2.43164 9.87305 1.4707 10.8047 1.23633 11.9414C1.18945 12.1582 1.17187 14.209 1.17187 18.6621V25.0781H1.04297C0.849608 25.084 0.46289 25.2715 0.310546 25.4355C-8.01403e-07 25.7754 -0.0703133 26.2383 0.0878898 26.9824C0.380858 28.3887 1.61133 29.6191 3.01758 29.9121C3.63281 30.041 26.3672 30.041 26.9824 29.9121C28.0547 29.6895 29.0918 28.8809 29.584 27.8906C30.1055 26.8301 30.1289 25.834 29.6426 25.3887C29.4785 25.2363 29.1211 25.0781 28.9453 25.0781C28.8281 25.0781 28.8281 25.0723 28.8281 19.2363V13.3945L29.414 12.8027C30.0234 12.1816 30.0879 12.0586 29.9355 11.7598C29.8125 11.5137 27.2812 9.02344 27.0937 8.96484C26.8418 8.88281 26.6367 8.9707 26.2969 9.30469L26.0156 9.57422V5.02148C26.0156 0.0703125 26.0273 0.222656 25.6933 0.0703125C25.582 0.0175781 24.5156 0 21.5273 0C17.1738 0 17.2676 -0.00585938 17.1211 0.322266C16.9863 0.621094 17.0801 0.949219 17.3496 1.08984C17.4844 1.16016 18.123 1.17188 21.1816 1.17188H24.8437V5.96484V10.752L22.7168 12.8789L20.5957 15H13.9629C8.94726 15 7.29492 15.0176 7.17773 15.0703C7.00781 15.1465 6.85546 15.3926 6.85546 15.5859C6.85546 15.7793 7.00781 16.0254 7.17773 16.1016C7.29492 16.1543 8.81249 16.1719 13.3769 16.1719H19.4238L18.1348 17.4609L16.8457 18.75H12.0879C8.52538 18.75 7.28906 18.7676 7.17773 18.8203C7.00781 18.8965 6.85546 19.1426 6.85546 19.3359C6.85546 19.5293 7.00781 19.7754 7.17773 19.8516C7.28906 19.9043 8.39062 19.9219 11.4961 19.9219H15.6621L15.1699 20.4375C14.7187 20.9062 14.6543 21.0117 14.3906 21.627C14.2324 21.9961 13.8281 22.9219 13.4941 23.6836L12.8789 25.0781H9.01757H5.15625V13.125V1.17188H8.81835C11.5254 1.17188 12.5156 1.1543 12.6269 1.10156C12.7969 1.02539 12.9492 0.779297 12.9492 0.585938C12.9492 0.392578 12.7969 0.146484 12.6269 0.0703125C12.3926 -0.0351562 4.47656 -0.0234375 4.2832 0.0820312ZM23.1328 17.4434L17.6953 22.8809L16.875 22.0605L16.0547 21.2402L21.4863 15.8086L26.9238 10.3711L27.7441 11.1914L28.5644 12.0117L23.1328 17.4434ZM3.98437 17.9297V25.0781H3.16406H2.34375V18.7031C2.34375 11.7188 2.33203 12 2.68945 11.502C2.7832 11.373 2.94726 11.2031 3.05273 11.127C3.24023 10.9922 3.75586 10.7871 3.91406 10.7812C3.96679 10.7812 3.98437 12.2461 3.98437 17.9297ZM27.6562 19.834V25.0781H26.8359H26.0156V20.6426V16.2012L26.8183 15.3984C27.2637 14.9531 27.6328 14.5898 27.6387 14.5898C27.6504 14.5898 27.6562 16.9512 27.6562 19.834ZM24.8262 25.0605C24.8144 25.0723 22.8457 25.0723 20.4609 25.0664L16.1133 25.0488L17.0449 24.6445L17.9824 24.2344L21.3984 20.8184L24.8144 17.4023L24.832 21.2227C24.8379 23.3203 24.8379 25.0488 24.8262 25.0605ZM16.6406 23.502C16.6406 23.543 14.4668 24.5098 14.4433 24.4805C14.4316 24.4629 14.8418 23.5137 15.2695 22.5645L15.416 22.2422L16.0254 22.8516C16.3652 23.1914 16.6406 23.4785 16.6406 23.502ZM28.8281 26.3379C28.8281 26.5605 28.6758 27.0762 28.5234 27.3867C28.1894 28.0488 27.4687 28.6055 26.7305 28.7637C26.5078 28.8105 23.2324 28.8281 14.9824 28.8281C2.50781 28.8281 3.25195 28.8457 2.5664 28.5C2.16211 28.2949 1.69336 27.8145 1.47656 27.3867C1.32422 27.0762 1.17187 26.5605 1.17187 26.3379C1.17187 26.2617 2.95312 26.25 15 26.25C27.0469 26.25 28.8281 26.2617 28.8281 26.3379Z" />
                                <path
                                    d="M14.7128 0.0820311C14.2031 0.363281 14.4199 1.17188 14.9999 1.17188C15.2988 1.17188 15.5859 0.884766 15.5859 0.591797C15.5859 0.152344 15.0996 -0.134766 14.7128 0.0820311Z" />
                                <path
                                    d="M7.15432 3.83203C6.76174 4.04883 6.77346 4.66992 7.17776 4.85156C7.41213 4.95703 9.73831 4.94531 9.9551 4.83984C10.3418 4.63477 10.3418 4.03711 9.9551 3.83203C9.72659 3.71485 7.36526 3.71485 7.15432 3.83203Z" />
                                <path
                                    d="M12.6621 3.83203C12.2696 4.04883 12.2813 4.66992 12.6856 4.85156C12.7969 4.9043 14.0684 4.92188 17.7539 4.92188C21.4395 4.92188 22.711 4.9043 22.8223 4.85156C22.9922 4.77539 23.1445 4.5293 23.1445 4.33594C23.1445 4.14258 22.9922 3.89648 22.8223 3.82031C22.5879 3.71484 12.8555 3.72656 12.6621 3.83203Z" />
                                <path
                                    d="M7.15432 7.58208C6.76174 7.79888 6.77346 8.41997 7.17776 8.60162C7.38284 8.69537 16.2715 8.70123 16.4824 8.60748C16.6465 8.5313 16.8164 8.26763 16.8164 8.08599C16.8164 7.90435 16.6465 7.64068 16.4824 7.5645C16.2598 7.4649 7.34182 7.48247 7.15432 7.58208Z" />
                                <path
                                    d="M19.2246 7.58203C18.9492 7.73437 18.8555 8.07422 19.0078 8.37305C19.1543 8.6543 19.2715 8.67188 21.041 8.67188C22.8223 8.67188 22.9395 8.6543 23.0742 8.34961C23.209 8.05078 23.1153 7.72266 22.8457 7.58203C22.6172 7.46484 19.4356 7.46484 19.2246 7.58203Z" />
                                <path
                                    d="M7.15432 11.332C6.76174 11.5488 6.77346 12.1699 7.17776 12.3516C7.28909 12.4043 8.02737 12.4219 9.87893 12.4219C12.0352 12.4219 12.4512 12.4102 12.5977 12.334C12.8028 12.2285 12.8906 12.082 12.8906 11.8359C12.8906 11.5898 12.8028 11.4434 12.5977 11.3379C12.3633 11.2148 7.37698 11.209 7.15432 11.332Z" />
                                <path
                                    d="M15.2227 11.4199C15.0645 11.5605 15.0293 11.6309 15.0293 11.8359C15.0293 12.041 15.0645 12.1113 15.2227 12.252L15.4102 12.4219H18.2812C21.3574 12.4219 21.3809 12.4219 21.5391 12.123C21.6973 11.8184 21.5859 11.4492 21.2988 11.3203C21.1875 11.2676 20.3789 11.25 18.2812 11.25H15.4102L15.2227 11.4199Z" />
                            </g>
                            <defs>
                                <clipPath id="clip0_692_2372">
                                    <rect width="30" height="30" fill="white" />
                                </clipPath>
                            </defs>
                        </svg>
                        <h6>{{ translate('Blogs') }}</h6>
                    </a>
                </li>
                <li class="{{ Route::is('dashboard.payment.methods.index') ? 'active' : '' }}">
                    <a href="{{ route('dashboard.payment.methods.index') }}">
                        <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor"
                            class="bi bi-credit-card-2-front" viewBox="0 0 16 16">
                            <path
                                d="M14 3a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1V4a1 1 0 0 1 1-1zM2 2a2 2 0 0 0-2 2v8a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2z" />
                            <path
                                d="M2 5.5a.5.5 0 0 1 .5-.5h2a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-2a.5.5 0 0 1-.5-.5zm0 3a.5.5 0 0 1 .5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5m0 2a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5m3 0a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5m3 0a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5m3 0a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5" />
                        </svg>
                        <h6>{{ translate('Payment Methods') }}</h6>
                    </a>
                </li>
                <li class="{{ Route::is('dashboard.email.template.*') ? 'active' : '' }}">
                    <a href="{{ route('dashboard.email.template.index') }}">
                        <svg width="30" height="30" viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M5.53711 1.60549C5.17383 1.76955 4.92188 2.0508 4.75781 2.46682C4.6875 2.6426 3.7207 5.32033 2.60742 8.4258C0.708984 13.7285 0.585938 14.0977 0.585938 14.461C0.585938 14.918 0.708984 15.2344 0.996094 15.5156C1.24219 15.7617 1.38867 15.8379 2.25 16.1426L2.95898 16.3945L2.98828 19.9746C3.01758 23.9121 2.99414 23.6719 3.38086 23.6719C3.76758 23.6719 3.75 23.8887 3.75 19.043C3.75 14.9238 3.75586 14.666 3.85547 14.4785C3.91406 14.3672 4.05469 14.2266 4.16602 14.168C4.35352 14.0684 4.69336 14.0625 11.3496 14.0625H18.3398V14.7832C18.3398 15.5801 18.3867 15.7031 18.7031 15.7031C18.9961 15.7031 19.0723 15.5274 19.0898 14.7598L19.1133 14.0625H23.4258C27.6035 14.0625 27.75 14.0684 27.9316 14.1797C28.0371 14.2383 28.166 14.3613 28.2246 14.4551C28.3242 14.6074 28.3301 14.9414 28.3301 20.918C28.3301 26.9883 28.3242 27.2227 28.2188 27.3985C28.1602 27.4981 28.0254 27.6328 27.9258 27.6914C27.75 27.7969 27.5391 27.8028 23.4258 27.8203L19.1133 27.8379L19.0898 27.252C19.0723 26.6074 18.9844 26.4258 18.6914 26.4258C18.4043 26.4258 18.3398 26.5723 18.3398 27.2344V27.832L11.3262 27.8203L4.30664 27.8028L4.11328 27.668C3.82031 27.457 3.75 27.2637 3.75 26.6778C3.75 26.0391 3.67383 25.8985 3.33984 25.8985C3.16992 25.8985 3.09375 25.9278 3.04688 26.0098C2.9707 26.1563 2.9707 27.211 3.04688 27.4922C3.14062 27.8262 3.45117 28.1895 3.80273 28.3711L4.11328 28.5352H16.0312C29.2676 28.5352 28.1309 28.5703 28.6172 28.125C29.127 27.6563 29.0918 28.1895 29.0918 20.8887V14.4434L28.9512 14.1797C28.875 14.0332 28.752 13.8457 28.6699 13.7578L28.5234 13.5996L28.9688 12.3633C29.3496 11.3028 29.4141 11.0684 29.4141 10.7461C29.4141 10.0957 29.1445 9.65041 28.5703 9.38088C28.377 9.28713 23.3496 7.46486 17.4023 5.33791C7.29492 1.71681 6.5625 1.46486 6.21094 1.46486C5.93555 1.46486 5.74805 1.50588 5.53711 1.60549ZM12.8906 4.54103C16.4473 5.81838 19.377 6.87306 19.4004 6.89064C19.4238 6.90236 19.3535 7.17189 19.2422 7.48244C18.9961 8.15627 18.9961 8.4258 19.2305 8.54299C19.4238 8.63674 19.6641 8.5547 19.7461 8.3672C19.7754 8.29103 19.8867 7.9922 19.9922 7.69338L20.1855 7.16017L24.1699 8.584C26.3613 9.37502 28.2188 10.0488 28.2949 10.0899C28.4941 10.1953 28.6523 10.4824 28.6523 10.7344C28.6523 10.8516 28.4648 11.4727 28.2305 12.1231C27.8145 13.2949 27.8145 13.3008 27.6387 13.3008C27.498 13.3008 27.4746 13.2832 27.5098 13.1953C27.5332 13.1426 27.6797 12.7324 27.8379 12.293C28.3477 10.8809 28.3301 10.8516 26.5723 10.2246C25.8984 9.98439 25.2656 9.78517 25.1777 9.78517C24.9434 9.78517 24.6855 9.94924 24.5859 10.166C24.3516 10.6699 23.7188 12.5391 23.7188 12.7324C23.7129 12.8731 23.7598 13.0195 23.8418 13.1309L23.9707 13.3008H20.9707C18.1406 13.3008 17.9766 13.2949 18.0176 13.1953C18.1875 12.7676 18.0703 12.4805 17.7188 12.4805C17.4961 12.4805 17.3906 12.5977 17.25 13.0195L17.1562 13.3008H16.5879H16.0137L16.916 10.793C17.4082 9.41603 17.8301 8.19728 17.8477 8.0801C17.8711 7.95705 17.8535 7.77541 17.8184 7.66408C17.666 7.20119 17.7598 7.23635 12.2812 5.27931C9.375 4.23635 7.10742 3.45705 6.99609 3.45705C6.73828 3.45705 6.45117 3.5801 6.28125 3.76174C6.08203 3.97853 3.98438 9.84963 3.98438 10.1953C3.98438 10.5469 4.14844 10.8399 4.42969 10.9922C4.55273 11.0625 6.01172 11.6016 7.66406 12.1934L10.6758 13.2715L7.37109 13.3008C4.125 13.3301 4.06641 13.3301 3.83203 13.459C3.70312 13.5293 3.51562 13.6699 3.41016 13.7754C3.09961 14.0918 3.02344 14.3203 3 14.9824L2.97656 15.5801L2.38477 15.3692C2.05664 15.252 1.72852 15.1172 1.65234 15.0703C1.4707 14.9531 1.34766 14.7012 1.34766 14.4492C1.34766 14.1973 5.4375 2.75393 5.61328 2.52541C5.75977 2.32619 5.95898 2.22658 6.2168 2.22658C6.3457 2.22658 8.89453 3.11135 12.8906 4.54103ZM12.0234 6.00588C16.4648 7.59963 17.1152 7.85158 17.1035 7.96877C17.1035 7.98635 16.6758 9.18166 16.1543 10.6348L15.2051 13.2715L14.1211 13.2832L13.0371 13.3008L8.90625 11.8184C5.4668 10.582 4.77539 10.3184 4.75781 10.2246C4.74023 10.1016 6.76172 4.41799 6.86719 4.29494C6.90234 4.25393 6.94922 4.21877 6.97852 4.21877C7.00781 4.21877 9.27539 5.0215 12.0234 6.00588ZM26.3379 10.9629C26.8887 11.1621 27.3398 11.3262 27.3457 11.332C27.3516 11.3379 27.1992 11.7774 27.0117 12.3047C26.8184 12.8379 26.6602 13.2774 26.6602 13.2832C26.6602 13.2949 26.5605 13.3008 26.4434 13.3008C26.168 13.3008 24.4805 12.7149 24.5098 12.627C24.5215 12.5977 24.6914 12.1289 24.8789 11.5899C25.0664 11.0508 25.2539 10.6055 25.2832 10.6055C25.3184 10.6055 25.793 10.7695 26.3379 10.9629Z" />
                            <path
                                d="M18.6094 9.45117C18.4922 9.53906 17.9297 11.0684 17.9297 11.3086C17.9297 11.4023 17.9707 11.5195 18.0234 11.5664C18.1348 11.6777 18.3984 11.6894 18.5273 11.584C18.6328 11.5078 19.2188 9.91992 19.2188 9.72656C19.2188 9.45703 18.8379 9.28125 18.6094 9.45117Z" />
                            <path
                                d="M9.42769 6.9082C9.14058 7.00195 6.5566 8.79492 6.43941 8.98828C6.34566 9.12891 6.32808 9.24609 6.34566 9.50977C6.3691 9.92578 6.55074 10.1367 7.02535 10.3184C8.66597 10.9336 13.5644 12.6562 13.664 12.6562C13.9043 12.6504 14.291 12.4336 14.414 12.2344C14.4785 12.1289 14.5312 11.9355 14.5312 11.8125C14.5312 11.5254 14.0214 9.61523 13.8867 9.38672C13.7636 9.19336 13.4472 9.02344 13.1953 9.02344C13.0957 9.02344 12.5918 9.16406 12.082 9.33984L11.1503 9.65625L10.8164 8.51367C10.6347 7.88672 10.4414 7.30664 10.3886 7.23047C10.2187 6.9668 9.7441 6.80859 9.42769 6.9082ZM10.1953 9.14648C10.4531 10.0488 10.6406 10.6055 10.705 10.6465C10.8691 10.7695 11.0742 10.7344 11.2441 10.5586C11.3554 10.4297 11.6308 10.3066 12.2929 10.0781C12.8086 9.89648 13.207 9.79102 13.2363 9.82031C13.33 9.92578 13.7871 11.7832 13.7343 11.8359C13.664 11.9062 7.0898 9.55078 7.0898 9.45117C7.0898 9.35156 9.67965 7.60547 9.73824 7.66406C9.76754 7.69336 9.97261 8.35547 10.1953 9.14648Z" />
                            <path
                                d="M11.6191 7.03711C11.1679 7.16602 10.8457 7.72266 10.9277 8.23828C11.0039 8.75391 11.4668 9.14062 11.9941 9.14062C13.1367 9.14062 13.4941 7.55273 12.457 7.08398C12.1992 6.9668 11.9179 6.94922 11.6191 7.03711Z" />
                            <path
                                d="M24.5801 14.8945C24.2637 15.0644 24.2578 15.0937 24.2578 16.6875V18.1758L24.457 18.375L24.6562 18.5742H26.0684C28.1309 18.5742 28.0195 18.6855 27.9961 16.6055L27.9785 15.1641L27.7852 14.9941L27.5977 14.8242H26.1445C25.207 14.8301 24.6562 14.8477 24.5801 14.8945ZM27.2461 16.6992V17.8125H26.1328H25.0195V16.6992V15.5859H26.1328H27.2461V16.6992Z" />
                            <path
                                d="M5.52539 15C5.26172 15.0586 5.05078 15.2109 4.92188 15.4277C4.81055 15.6094 4.80469 15.75 4.80469 18.9902V22.3652L4.93945 22.5586C5.00977 22.6641 5.14453 22.8105 5.23242 22.875C5.39648 22.998 5.41992 22.998 10.916 23.0156L16.4355 23.0273L16.6992 22.8984C16.875 22.8105 17.0098 22.6816 17.0918 22.5293L17.2266 22.2949V19.0195C17.2266 15.8672 17.2207 15.7324 17.1094 15.5039C17.0449 15.3691 16.8984 15.1992 16.7754 15.1172L16.5586 14.9707L11.1387 14.959C8.15625 14.959 5.625 14.9707 5.52539 15ZM16.3535 15.7617C16.459 15.8203 16.4648 15.9199 16.4648 18.9727C16.4648 21.3457 16.4473 22.1426 16.3945 22.1953C16.2949 22.2949 5.73633 22.2949 5.63672 22.1953C5.58398 22.1426 5.56641 21.3457 5.56641 18.9727C5.56641 16.0371 5.57227 15.8203 5.67188 15.7676C5.8125 15.6855 16.1953 15.6797 16.3535 15.7617Z" />
                            <path
                                d="M11.291 16.6699C10.8574 16.8223 10.6055 17.1855 10.6055 17.6543C10.6055 18.3105 11.0449 18.75 11.7012 18.75C12.6387 18.7441 13.1191 17.5781 12.457 16.9277C12.1172 16.5996 11.7246 16.5117 11.291 16.6699Z" />
                            <path
                                d="M9.05276 17.3672C8.80667 17.4785 8.68362 17.6309 7.68753 19.002C7.09573 19.8105 6.79104 20.2852 6.76175 20.4258C6.70901 20.7246 6.8262 21.0527 7.06057 21.2637L7.27151 21.4453H11.0332C14.6602 21.4453 14.8008 21.4395 14.9824 21.3281C15.2285 21.1816 15.3516 20.9297 15.3516 20.5723C15.3516 20.3086 15.3106 20.2266 14.9004 19.6172C13.9805 18.2578 13.8633 18.1406 13.3828 18.1523C13.0664 18.1523 13.0078 18.1875 12.1465 18.873L11.4199 19.459L10.7344 18.5098C10.3594 17.9883 9.97854 17.5078 9.89651 17.4434C9.69729 17.2969 9.28128 17.2617 9.05276 17.3672ZM10.3242 19.2832C10.8809 20.0566 11.2383 20.4961 11.3321 20.5312C11.5489 20.6133 11.7715 20.4902 11.8125 20.2793C11.8418 20.1387 12.0117 19.9746 12.5801 19.5293C12.9785 19.2129 13.3418 18.9492 13.3887 18.9375C13.459 18.9199 14.4844 20.3086 14.5723 20.543C14.5899 20.5957 14.5723 20.6602 14.5254 20.6895C14.4199 20.7539 7.66995 20.7539 7.56448 20.6895C7.45901 20.625 7.44729 20.6426 8.52542 19.1719C8.97659 18.5508 9.37503 18.0586 9.40432 18.0645C9.43948 18.0762 9.84964 18.6211 10.3242 19.2832Z" />
                            <path
                                d="M18.4395 16.6875C18.3574 16.7813 18.3398 16.9453 18.3398 17.7949C18.3398 18.6856 18.3516 18.8027 18.4453 18.8848C18.5918 19.0195 18.8262 19.0078 18.9609 18.8613C19.0605 18.75 19.0723 18.6387 19.0723 17.7832C19.0723 16.9278 19.0605 16.8164 18.9609 16.7051C18.8262 16.5528 18.5684 16.5469 18.4395 16.6875Z" />
                            <path
                                d="M1.69922 17.1094C1.59375 17.2148 1.58203 17.3027 1.58203 18.0645C1.58203 19.0254 1.62891 19.1602 1.95703 19.1602C2.30859 19.1602 2.34375 19.0547 2.34375 18.0645C2.34375 17.2852 2.33203 17.1738 2.23828 17.0918C2.0918 16.957 1.83984 16.9688 1.69922 17.1094Z" />
                            <path
                                d="M1.72264 19.8867C1.61717 19.9688 1.61131 20.086 1.58201 22.6289C1.55858 24.3867 1.57029 25.3301 1.61131 25.4297C1.65819 25.5469 1.71678 25.5821 1.91014 25.5938C2.32615 25.6231 2.31444 25.7344 2.33201 22.7285C2.35545 20.0801 2.34959 20.0449 2.2324 19.9278C2.09178 19.7871 1.8867 19.7696 1.72264 19.8867Z" />
                            <path
                                d="M18.4395 19.9688C18.3574 20.0625 18.3398 20.2266 18.3398 21.0762C18.3398 21.9668 18.3516 22.084 18.4453 22.166C18.5918 22.3008 18.8262 22.2891 18.9609 22.1426C19.0605 22.0313 19.0723 21.9199 19.0723 21.0645C19.0723 20.209 19.0605 20.0977 18.9609 19.9863C18.8262 19.834 18.5684 19.8281 18.4395 19.9688Z" />
                            <path
                                d="M20.0391 20.4258C19.9922 20.4726 19.9629 20.5898 19.9629 20.6836C19.9629 21.0527 19.7403 21.0351 23.8477 21.0351C27.3868 21.0351 27.586 21.0293 27.6739 20.9297C27.8028 20.7891 27.7969 20.5488 27.668 20.4316C27.5684 20.3437 27.2169 20.332 23.836 20.332C20.543 20.332 20.1036 20.3437 20.0391 20.4258Z" />
                            <path
                                d="M20.1679 22.6758C19.9804 22.752 19.8984 22.9981 19.998 23.1914L20.0683 23.3496L23.8125 23.3672C27.2343 23.3789 27.5683 23.3731 27.6679 23.2852C27.8086 23.1504 27.8027 22.8984 27.6504 22.7578C27.5332 22.6523 27.375 22.6465 23.9121 22.6348C21.8144 22.6289 20.25 22.6465 20.1679 22.6758Z" />
                            <path
                                d="M18.4395 23.25C18.3574 23.3438 18.3398 23.5078 18.3398 24.3574C18.3398 25.2481 18.3516 25.3652 18.4453 25.4473C18.5918 25.582 18.8262 25.5703 18.9609 25.4238C19.0605 25.3125 19.0723 25.2012 19.0723 24.3457C19.0723 23.4903 19.0605 23.3789 18.9609 23.2676C18.8262 23.1153 18.5684 23.1094 18.4395 23.25Z" />
                            <path
                                d="M4.96294 24.1875C4.83403 24.3281 4.83989 24.5684 4.9688 24.6855C5.06841 24.7793 5.57818 24.7852 11.0918 24.7852C16.9747 24.7852 17.1094 24.7852 17.168 24.6738C17.2501 24.5215 17.2442 24.2402 17.1563 24.1523C17.1036 24.0996 15.6739 24.082 11.0743 24.082C5.32036 24.082 5.05083 24.0879 4.96294 24.1875Z" />
                            <path
                                d="M20.0918 25.0664C20.0098 25.1368 19.9629 25.2422 19.9629 25.3594C19.9629 25.7461 19.7285 25.7227 23.8535 25.7227H27.5918L27.6797 25.5938C27.8145 25.4004 27.791 25.2188 27.6211 25.084C27.4687 24.961 27.416 24.961 23.8477 24.961C20.4199 24.961 20.2207 24.9668 20.0918 25.0664Z" />
                            <path
                                d="M5.15628 25.9981C4.87503 26.1035 4.78714 26.3496 4.95706 26.5899L5.04495 26.7188H11.045C17.7364 26.7188 17.25 26.7481 17.2149 26.3145C17.2032 26.1621 17.1621 26.0859 17.0508 26.0332C16.9336 25.9746 15.6504 25.957 11.0743 25.9629C7.86917 25.9629 5.20316 25.9805 5.15628 25.9981Z" />
                        </svg>
                        <h6>{{ translate('Email Template') }}</h6>
                    </a>
                </li>
                @endadmin
                <li class="{{ Route::is('dashboard.supports.*') ? 'active' : '' }}">
                    <a href="{{ route('dashboard.supports.index') }}">
                        <svg width="30" height="30" viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M14.7891 0.0527345C14.7188 0.0820314 14.6074 0.181641 14.5371 0.275391C14.4141 0.421875 14.4082 0.492188 14.4258 1.06641C14.4434 1.66406 14.4492 1.70508 14.6074 1.85742C14.8301 2.08008 15.1699 2.08008 15.3984 1.85742C15.5508 1.69922 15.5566 1.68164 15.5566 1.02539C15.5566 0.386719 15.5508 0.345703 15.4102 0.205078C15.2461 0.0410157 14.9766 -0.0234373 14.7891 0.0527345Z" />
                            <path
                                d="M11.5781 1.20117C11.3379 1.33008 11.2559 1.45899 11.25 1.7168C11.25 1.92188 11.2969 1.99219 11.6484 2.35547C12.2285 2.96485 12.5508 3.05274 12.8613 2.6836C13.125 2.36719 13.043 2.09766 12.498 1.57032C12.2051 1.28321 11.9414 1.11328 11.7891 1.11328C11.7656 1.11328 11.6719 1.1543 11.5781 1.20117Z" />
                            <path
                                d="M17.4492 1.63477C17.0508 2.04493 16.9922 2.12696 16.9922 2.31446C16.9922 2.58985 17.1328 2.78907 17.3789 2.8711C17.6719 2.97071 17.8418 2.88282 18.334 2.37305C18.6973 2.00391 18.75 1.91602 18.75 1.72852C18.75 1.41212 18.4922 1.17188 18.1582 1.17188C17.918 1.17188 17.877 1.20118 17.4492 1.63477Z" />
                            <path
                                d="M14.3262 3.24609C13.4473 3.41601 12.5098 4.0957 12.0469 4.88672L11.8184 5.27344L11.6719 5.17969C11.127 4.82226 10.6992 4.6875 10.1074 4.6875C9.22267 4.6875 8.4258 5.13281 7.92775 5.90625C7.60548 6.4043 7.55275 6.66211 7.51759 7.76367C7.47072 9.26953 7.61134 9.77344 8.27345 10.4648C8.46095 10.6582 8.6133 10.8574 8.6133 10.9043C8.6133 10.9629 8.40822 11.0332 7.9629 11.1445C7.18947 11.332 6.78517 11.5137 6.39845 11.8652C5.74806 12.4512 5.51369 13.0488 5.46681 14.2383C5.44337 14.9238 5.45509 15.0586 5.54884 15.2344C5.72462 15.5684 5.8008 15.5859 7.34181 15.5859H8.73048V16.7578C8.73048 18.1113 8.7715 18.2871 9.10548 18.4277C9.26955 18.498 9.65626 18.5156 11.0332 18.5156C11.9824 18.5156 12.8379 18.498 12.9434 18.4805C13.4121 18.3867 13.582 17.8477 13.2481 17.5137C13.0899 17.3555 13.043 17.3437 12.668 17.3437H12.2578L12.2344 16.6055L12.2168 15.8672L12.0176 15.6914C11.8535 15.5449 11.7891 15.5215 11.6074 15.5508C11.4727 15.5684 11.3379 15.6504 11.2383 15.7617C11.0801 15.9375 11.0742 15.9551 11.0742 16.6406V17.3437H10.4883H9.90236V16.5352C9.90236 16.0898 9.93165 15.5742 9.96681 15.3867C10.1074 14.6133 10.5938 13.9629 11.2617 13.6523C11.6016 13.4941 13.336 13.0195 13.3887 13.0723C13.4004 13.084 13.6524 13.6465 13.9453 14.3262C14.2617 15.0527 14.543 15.6094 14.625 15.6855C14.7246 15.7793 14.8477 15.8203 15 15.8203C15.1524 15.8203 15.2754 15.7793 15.375 15.6855C15.4629 15.6094 15.7324 15.0762 16.0547 14.3262C16.3535 13.6465 16.5996 13.0898 16.6113 13.0781C16.6582 13.0254 18.4277 13.5059 18.7442 13.6523C19.4004 13.9629 19.8926 14.625 20.0332 15.3867C20.0684 15.5742 20.0977 16.0898 20.0977 16.5352V17.3437H19.5176H18.9375L18.9141 16.6055L18.8965 15.8672L18.6973 15.6914C18.5332 15.5449 18.4688 15.5215 18.2871 15.5508C18.1524 15.5684 18.0176 15.6504 17.918 15.7617C17.7598 15.9375 17.7539 15.9551 17.7539 16.6406V17.3437H17.3086C16.8985 17.3437 16.8516 17.3555 16.6934 17.5137C16.3594 17.8477 16.5293 18.3867 16.9981 18.4805C17.1035 18.498 17.9707 18.5156 18.9375 18.5156C20.918 18.5156 21.0352 18.498 21.1817 18.1406C21.252 17.9824 21.2695 17.6602 21.2695 16.7637V15.5918L22.7344 15.5742L24.1992 15.5566L24.3574 15.3926C24.5098 15.2402 24.5215 15.1992 24.5391 14.6016C24.586 13.3125 24.3281 12.5449 23.6602 11.918C23.2149 11.5137 22.8633 11.3437 22.0254 11.1387C21.586 11.0332 21.3867 10.9629 21.3867 10.9043C21.3867 10.8574 21.5391 10.6582 21.7324 10.4648C22.3594 9.80859 22.5 9.36328 22.5 8.02148C22.5 6.94336 22.4473 6.60351 22.2012 6.11719C21.7617 5.24414 20.8594 4.6875 19.8809 4.6875C19.4531 4.6875 18.8731 4.83398 18.5918 5.01562C18.5156 5.0625 18.3926 5.13867 18.3164 5.19141C18.1758 5.2793 18.1699 5.2793 18.041 5.02734C17.3555 3.67969 15.8262 2.94726 14.3262 3.24609ZM15.5742 4.41797C16.3418 4.62305 16.9981 5.29101 17.1914 6.05859L17.2324 6.22266L16.9805 6.08203C16.1485 5.5957 16.0488 5.55469 15.8731 5.58984C15.7735 5.60742 15.5332 5.76562 15.334 5.94726C14.7305 6.49219 14.2266 6.67383 13.3067 6.67969H12.7559L12.791 6.33398C12.9082 5.00976 14.2735 4.07226 15.5742 4.41797ZM10.875 6.07031C11.1328 6.22851 11.4258 6.55664 11.4258 6.68555C11.4258 6.71484 11.3262 6.7793 11.209 6.83203C10.7285 7.04297 10.1543 7.1543 9.41603 7.18945L8.66603 7.22461L8.70705 7.05469C8.83595 6.52148 9.06447 6.2168 9.5215 5.99414C9.94337 5.79492 10.4766 5.82422 10.875 6.07031ZM20.3379 5.91797C20.7598 6.03516 21.1934 6.5332 21.2988 7.01367L21.3399 7.20703H20.8711C20.6074 7.20703 20.1973 7.17773 19.9453 7.14258C19.4649 7.07812 18.627 6.80273 18.5918 6.70312C18.5801 6.66797 18.6504 6.5332 18.7442 6.4043C19.0664 5.95312 19.7344 5.75391 20.3379 5.91797ZM16.6524 7.24805L17.2266 7.58203V8.23242C17.2266 9.16992 17.0567 9.61523 16.5059 10.1191C16.1602 10.4355 15.8672 10.582 15.3867 10.6699C14.4024 10.8516 13.3945 10.3184 12.961 9.38672C12.832 9.11133 12.8027 8.94726 12.7852 8.44922L12.7617 7.85156H13.336C13.6582 7.85156 14.0977 7.81055 14.3262 7.76367C14.7832 7.66406 15.4395 7.36523 15.791 7.0957C15.9199 6.99609 16.0371 6.91406 16.0488 6.91406C16.0606 6.91406 16.3301 7.06641 16.6524 7.24805ZM11.6016 8.28516C11.6016 9.10547 11.3379 9.62695 10.7871 9.91406C9.99611 10.3301 9.01173 9.91992 8.75978 9.07031C8.7129 8.90625 8.67189 8.68359 8.67189 8.58398V8.39648L9.48048 8.36133C10.2363 8.32617 11.1152 8.16797 11.3613 8.02734C11.5547 7.91016 11.6016 7.95703 11.6016 8.28516ZM18.7324 8.05664C19.1777 8.22656 19.7344 8.32617 20.5313 8.36133L21.3399 8.39648L21.3106 8.73047C21.1817 10.1895 19.2539 10.5937 18.6035 9.29883C18.4805 9.04687 18.457 8.91797 18.457 8.48437C18.457 8.20312 18.4688 7.96875 18.4863 7.96875C18.4981 7.96875 18.6152 8.00976 18.7324 8.05664ZM12.6152 10.875C12.8965 11.1504 13.0781 11.3613 13.0195 11.3379C12.9668 11.3145 12.6328 11.2266 12.2813 11.1445C11.9356 11.0566 11.6309 10.957 11.6192 10.916C11.5957 10.8574 12.0059 10.4062 12.1055 10.3711C12.1113 10.3711 12.3399 10.5996 12.6152 10.875ZM18.1582 10.5996C18.3106 10.7402 18.4043 10.8633 18.3809 10.9102C18.3633 10.957 18.1465 11.0391 17.8652 11.1035C17.5957 11.1621 17.2676 11.25 17.1445 11.291C17.0156 11.332 16.9043 11.3613 16.8985 11.3496C16.8867 11.3379 17.0039 11.2383 17.1563 11.127C17.3086 11.0098 17.5254 10.793 17.6367 10.6465C17.7481 10.4941 17.8535 10.377 17.8711 10.377C17.8887 10.377 18.0176 10.4766 18.1582 10.5996ZM10.459 11.4844C10.5117 11.8125 10.7402 11.9824 11.2793 12.0996C11.5195 12.1523 11.7188 12.2051 11.7188 12.2168C11.7188 12.2285 11.5664 12.2812 11.3848 12.334C10.5 12.5918 9.60939 13.2949 9.21095 14.0449L9.01759 14.4141H7.81056H6.60353L6.63869 13.9746C6.69728 13.2891 6.91408 12.8848 7.37111 12.5918C7.54689 12.4805 7.92189 12.3574 8.54298 12.2109C9.59181 11.9531 9.78517 11.8418 9.78517 11.4609V11.25H10.1016H10.418L10.459 11.4844ZM20.2149 11.4609C20.2149 11.8359 20.4141 11.959 21.3574 12.1816C21.8086 12.2871 22.2832 12.4219 22.4121 12.4746C22.9981 12.7324 23.3027 13.2012 23.3613 13.9453L23.3965 14.4141H22.1895H20.9824L20.7891 14.0449C20.3906 13.2949 19.5 12.5918 18.6211 12.334C18.4336 12.2812 18.2813 12.2285 18.2813 12.2168C18.2813 12.2051 18.4805 12.1523 18.7207 12.0996C19.2598 11.9824 19.4942 11.8066 19.5469 11.4785L19.5879 11.25H19.8985H20.2149V11.4609ZM15.7031 12.041C15.7031 12.1406 15.5449 12.5742 15.3574 13.002L15.0117 13.7871L14.9238 13.6172C14.666 13.1133 14.2969 12.1758 14.2969 12.0352V11.8652H15H15.7031V12.041Z" />
                            <path
                                d="M1.69922 9.19924C1.00195 9.28127 0.328125 9.84963 0.117188 10.5293C0.00585938 10.8985 0 11.0684 0 15.7324C0 18.8321 0.0234375 20.7246 0.0644531 21.0176C0.140625 21.586 0.410156 22.4121 0.685547 22.9102C0.919922 23.3438 2.03906 24.9375 2.22656 25.1074C2.58398 25.4297 3.26367 25.0078 3.14062 24.5332C3.12305 24.4629 2.83008 24.0059 2.49609 23.5254C2.15625 23.0391 1.76953 22.4356 1.64648 22.1778C1.18945 21.2637 1.20703 21.5508 1.18945 15.9551C1.17188 11.5723 1.17773 10.9395 1.25391 10.7871C1.52344 10.2656 2.25586 10.2129 2.60156 10.6817C2.72461 10.8457 2.72461 10.9043 2.75391 14.959C2.78906 19.4766 2.77734 19.3301 3.1582 20.0977C3.43945 20.6602 3.63867 20.9121 4.72852 22.0723C6.70898 24.1875 6.84375 24.3164 7.0957 24.3164C7.24805 24.3164 7.37109 24.2695 7.49414 24.1641C7.64648 24.0352 7.67578 23.9707 7.67578 23.7539C7.67578 23.502 7.66406 23.4844 6.4043 22.1426C4.43555 20.0508 4.5 20.1328 4.5 19.6817C4.5 19.1426 4.85156 18.7852 5.39062 18.7793C5.70703 18.7793 5.73047 18.791 6.79688 19.5059C8.22656 20.4668 8.67188 20.8125 9.19922 21.3633C9.93164 22.1309 10.4941 23.0742 10.8574 24.1406C10.9395 24.3809 11.2441 25.711 11.5371 27.0996C12.0879 29.707 12.1348 29.8594 12.4336 29.9649C12.7793 30.0879 13.1836 29.8067 13.1836 29.4434C13.1836 29.2324 12.3574 25.2129 12.1348 24.3399C11.8535 23.25 11.3145 22.1192 10.623 21.211C10.3066 20.7891 9.49805 19.9981 9.02344 19.6348C8.38477 19.1426 6.46289 17.8711 6.16992 17.7422C5.57227 17.4785 4.81055 17.5606 4.22461 17.9531L3.93164 18.1524L3.91406 14.3965C3.89648 10.6817 3.89648 10.6289 3.76758 10.3594C3.4043 9.56252 2.56641 9.09963 1.69922 9.19924Z" />
                            <path
                                d="M27.2168 9.36917C26.8125 9.55667 26.4141 9.9551 26.2324 10.3594C26.1035 10.6289 26.1035 10.6817 26.0859 14.3965L26.0684 18.1524L25.7754 17.9531C25.1895 17.5606 24.4277 17.4785 23.8301 17.7422C23.5371 17.8711 21.6152 19.1426 20.9766 19.6348C20.502 19.9981 19.6934 20.7891 19.377 21.211C18.6855 22.1192 18.1465 23.25 17.8652 24.3399C17.6426 25.2129 16.8164 29.2324 16.8164 29.4434C16.8164 29.8067 17.2207 30.0879 17.5664 29.9649C17.8652 29.8594 17.9121 29.707 18.4629 27.0996C18.7559 25.711 19.0605 24.3809 19.1426 24.1406C19.5059 23.0742 20.0684 22.1309 20.8008 21.3633C21.3281 20.8125 21.7734 20.4668 23.2031 19.5059C24.2695 18.791 24.293 18.7793 24.6094 18.7793C25.1484 18.7852 25.5 19.1426 25.5 19.6817C25.5 20.1328 25.5645 20.0508 23.6016 22.1426C22.3359 23.4844 22.3242 23.502 22.3242 23.7539C22.3242 23.9707 22.3535 24.0352 22.5059 24.1641C22.6289 24.2696 22.752 24.3164 22.9043 24.3164C23.1562 24.3164 23.291 24.1875 25.2715 22.0723C26.3613 20.9121 26.5605 20.6602 26.8418 20.0977C27.2227 19.3301 27.2109 19.4766 27.2461 14.959C27.2754 10.9043 27.2754 10.8457 27.3984 10.6817C27.7441 10.2129 28.4766 10.2657 28.7402 10.7813C28.8164 10.9278 28.8281 11.6192 28.8281 15.7207C28.8281 20.9414 28.8164 21.1172 28.4883 21.9141C28.2598 22.4414 28.0781 22.7168 25.6875 26.0801C24.5332 27.7031 23.5547 29.1328 23.5137 29.2559C23.4492 29.4434 23.4492 29.502 23.5254 29.6485C23.7012 29.9883 24.0234 30.0879 24.334 29.8945C24.5156 29.7832 29.0449 23.4317 29.3379 22.875C29.5957 22.3887 29.8652 21.5625 29.9355 21.0176C29.9766 20.7246 30 18.8321 30 15.7324C30 11.0684 29.9941 10.8985 29.8828 10.5293C29.7246 10.0254 29.3613 9.61526 28.8574 9.37503C28.5469 9.22854 28.418 9.19925 28.0312 9.19925C27.6445 9.19925 27.5098 9.22854 27.2168 9.36917Z" />
                            <path
                                d="M14.6308 17.4844C14.1035 17.9766 14.7597 18.791 15.3339 18.3633C15.7734 18.0351 15.5449 17.3437 14.9999 17.3437C14.8535 17.3437 14.7363 17.3906 14.6308 17.4844Z" />
                            <path
                                d="M3.48638 26.0332C3.38677 26.1153 3.32231 26.2442 3.29888 26.4024C3.27544 26.6074 3.29302 26.6719 3.4395 26.836C3.56841 26.9766 3.6563 27.0235 3.82622 27.0293C4.21294 27.041 4.51763 26.6836 4.42974 26.3321C4.32427 25.9219 3.80278 25.7578 3.48638 26.0332Z" />
                            <path
                                d="M4.67575 27.7734C4.38279 28.0664 4.44724 28.3008 5.05661 29.1504C5.54294 29.8418 5.71872 30 5.99411 30C6.16989 30 6.36911 29.8535 6.47458 29.6484C6.55075 29.502 6.55075 29.4434 6.4863 29.2559C6.39255 28.9863 5.61911 27.8848 5.40818 27.7148C5.17966 27.5391 4.89255 27.5625 4.67575 27.7734Z" />
                        </svg>
                        <h6>{{ translate('Ticket/Support') }}</h6>
                    </a>
                </li>
                @admin
                <li class="{{ Route::is('dashboard.languages.*') ? 'active' : '' }}">
                    <a href="{{ route('dashboard.languages.index') }}">
                        <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor"
                            class="bi bi-translate" viewBox="0 0 16 16">
                            <path
                                d="M4.545 6.714 4.11 8H3l1.862-5h1.284L8 8H6.833l-.435-1.286H4.545zm1.634-.736L5.5 3.956h-.049l-.679 2.022H6.18z" />
                            <path
                                d="M0 2a2 2 0 0 1 2-2h7a2 2 0 0 1 2 2v3h3a2 2 0 0 1 2 2v7a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2v-3H2a2 2 0 0 1-2-2V2zm2-1a1 1 0 0 0-1 1v7a1 1 0 0 0 1 1h7a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1H2zm7.138 9.995c.193.301.402.583.63.846-.748.575-1.673 1.001-2.768 1.292.178.217.451.635.555.867 1.125-.359 2.08-.844 2.886-1.494.777.665 1.739 1.165 2.93 1.472.133-.254.414-.673.629-.89-1.125-.253-2.057-.694-2.82-1.284.681-.747 1.222-1.651 1.621-2.757H14V8h-3v1.047h.765c-.318.844-.74 1.546-1.272 2.13a6.066 6.066 0 0 1-.415-.492 1.988 1.988 0 0 1-.94.31z" />
                        </svg>
                        <h6>{{ translate('Languages') }}</h6>
                    </a>
                </li>
                <li class="{{ Route::is('dashboard.locations.*') ? 'active' : '' }}">
                    <a href="{{ route('dashboard.locations.index') }}">
                        <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor"
                            class="bi bi-geo-alt" viewBox="0 0 16 16">
                            <path
                                d="M12.166 8.94c-.524 1.062-1.234 2.12-1.96 3.07A31.493 31.493 0 0 1 8 14.58a31.481 31.481 0 0 1-2.206-2.57c-.726-.95-1.436-2.008-1.96-3.07C3.304 7.867 3 6.862 3 6a5 5 0 0 1 10 0c0 .862-.305 1.867-.834 2.94zM8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10z" />
                            <path d="M8 8a2 2 0 1 1 0-4 2 2 0 0 1 0 4zm0 1a3 3 0 1 0 0-6 3 3 0 0 0 0 6z" />
                        </svg>
                        <h6>{{ translate('Location') }}</h6>
                    </a>
                </li>
                <li class="{{ Route::is('dashboard.contacts.*') ? 'active' : '' }}">
                    <a href="{{ route('dashboard.contacts.index') }}">
                        <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor"
                            class="bi bi-envelope" viewBox="0 0 16 16">
                            <path
                                d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1zm13 2.383-4.708 2.825L15 11.105zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741M1 11.105l4.708-2.897L1 5.383z" />
                        </svg>
                        <h6>{{ translate('Contact') }}</h6>
                        @if (contact_unread() > 0)
                        <span class="sidebar_count">{{ contact_unread() }}</span>
                        @endif
                    </a>
                </li>

                <li class="{{ Route::is('dashboard.backend.setting') ? 'active' : '' }}">
                    <a href="{{ route('dashboard.backend.setting') }}">
                        <svg width="30" height="30" viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M1.875 1.01367C1.58789 1.10742 1.0957 1.61133 1.00781 1.91015C0.908203 2.26172 0.908203 22.1133 1.00781 22.4648C1.10156 22.7871 1.58789 23.2734 1.91016 23.3672C2.0918 23.4199 3.28711 23.4375 6.63281 23.4375H11.1211L10.5352 25.7812L9.94922 28.125H8.95899H7.96875V28.5937V29.0625H15H22.0313V28.5937V28.125H21.041H20.0508L19.4648 25.7812L18.8789 23.4375H23.373C28.4883 23.4375 28.2305 23.4609 28.6699 22.9687C28.8105 22.8164 28.957 22.582 28.9922 22.4531C29.0918 22.1191 29.0918 2.25586 28.9922 1.92187C28.957 1.79297 28.8105 1.55859 28.6699 1.40625C28.207 0.890623 29.5195 0.937498 14.9766 0.943357C5.75391 0.949217 2.02148 0.966795 1.875 1.01367ZM27.9785 2.02148C28.1016 2.13867 28.125 2.2207 28.125 2.49023V2.8125H16.4063H4.6875V3.28125V3.75H16.4063H28.125V11.7187V19.6875H15H1.875V10.9277V2.16211L2.02148 2.02148L2.16211 1.875H15H27.8379L27.9785 2.02148ZM28.125 21.416C28.125 22.1836 28.1191 22.2187 27.9785 22.3535L27.8379 22.5H15H2.16211L2.02148 22.3535C1.88086 22.2187 1.875 22.1836 1.875 21.416V20.625H15H28.125V21.416ZM18.5039 25.7812L19.0898 28.125H15H10.9102L11.4961 25.7812L12.082 23.4375H15H17.918L18.5039 25.7812Z" />
                            <path d="M2.8125 3.28125V3.75H3.28125H3.75V3.28125V2.8125H3.28125H2.8125V3.28125Z" />
                            <path d="M7.03125 11.7188V18.75H7.5H7.96875V11.7188V4.6875H7.5H7.03125V11.7188Z" />
                            <path
                                d="M9.65041 5.61328C8.66603 6.60938 8.66603 6.51562 9.66798 7.52344L10.4297 8.29102L10.7637 7.95703L11.1035 7.61719L10.5762 7.08984L10.0488 6.5625L10.5645 6.04688C10.8457 5.76562 11.0742 5.50781 11.0742 5.47266C11.0742 5.39648 10.5293 4.86328 10.4531 4.86328C10.4238 4.86328 10.0606 5.20312 9.65041 5.61328Z" />
                            <path
                                d="M14.5137 5.14453C14.3613 5.29688 14.2383 5.44922 14.2383 5.47852C14.2383 5.50781 14.4668 5.76562 14.748 6.04688L15.2637 6.5625L14.7363 7.08984L14.209 7.61719L14.5488 7.95703L14.8828 8.29102L15.6445 7.52344C16.6465 6.51562 16.6465 6.60938 15.6621 5.61328C15.252 5.20312 14.8887 4.86328 14.8535 4.86328C14.8184 4.86328 14.666 4.99219 14.5137 5.14453Z" />
                            <path d="M2.8125 5.625V6.09375H3.98437H5.15625V5.625V5.15625H3.98437H2.8125V5.625Z" />
                            <path
                                d="M12.2285 6.58008C11.9766 7.20117 11.7773 7.73437 11.7773 7.76367C11.7773 7.79883 11.9648 7.89258 12.1934 7.98047L12.6094 8.13281L12.6855 7.95117C13.1602 6.80273 13.5234 5.82422 13.4883 5.78906C13.4648 5.76562 13.2715 5.68359 13.0606 5.60156L12.6738 5.45508L12.2285 6.58008Z" />
                            <path d="M17.3438 6.5625V7.03125H22.2656H27.1875V6.5625V6.09375H22.2656H17.3438V6.5625Z" />
                            <path d="M2.8125 7.96875V8.4375H3.98437H5.15625V7.96875V7.5H3.98437H2.8125V7.96875Z" />
                            <path d="M16.875 8.4375V8.90625H20.8594H24.8438V8.4375V7.96875H20.8594H16.875V8.4375Z" />
                            <path d="M2.8125 10.3125V10.7812H3.98437H5.15625V10.3125V9.84375H3.98437H2.8125V10.3125Z" />
                            <path
                                d="M8.90625 10.3125V10.7812H14.7656H20.625V10.3125V9.84375H14.7656H8.90625V10.3125Z" />
                            <path
                                d="M9.84375 12.1875V12.6562H17.8125H25.7813V12.1875V11.7188H17.8125H9.84375V12.1875Z" />
                            <path d="M3.75 12.6562V13.125H4.92188H6.09375V12.6562V12.1875H4.92188H3.75V12.6562Z" />
                            <path
                                d="M8.90625 14.0625V14.5312H12.1875H15.4688V14.0625V13.5938H12.1875H8.90625V14.0625Z" />
                            <path d="M3.75 15V15.4688H4.92188H6.09375V15V14.5312H4.92188H3.75V15Z" />
                            <path
                                d="M17.6192 15.9258C16.6348 16.9219 16.6348 16.8281 17.6367 17.8359L18.3985 18.6035L18.7324 18.2695L19.0723 17.9297L18.5449 17.4023L18.0176 16.875L18.5332 16.3594C18.8145 16.0781 19.043 15.8203 19.043 15.7852C19.043 15.709 18.4981 15.1758 18.4219 15.1758C18.3926 15.1758 18.0293 15.5156 17.6192 15.9258Z" />
                            <path
                                d="M22.4824 15.457C22.3301 15.6094 22.207 15.7617 22.207 15.791C22.207 15.8203 22.4355 16.0781 22.7168 16.3594L23.2324 16.875L22.7051 17.4023L22.1777 17.9297L22.5176 18.2695L22.8516 18.6035L23.6133 17.8359C24.6152 16.8281 24.6152 16.9219 23.6309 15.9258C23.2207 15.5156 22.8574 15.1758 22.8223 15.1758C22.7871 15.1758 22.6348 15.3047 22.4824 15.457Z" />
                            <path
                                d="M10.7812 15.9375V16.4062H13.3594H15.9375V15.9375V15.4688H13.3594H10.7812V15.9375Z" />
                            <path
                                d="M20.1973 16.8926C19.9453 17.5137 19.7461 18.0469 19.7461 18.0762C19.7461 18.1524 20.5254 18.457 20.5781 18.4043C20.6074 18.375 20.9355 17.5781 21.4863 16.1895C21.5039 16.1484 21.4512 16.0899 21.3809 16.0606C21.3047 16.0313 21.1055 15.9551 20.9414 15.8906L20.6426 15.7734L20.1973 16.8926Z" />
                            <path d="M3.75 17.3438V17.8125H4.92188H6.09375V17.3438V16.875H4.92188H3.75V17.3438Z" />
                            <path d="M9.84375 17.8125V18.2812H12.4219H15V17.8125V17.3438H12.4219H9.84375V17.8125Z" />
                        </svg>
                        <h6>{{ translate('Backend Setting') }}</h6>
                    </a>
                </li>
                <li class="{{ Route::is('dashboard.frontend.setting') ? 'active' : '' }}">
                    <a href="{{ route('dashboard.frontend.setting') }}">
                        <svg width="30" height="30" viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg">
                            <g clip-path="url(#clip0_692_2419)">
                                <path
                                    d="M0.433569 0.626943C0.363257 0.638662 0.246069 0.714834 0.169897 0.796865L0.0292725 0.949209L0.0116943 4.11913C-2.44118e-05 6.43358 0.0175537 7.33593 0.0644287 7.45897C0.216772 7.8164 -0.896508 7.79296 15 7.79296C30.8965 7.79296 29.7832 7.8164 29.9355 7.45897C29.9824 7.33593 30 6.43358 29.9883 4.11913L29.9707 0.93749L29.8066 0.779287L29.6484 0.615224L15.0996 0.609365C7.10154 0.603506 0.498022 0.615224 0.433569 0.626943ZM28.8281 4.18944V6.62108H15H1.17185V4.18944V1.7578H15H28.8281V4.18944Z" />
                                <path
                                    d="M24.7441 2.21484C23.9414 2.50195 23.4551 3.23438 23.5078 4.08984C23.5781 5.28516 24.7324 6.08789 25.9101 5.74805L26.1914 5.67188L26.5195 5.9707C26.7949 6.22852 26.8769 6.26953 27.082 6.26953C27.5391 6.26953 27.8144 5.76563 27.5625 5.39063C27.5039 5.30859 27.3691 5.14453 27.2578 5.02734C27.0586 4.81641 27.0527 4.80469 27.1172 4.55859C27.2637 3.99023 27.2285 3.52734 27.0117 3.10547C26.6133 2.33789 25.5703 1.92188 24.7441 2.21484ZM25.7285 3.41602C26.0918 3.66211 26.1445 4.14258 25.834 4.44727C25.2715 5.00977 24.3633 4.3125 24.7676 3.62695C24.8789 3.43945 25.1484 3.28711 25.3769 3.28125C25.459 3.28125 25.6172 3.33984 25.7285 3.41602Z" />
                                <path
                                    d="M5.63083 4.86913C5.33786 5.15624 5.40818 5.59569 5.77146 5.77148C5.94138 5.84765 6.68552 5.85937 12.0937 5.85937C18.6914 5.85937 18.5332 5.86523 18.6914 5.5664C18.8262 5.3203 18.7793 5.02733 18.5801 4.85155L18.3984 4.68749H12.1054H5.81247L5.63083 4.86913Z" />
                                <path
                                    d="M20.0332 4.85743C19.5937 5.30274 20.0566 6.03516 20.6308 5.80079C20.8711 5.70118 20.9765 5.5254 20.9765 5.23829C20.9765 4.74024 20.3906 4.50587 20.0332 4.85743Z" />
                                <path
                                    d="M0.46875 8.68945C0.328125 8.73633 0.228516 8.82422 0.164062 8.96484C0.0644531 9.1582 0.0585938 9.56836 0.0585938 15C0.0585938 20.4316 0.0644531 20.8418 0.164062 21.0352C0.228516 21.1758 0.328125 21.2637 0.46875 21.3105C0.767578 21.4102 18.334 21.4102 18.6328 21.3105C18.7734 21.2637 18.873 21.1758 18.9375 21.0352C19.0371 20.8418 19.043 20.4316 19.043 15C19.043 9.56836 19.0371 9.1582 18.9375 8.96484C18.873 8.82422 18.7734 8.73633 18.6328 8.68945C18.334 8.58984 0.767578 8.58984 0.46875 8.68945ZM17.8711 14.543C17.8711 17.5254 17.8477 19.2773 17.8184 19.248C17.7832 19.2129 16.7402 17.8301 15.498 16.1719C14.2559 14.5137 13.1777 13.125 13.1074 13.084C12.9492 12.9961 12.6855 12.9902 12.5449 13.0664C12.4863 13.0957 11.5898 14.2559 10.5527 15.6387L8.66016 18.1582L8.21484 17.6426C7.96289 17.3613 7.35352 16.6465 6.85547 16.0664C5.91211 14.9648 5.69531 14.7891 5.39062 14.8535C5.19141 14.9004 4.98633 15.1172 2.87109 17.5781C2.05664 18.5273 1.35352 19.3477 1.30664 19.3945C1.24219 19.4648 1.23047 18.6914 1.23047 14.6309V9.78516H9.55078H17.8711V14.543ZM13.3184 15.2051L13.7695 15.8203H12.8262H11.8828L12.0234 15.627C12.1055 15.5273 12.3105 15.2461 12.4863 15.0117C12.6562 14.7832 12.8145 14.5898 12.832 14.5898C12.8496 14.5957 13.0664 14.8711 13.3184 15.2051ZM6.72656 17.7188C7.37695 18.4746 7.91016 19.1074 7.91016 19.125C7.91016 19.1484 7.73438 19.4004 7.51758 19.6875L7.11914 20.2148H4.66992C2.78906 20.2148 2.2207 20.1973 2.23828 20.1445C2.26758 20.0566 5.4668 16.3477 5.51367 16.3477C5.53125 16.3477 6.08203 16.9629 6.72656 17.7188ZM15.791 18.5156C16.4238 19.3594 16.9512 20.0801 16.9746 20.127C16.998 20.2031 16.4531 20.2148 12.8027 20.2148C9.46289 20.2148 8.61328 20.1973 8.64844 20.1387C8.67188 20.1035 8.91797 19.7695 9.1875 19.4063L9.67969 18.75H11.127C12.3809 18.75 12.5977 18.7383 12.7734 18.6445C13.0547 18.5098 13.1602 18.2754 13.0723 17.9883C12.9609 17.6074 12.8613 17.5781 11.6602 17.5781C11.0801 17.5781 10.6055 17.5664 10.6055 17.5488C10.6055 17.5313 10.6934 17.3965 10.7988 17.2559L10.9863 16.998L12.8145 16.9922H14.6484L15.791 18.5156Z" />
                                <path
                                    d="M7.40034 10.5996C6.86128 10.7871 6.46284 11.1563 6.19917 11.707C5.77143 12.5977 6.09956 13.7285 6.93159 14.2617C7.34174 14.5254 7.59956 14.5957 8.07417 14.5957C9.62104 14.5898 10.5937 12.9785 9.89057 11.584C9.72065 11.25 9.29292 10.8516 8.91792 10.6758C8.47846 10.4766 7.83979 10.4414 7.40034 10.5996ZM8.5019 11.7891C8.94135 12.0352 9.0937 12.6738 8.80073 13.0605C8.41987 13.5762 7.57026 13.5352 7.28315 12.9902C6.86714 12.1934 7.7226 11.3496 8.5019 11.7891Z" />
                                <path
                                    d="M20.2148 8.68945C20.0742 8.73633 19.9746 8.82422 19.9102 8.96484C19.8105 9.1582 19.8047 9.56836 19.8047 14.9766C19.8047 18.9668 19.8223 20.8418 19.8691 20.9648C19.9043 21.0645 20.0039 21.1934 20.0859 21.252C20.2383 21.3516 20.4961 21.3574 24.9023 21.3574C29.2969 21.3574 29.5723 21.3516 29.7246 21.252C29.8184 21.1934 29.9121 21.082 29.9414 21C30.0352 20.7598 30.0176 9.14648 29.9238 8.96484C29.8828 8.88281 29.7598 8.77148 29.6484 8.71875C29.4609 8.61914 29.1152 8.61328 24.9316 8.61914C21.5977 8.61914 20.3672 8.63672 20.2148 8.68945ZM28.8281 15V20.2148L24.9199 20.2031L21.0059 20.1855L20.9883 15.0586C20.9824 12.2402 20.9883 9.89648 21.0059 9.85547C21.0234 9.80273 21.8672 9.78516 24.9316 9.78516H28.8281V15Z" />
                                <path
                                    d="M21.9668 10.9512C21.6679 11.25 21.7734 11.7539 22.1601 11.8887C22.2773 11.9297 23.2324 11.9531 24.914 11.9531C27.7734 11.9531 27.8261 11.9473 27.9726 11.5898C28.084 11.332 28.0312 11.1035 27.8203 10.9277L27.6445 10.7812H24.8906H22.1367L21.9668 10.9512Z" />
                                <path
                                    d="M22.0781 13.2129C21.8789 13.3242 21.7969 13.4707 21.7969 13.7227C21.7969 13.9629 21.9141 14.1387 22.1309 14.2324C22.2539 14.2793 23.0391 14.2969 25.0078 14.2852L27.7148 14.2676L27.8672 14.1094C28.084 13.8926 28.084 13.5293 27.8672 13.3125L27.7148 13.1543L24.9727 13.1426C22.6406 13.1309 22.2129 13.1426 22.0781 13.2129Z" />
                                <path
                                    d="M22.1484 15.5332C21.791 15.6738 21.6796 16.1484 21.9374 16.4473L22.0781 16.6113L24.8671 16.6289L27.6503 16.6465L27.832 16.4824C27.9726 16.3535 28.0195 16.2598 28.0253 16.1016C28.0312 15.8555 27.8847 15.6035 27.6796 15.5273C27.4804 15.4512 22.3417 15.457 22.1484 15.5332Z" />
                                <path
                                    d="M22.0781 17.9063C21.5801 18.1758 21.7793 18.9844 22.3418 18.9844C22.5937 18.9844 22.8808 18.7617 22.9277 18.5332C22.9746 18.2754 22.8281 17.9941 22.5937 17.9004C22.3418 17.7949 22.2773 17.7949 22.0781 17.9063Z" />
                                <path
                                    d="M24.3749 17.877C23.9941 18.0293 23.9003 18.5215 24.1933 18.8145L24.3632 18.9844H26.0039H27.6445L27.8203 18.8379C28.0312 18.6621 28.0839 18.4336 27.9726 18.1758C27.8378 17.8418 27.6738 17.8125 26.0039 17.8184C25.1835 17.8184 24.457 17.8477 24.3749 17.877Z" />
                                <path
                                    d="M0.369141 22.2773C0.0644531 22.4238 0.0585938 22.4824 0.0585938 25.7754C0.0585938 29.1914 0.0585938 29.168 0.433594 29.3262C0.609375 29.4023 1.32422 29.4141 5.16797 29.4141C9.36328 29.4141 9.71484 29.4082 9.90234 29.3086C10.0137 29.2559 10.1367 29.1445 10.1777 29.0625C10.2715 28.8809 10.2891 22.8281 10.2012 22.5996C10.166 22.5176 10.084 22.3945 10.0137 22.3301C9.87891 22.207 9.87305 22.207 5.19141 22.2129C2.00977 22.2129 0.457031 22.2363 0.369141 22.2773ZM9.08203 25.8105V28.2422H5.15625H1.23047V25.8105V23.3789H5.15625H9.08203V25.8105Z" />
                                <path
                                    d="M11.3027 22.377L11.1328 22.5469V25.7988V29.0449L11.2852 29.1973C11.3672 29.2852 11.5195 29.3672 11.625 29.3848C11.7246 29.4023 15.8203 29.4082 20.7246 29.4023L29.6484 29.3848L29.8066 29.2207L29.9707 29.0625L29.9883 25.9102C29.9941 24.1816 29.9883 22.6992 29.9707 22.6289C29.9531 22.5527 29.8652 22.4238 29.7832 22.3477L29.6309 22.207H20.5547H11.4727L11.3027 22.377ZM28.8281 25.8105V28.2422H20.5664H12.3047V25.8105V23.3789H20.5664H28.8281V25.8105Z" />
                                <path
                                    d="M14.08 25.3066C13.5937 25.6055 13.8163 26.3672 14.3906 26.3672C14.6835 26.3672 14.9413 26.1035 14.9413 25.8106C14.9413 25.5352 14.8652 25.3945 14.6484 25.2832C14.4257 25.166 14.3085 25.1719 14.08 25.3066Z" />
                                <path
                                    d="M16.3652 25.2832C15.9902 25.4414 15.9199 25.9277 16.2246 26.2031L16.4063 26.3672H21.5391H26.6719L26.8418 26.1973C27.1465 25.8867 27.0352 25.4062 26.6191 25.248C26.5371 25.2188 24.4688 25.1953 21.5156 25.1953C17.4316 25.2012 16.5176 25.2129 16.3652 25.2832Z" />
                            </g>
                            <defs>
                                <clipPath id="clip0_692_2419">
                                    <rect width="30" height="30" fill="white" />
                                </clipPath>
                            </defs>
                        </svg>
                        <h6>{{ translate('Frontend Setting') }}</h6>
                    </a>
                </li>
                @endadmin
            </ul>
        </div>
        <div class="sidebar-footer">
            <ul class="d-flex align-items-center justify-content-center flex-wrap gap-5 m-0 p-0">
                <li><a href="{{ route('logout') }}"
                        onclick="event.preventDefault(); document.getElementById('logout-form').submit();"><img
                            src="{{ asset('backend/images/icons/power.svg') }}" alt="power-icon"></a></li>
            </ul>
        </div>
    </div>
</div>
