@extends('backend.layouts.master')
@section('content')
    <div class="row mb-35">
        <div class="page-title d-flex justify-content-between align-items-center">
            <h4>{{ $page_title ?? '' }}</h4>
            <a href="{{ route('dashboard.index') }}" class="eg-btn btn--primary back-btn"> <img
                    src="{{ asset('backend/images/icons/back.svg') }}" alt="{{ translate('Go Back') }}">
                {{ translate('Go Back') }}</a>
        </div>
    </div>
    <form action="{{ route('dashboard.profile.update', $user->id) }}" method="post" enctype="multipart/form-data">
        <input name="_method" type="hidden" value="PATCH">
        @csrf
        <div class="row">
            <div class="col-lg-12">
                <div class="eg-card product-card">
                    <div class="main-tab-content">
                        <div class="d-flex align-items-start">
                            <div class="nav flex-column nav-pills me-3 border-end pe-3" id="v-pills-tab" role="tablist"
                                aria-orientation="vertical">
                                <button class="nav-link active" id="v-pills-general-tab" data-bs-toggle="pill"
                                    data-bs-target="#v-pills-general" type="button" role="tab"
                                    aria-controls="v-pills-general" aria-selected="true">{{ translate('General') }}</button>
                                <button class="nav-link" id="v-pills-address-tab" data-bs-toggle="pill"
                                    data-bs-target="#v-pills-address" type="button" role="tab"
                                    aria-controls="v-pills-address"
                                    aria-selected="false">{{ translate('Address') }}</button>
                                <button class="nav-link" id="v-pills-password-tab" data-bs-toggle="pill"
                                    data-bs-target="#v-pills-password" type="button" role="tab"
                                    aria-controls="v-pills-password" aria-selected="false">{{ translate('Password') }}</button>
                            </div>
                            <div class="tab-content w-100" id="v-pills-tabContent">
                                <div class="tab-pane fade show active" id="v-pills-general" role="tabpanel"
                                    aria-labelledby="v-pills-general-tab" tabindex="0">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-inner mb-35">
                                                <label>{{ translate('First Name') }} <span
                                                        class="text-danger">*</span></label>
                                                <input type="text" class="username-input"
                                                    value="{{ old('fname', $user->fname) }}" name="fname"
                                                    placeholder="{{ translate('Enter First Name') }}">
                                                @error('fname')
                                                    <div class="error text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-inner mb-35">
                                                <label>{{ translate('Last Name') }} <span
                                                        class="text-danger">*</span></label>
                                                <input type="text" class="username-input"
                                                    value="{{ old('lname', $user->lname) }}" name="lname"
                                                    placeholder="{{ translate('Enter Last Name') }}">
                                                @error('lname')
                                                    <div class="error text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-inner mb-35">
                                                <label>{{ translate('Email') }} <span class="text-danger">*</span></label>
                                                <input type="email" name="email" class="username-input"
                                                    value="{{ old('email', $user->email) }}"
                                                    placeholder="{{ translate('Enter Email') }}">
                                                @error('email')
                                                    <div class="error text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-inner mb-35">
                                                <label>{{ translate('Phone') }} <span class="text-danger">*</span></label>
                                                <input type="text" class="username-input"
                                                    value="{{ old('phone', $user->phone) }}" name="phone"
                                                    placeholder="{{ translate('Enter Phone') }}">
                                                @error('phone')
                                                    <div class="error text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-inner file-upload mb-35">
                                                <label class="control-label">{{ translate('Image') }}</label>
                                                <div class="dropzone-wrapper">
                                                    <div class="dropzone-desc">
                                                        <i class="glyphicon glyphicon-download-alt"></i>
                                                        <p>{{ translate('Choose an image file or drag it here') }}</p>
                                                    </div>
                                                    <input type="file" name="image" class="dropzone featues_image">
                                                </div>
                                                @error('image')
                                                    <div class="error text-danger">{{ $message }}</div>
                                                @enderror

                                                <div class="preview-zone hidden mt-3 text-center">
                                                    <div class="box box-solid">
                                                        <div class="box-header with-border">
                                                            <div class="box-tools pull-right">
                                                                <button type="button"
                                                                    class="btn btn-danger btn-xs remove-preview"
                                                                    style="display:none;">
                                                                    <i class="fa fa-times"></i>
                                                                </button>
                                                            </div>
                                                        </div>
                                                        <div class="box-body">
                                                            @if ($user->image)
                                                                <img src="{{ uploaded_asset($user->image) }}"
                                                                    alt="{{ $user->name }}" width="100">
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="v-pills-address" role="tabpanel"
                                    aria-labelledby="v-pills-address-tab" tabindex="0">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-inner mb-35">
                                                <label>{{ translate('Address') }}</label>
                                                <input type="text" class="username-input" name="address"
                                                    value="{{ old('address', $user->address) }}"
                                                    placeholder="{{ translate('Enter Address') }}">
                                                @error('address')
                                                    <div class="error text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-inner mb-35">
                                                <label>{{ translate('Country') }}</label>
                                                <select name="country_id" class="country_id select2">
                                                    <option value="">{{ translate('Select Option') }}</option>
                                                    @foreach ($countries as $country)
                                                        <option value="{{ $country->id }}"
                                                            {{ $country->id == $user->country_id ? 'selected' : '' }}>
                                                            {{ $country->getTranslation('name') }}</option>
                                                    @endforeach
                                                </select>
                                                @error('country_id')
                                                    <div class="error text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-inner mb-35">
                                                <label>{{ translate('State') }}</label>
                                                <select name="state_id" class="state_id select2">
                                                    <option value="">{{ translate('Select Option') }}</option>
                                                    <option value="{{ $user->state_id }}" selected>
                                                        {{ $user->states?->getTranslation('name') }}</option>
                                                </select>
                                                @error('state_id')
                                                    <div class="error text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-inner mb-35">
                                                <label>{{ translate('City') }}</label>
                                                <select name="city_id" class="city_id select2">
                                                    <option value="">{{ translate('Select Option') }}</option>
                                                    <option value="{{ $user->city_id }}" selected>
                                                        {{ $user->cities?->getTranslation('name') }}</option>
                                                </select>
                                                @error('city_id')
                                                    <div class="error text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-inner mb-35">
                                                <label>{{ translate('Zip Code') }}</label>
                                                <input type="text" class="username-input" name="zip_code"
                                                    value="{{ old('zip_code', $user->zip_code) }}"
                                                    placeholder="{{ translate('Enter Zip Code') }}">
                                                @error('zip_code')
                                                    <div class="error text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="v-pills-password" role="tabpanel"
                                    aria-labelledby="v-pills-password-tab" tabindex="0">
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-inner mb-30">
                                                <label>{{ translate('Password') }} <span
                                                        class="text-danger">*</span></label>
                                                <input id="password" type="password" name="password"
                                                    placeholder="*****" autocomplete="new-password">
                                                <i class="bi bi-eye-slash" id="togglePassword"></i>
                                                @error('password')
                                                    <div class="error text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-inner mb-30">
                                                <label>{{ translate('Confirm Password') }} <span
                                                        class="text-danger">*</span></label>
                                                <input id="password2" type="password" name="password_confirmation"
                                                    placeholder="*****" autocomplete="new-password">
                                                <i class="bi bi-eye-slash" id="togglePassword2"></i>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="button-group mt-15 text-center  ">
                        <input type="submit" class="eg-btn btn--green back-btn me-3" value="{{ translate('Update') }}">
                    </div>
                </div>
            </div>

        </div>
    </form>
@endsection
@push('js')
    @include('js.admin.artist')
@endpush
