@extends('backend.layouts.master')
@section('content')
<div class="page-title2">
    <img src="{{ asset('uploads/favicon.svg') }}" class="title-logo" alt="logo">
    <h5>{{ translate('Backend Settings') }}</h5>
</div>
<form action="{{ route('dashboard.backend.settings.store') }}" method="post" enctype="multipart/form-data">
    @csrf
    <div class="tab-area settings-area">
        <div class="nav flex-row jusify-content-start nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">
            <button class="nav-link active" id="v-pills-general-tab" data-bs-toggle="pill" data-bs-target="#v-pills-general" type="button" role="tab" aria-controls="v-pills-general" aria-selected="true">{{ translate('General') }}</button>
            <button class="nav-link" id="v-pills-setting-tab" data-bs-toggle="pill" data-bs-target="#v-pills-setting" type="button" role="tab" aria-controls="v-pills-setting" aria-selected="true">{{ translate('Email
                Configuration') }}</button>
            <button class="nav-link" id="v-pills-recaptcha-tab" data-bs-toggle="pill" data-bs-target="#v-pills-recaptcha" type="button" role="tab" aria-controls="v-pills-recaptcha" aria-selected="true">{{ translate('Google reCAPTCHA') }}</button>

            <button class="nav-link" id="v-pills-tawk-tab" data-bs-toggle="pill" data-bs-target="#v-pills-tawk" type="button" role="tab" aria-controls="v-pills-tawk" aria-selected="true">{{ translate('Tawk Chat')
                }}</button>
            <button class="nav-link" id="v-pills-system-info-tab" data-bs-toggle="pill" data-bs-target="#v-pills-system-info" type="button" role="tab" aria-controls="v-pills-system-info" aria-selected="true">{{ translate('System Information') }}</button>
        </div>
        <div class="tab-content" id="v-pills-tabContent">
            <div class="tab-pane fade show active p-0" id="v-pills-general" role="tabpanel" aria-labelledby="v-pills-general-tab">
                <div class="eg-card product-card">
                    <div class="row">
                        <div class="col-xl-6">
                            <div class="form-inner mb-35">
                                <label>{{ translate('Application Name') }}</label>
                                <input type="text" class="form-control" value="{{ old('company_name', get_setting('company_name')) }}" name="company_name" placeholder="{{ translate('Application Name') }}">
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="form-inner mb-35">
                                <label>{{ translate('Company Email') }}</label>
                                <input type="email" class="form-control" value="{{ old('company_email', get_setting('company_email')) }}" name="company_email" placeholder="{{ translate('Company Email') }}">
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="form-inner mb-35">
                                <label>{{ translate('Company Phone') }}</label>
                                <input type="tel" class="form-control" value="{{ old('company_phone', get_setting('company_phone')) }}" name="company_phone" placeholder="{{ translate('Company Phone') }}">
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="form-inner mb-35">
                                <label>{{ translate('Currency') }}</label>
                                <select class="select2" name="default_currency">
                                    <option value="">{{ translate('Select Option') }}</option>
                                    @foreach ($currencies as $currency)
                                    <option value="{{ $currency->id }}" {{ old('default_currency',
                                        get_setting('default_currency'))==$currency->id ? 'selected' : '' }}>
                                        {{ $currency->name . ' - ' . $currency->symbol }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-xl-12">
                            <div class="form-inner mb-35">
                                <label>{{ translate('Company Address') }}</label>
                                <input type="text" class="form-control" value="{{ old('company_address', get_setting('company_address')) }}" name="company_address" placeholder="{{ translate('Company Address') }}">
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="form-inner mb-35">
                                <label>{{ translate('VAT/Tax Rate for Customer') }}</label>
                                <input type="text" name="tax_rate" value="{{ old('tax_rate', get_setting('tax_rate')) }}" placeholder="{{ translate('TAX Rate') }}" aria-label="TAX Rate" aria-describedby="tax_rate">
                                <span class="form-inner-text" id="tax_rate">%</span>
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="form-inner mb-35 position-relative">
                                <label>{{ translate('System Timezone') }}</label>
                                <select class="select2" name="APP_TIMEZONE" id="time_zone">
                                    @php
                                    $now = new DateTime();
                                    @endphp
                                    @foreach(timezone_identifiers_list() as $tz)
                                    @php

                                    $now->setTimezone(new DateTimeZone($tz));
                                    $offset = $now->format('P');
                                    @endphp
                                    <option value="{{ $tz }}" @selected(get_setting('APP_TIMEZONE')==$tz)>(GMT{{ $offset }}) {{ $tz }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="form-inner mb-35 position-relative">
                                <label>{{ translate('Date Format') }}</label>
                                <select class="form-control custom-select" name="date_format" id="date_format" required="required">
                                    <option value="M j, Y" {{ old('date_format', get_setting('date_format'))=='M j, Y'
                                        ? 'selected' : '' }}>
                                        Oct 30, 2023</option>
                                    <option value="Y-m-d" {{ old('date_format', get_setting('date_format'))=='Y-m-d'
                                        ? 'selected' : '' }}>
                                        2023-10-30</option>
                                    <option value="d-m-Y" {{ old('date_format', get_setting('date_format'))=='d-m-Y'
                                        ? 'selected' : '' }}>
                                        30-10-2023</option>
                                    <option value="d/m/Y" {{ old('date_format', get_setting('date_format'))=='d/m/Y'
                                        ? 'selected' : '' }}>
                                        30/10/2023 </option>
                                    <option value="m/d/Y" {{ old('date_format', get_setting('date_format'))=='m/d/Y'
                                        ? 'selected' : '' }}>
                                        10/30/2023 </option>
                                    <option value="m.d.Y" {{ old('date_format', get_setting('date_format'))=='m.d.Y'
                                        ? 'selected' : '' }}>
                                        10.30.2023 </option>
                                    <option value="j, n, Y" {{ old('date_format', get_setting('date_format'))=='j, n, Y'
                                        ? 'selected' : '' }}>
                                        30, 10, 2023 </option>
                                    <option value="F j, Y" {{ old('date_format', get_setting('date_format'))=='F j, Y'
                                        ? 'selected' : '' }}>
                                        October 30, 2023 </option>
                                    <option value="M j, Y" {{ old('date_format', get_setting('date_format'))=='M j, Y'
                                        ? 'selected' : '' }}>
                                        Oct 30, 2023</option>
                                    <option value="j M, Y" {{ old('date_format', get_setting('date_format'))=='j M, Y'
                                        ? 'selected' : '' }}>
                                        30 Oct, 2023</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="form-inner mb-35">
                                <label>{{ translate('Commission from Merchant') }}</label>
                                <input type="text" name="merchant_commission" value="{{ old('merchant_commission', get_setting('merchant_commission')) }}" placeholder="{{ translate('Commission from Merchant') }}" aria-label="Commission from Merchant" aria-describedby="merchant_commission">
                                <span class="form-inner-text" id="merchant_commission">%</span>
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="form-inner row mb-35">
                                <label class="col-md-8">{{ translate('Art Gallery Email Verification') }}</label>
                                <div class="text-end col-md-4">
                                    <label class="switch-btn">
                                        <input type="checkbox" name="artgallry_email_verification" value="1" {{
                                            get_setting('artgallry_email_verification') == 1 ? 'checked' : '' }}>
                                        <span class="switch-slider round"></span>
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="form-inner row mb-35">
                                <label class="col-md-8">{{ translate('Customer Email Verification') }}</label>
                                <div class="text-end col-md-4">
                                    <label class="switch-btn">
                                        <input type="checkbox" name="customer_email_verification" value="1" {{
                                            get_setting('customer_email_verification') == 1 ? 'checked' : '' }}>
                                        <span class="switch-slider round"></span>
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="form-inner mb-35">
                                <label>{{ translate('Admin Logo') }}</label>
                                <input type="file" name="admin_logo" class="form-control">
                                @if (get_setting('admin_logo'))
                                <img class="mt-2" src="{{ uploaded_asset(get_setting('admin_logo')) }}" alt="Admin Logo" width="100">
                                @endif
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="form-inner mb-35">
                                <label>{{ translate('Invoice Logo') }}</label>
                                <input type="file" name="invoice_logo" class="form-control">
                                @if (get_setting('invoice_logo'))
                                <img class="mt-2" src="{{ uploaded_asset(get_setting('invoice_logo')) }}" alt="Invoice Logo" width="100">
                                @endif
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="form-inner mb-35">
                                <label>{{ translate('Certificate Authorized Signature') }}</label>
                                <input type="file" name="authorized_sign" class="form-control">
                                @if (get_setting('authorized_sign'))
                                <img class="mt-2" src="{{ uploaded_asset(get_setting('authorized_sign')) }}" alt="Authorized Signature" width="100">
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade p-0" id="v-pills-setting" role="tabpanel" aria-labelledby="v-pills-setting-tab">
                <div class="eg-card product-card">
                    <div class="row">
                        <div class="col-xl-12">
                            <button type="button" class="eg-btn btn--primary back-btn float-end" data-bs-toggle="modal" data-bs-target="#testMail"><img src="{{ asset('backend/images/icons/add-icon.svg') }}" alt="Test Mail">
                                {{ translate('Test Mail') }}</button>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xl-6">
                            <div class="form-inner mb-35">
                                <label>{{ translate('Driver') }}</label>
                                <select class="select2" name="mail_driver">
                                    <option value="">{{ translate('Select Option') }}</option>
                                    <option value="smtp" {{ old('mail_driver', get_setting('mail_driver'))=='smtp'
                                        ? 'selected' : '' }}>
                                        {{ translate('smtp') }}</option>
                                    <option value="sendmail" {{ old('mail_driver',
                                        get_setting('mail_driver'))=='sendmail' ? 'selected' : '' }}>
                                        {{ translate('sendmail') }}</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="form-inner mb-35">
                                <label>{{ translate('Host') }}</label>
                                <input type="text" class="form-control" value="{{ old('mail_host', get_setting('mail_host')) }}" name="mail_host" placeholder="{{ translate('Host') }}">
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="form-inner mb-35">
                                <label>{{ translate('Port') }}</label>
                                <input type="text" class="form-control" value="{{ old('mail_port', get_setting('mail_port')) }}" name="mail_port" placeholder="{{ translate('Port') }}">
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="form-inner mb-35">
                                <label>{{ translate('From Address') }}</label>
                                <input type="text" class="form-control" value="{{ old('mail_from_address', get_setting('mail_from_address')) }}" name="mail_from_address" placeholder="{{ translate('From Address') }}">
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="form-inner mb-35">
                                <label>{{ translate('From Name') }}</label>
                                <input type="text" class="form-control" value="{{ old('mail_from_name', get_setting('mail_from_name')) }}" name="mail_from_name" placeholder="{{ translate('From Name') }}">
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="form-inner mb-35">
                                <label>{{ translate('Encryption') }}</label>
                                <input type="text" class="form-control" value="{{ old('mail_encryption', get_setting('mail_encryption')) }}" name="mail_encryption" placeholder="{{ translate('Encryption') }}">
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="form-inner mb-35">
                                <label>{{ translate('Username') }}</label>
                                <input type="text" autocomplete="off" class="form-control" value="{{ old('mail_username', get_setting('mail_username')) }}" name="mail_username" placeholder="{{ translate('Username') }}">
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="form-inner mb-35">
                                <label>{{ translate('Password') }}</label>
                                <input type="text" autocomplete="off" class="form-control" value="{{ old('mail_password', get_setting('mail_password')) }}" name="mail_password" placeholder="{{ translate('Password') }}">
                            </div>
                        </div>

                    </div>
                </div>
            </div>
            <div class="tab-pane fade p-0" id="v-pills-recaptcha" role="tabpanel" aria-labelledby="v-pills-recaptcha-tab">
                <div class="eg-card product-card">
                    <div class="row">
                        <div class="col-xl-4 mb-35">
                            <div class="row">
                                <label class="col-sm-2"><b>{{ translate('Enabled/Disabled') }}</b></label>
                                <div class="form-check form-switch col-sm-10">
                                    <input class="form-check-input" value="1" name="google_recapcha_check" {{
                                        get_setting('google_recapcha_check')==1 ? 'checked' : '' }} type="checkbox">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xl-6">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Recaptcha Key') }}</label>
                                    <input type="text" class="form-control" value="{{ old('recaptcha_key', get_setting('recaptcha_key')) }}" name="recaptcha_key" placeholder="{{ translate('Recaptcha Key') }}">
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Recaptcha Secret') }}</label>
                                    <input type="text" class="form-control" value="{{ old('recaptcha_secret', get_setting('recaptcha_secret')) }}" name="recaptcha_secret" placeholder="{{ translate('Recaptcha Secret') }}">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade p-0" id="v-pills-tawk" role="tabpanel" aria-labelledby="v-pills-tawk-tab">
                <div class="eg-card product-card">
                    <div class="row">
                        <div class="col-xl-4 mb-35">
                            <div class="row">
                                <label class="col-sm-2"><b>{{ translate('Enabled/Disabled') }}</b></label>
                                <div class="form-check form-switch col-sm-10">
                                    <input class="form-check-input" value="1" name="tawk_enabled" {{
                                        get_setting('tawk_enabled')==1 ? 'checked' : '' }} type="checkbox" id="flexSwitchCheckProduct18">
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-12">
                            <label class="col-sm-2 mb-2"><b>{{ translate('Tawk Embed Url') }}</b></label>
                            <div class="form-inner mb-35">
                                <input type="text" value="{{ get_setting('tawk_code') }}" name="tawk_code">
                            </div>
                            <p> <a href="https://www.tawk.to/" target="_blank"> <b>
                                        {{ translate('Go to Tawk') }}</b> </a></p>

                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade p-0" id="v-pills-system-info" role="tabpanel" aria-labelledby="v-pills-system-info-tab">
                <div class="eg-card product-card">
                    <div class="system-information">
                        <table class="eg-table">
                            <tbody>
                                <tr>
                                    <td><strong>{{ translate('PHP Version') }}</strong></td>
                                    <td> {{ phpversion() }}</td>
                                </tr>
                                <tr>
                                    <td><strong>{{ translate('Laravel Version') }}</strong></td>
                                    <td>{{ app()->version() }}</td>
                                </tr>
                                <tr>
                                    <td><strong>{{ translate('Server Software') }}</strong></td>
                                    <td>{{ translate('LiteSpeed') }}</td>
                                </tr>
                                <tr>
                                    <td><strong>{{ translate('Server IP Address') }}</strong></td>
                                    <td>{{ $_SERVER['REMOTE_ADDR'] }}</td>
                                </tr>
                                <tr>
                                    <td><strong>{{ translate('Server Protocol') }}</strong></td>
                                    <td>{{ $_SERVER['SERVER_PROTOCOL'] }}</td>
                                </tr>
                                <tr>
                                    <td><strong>{{ translate('HTTP Host') }}</strong></td>
                                    <td>{{ env('DB_HOST') }}</td>
                                </tr>
                                <tr>
                                    <td><strong>{{ translate('Database Port') }}</strong></td>
                                    <td>{{ env('DB_PORT') }}</td>
                                </tr>
                                <tr>
                                    <td><strong> {{ translate('App Environment') }} </strong></td>
                                    <td>{{ Config::get('app.env') }}</td>
                                </tr>
                                <tr>
                                    <td><strong>{{ translate('App Debug') }}</strong></td>
                                    <td>{{ Config::get('app.debug') == 1 ? 'true' : 'false' }}</td>
                                </tr>
                                <tr>
                                    <td><strong>{{ translate('Timezone') }}</strong></td>
                                    <td>{{ Config::get('app.timezone') }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12 text-center">
            <div class="button-group mt-15">
                <input type="submit" class="eg-btn btn--green medium-btn me-3" value="{{ 'Update' }}">
            </div>
        </div>
    </div>
</form>
<input type="hidden" value="{{ get_setting('time_zone') }}" id="timezoneValue">
@include('backend.backend_setting.modal')
@endsection