@extends('frontend.template-1.layouts.master')

@section('content')
@include('frontend.template-1.partials.breadcrumb')
    <div class="login-section mb-120">
        <div class="container">
            <div class="row d-flex justify-content-center g-4">
                <div class="col-xl-6 col-lg-8 col-md-10">
                    <div class="login-form-wrapper">
                        <div class="form-title">
                            <h3>{{translate('Verify Email')}}</h3>
                            <p>{{translate('Thanks for signing up! Before getting started, could you verify your email address by clicking on the link we just emailed to you? If you didn\'t receive the email, we will gladly send you another.')}}</p>
                            @if (session('status') == 'verification-link-sent')
                                <div class="mb-4 font-medium text-sm text-green-600">
                                    {{translate('A new verification link has been sent to the email address you provided during registration.')}}
                                </div>
                            @endif
                        </div>
                        <div class="mt-4 flex items-center justify-between">
                        <form class="w-100" method="POST" action="{{ route('verification.send') }}">
                            @csrf
                            <button class="primary-btn1 btn-hover mb-3" type="submit">
                                <span>{{translate('Resend Verification Email')}}</span>
                                <strong></strong>
                            </button>
                        </form>
                        <form class="w-100" method="POST" action="{{ route('logout') }}">
                            @csrf
                            <button class="primary-btn1 btn-hover" type="submit">
                                <span>{{translate('Log Out')}}</span>
                                <strong></strong>
                            </button>
                        </form>
                    </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection