@extends('frontend.template-1.layouts.master')

@section('content')
@include('frontend.template-1.partials.breadcrumb')
    <div class="login-section mb-120">
        <div class="container">
            <div class="row d-flex justify-content-center g-4">
                <div class="col-xl-6 col-lg-8 col-md-10">
                    <div class="login-form-wrapper">
                        <div class="form-title">
                            <h3>{{translate('Sign Up')}}</h3>
                            <p>{{translate('Do you already have an account?')}}  <a href="{{route('login')}}">{{translate('Log in here')}}</a></p>
                        </div>
                        <ul class="nav nav-tabs" id="myTab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab" aria-controls="home" aria-selected="true">{{translate('User')}}</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab" aria-controls="profile" aria-selected="false">{{translate('Art Gallery')}}</button>
                            </li>
                        </ul>
                        <div class="tab-content" id="myTabContent">
                            <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                                <form class="w-100" method="POST" action="{{ route('register') }}">
                                    @csrf
                                    <input type="hidden" name="role" value="1">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-inner">
                                                <label>{{translate('First Name')}} <span class="text-color">*</span></label>
                                                <input type="text" placeholder="{{translate('First Name')}}" value="{{ old('first_name') }}" name="first_name" id="first_name" required/>
                                                @error('first_name')
                                                    <div class="error text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-inner">
                                                <label>{{translate('Last Name')}}</label>
                                                <input type="text" placeholder="{{translate('Last Name')}}" value="{{ old('last_name') }}" name="last_name" id="last_name"/>
                                                @error('last_name')
                                                    <div class="error text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="form-inner">
                                                <label>{{translate('Enter Your Email')}} <span class="text-color">*</span></label>
                                                <input type="email" placeholder="{{translate('Enter Your Email')}}" value="{{ old('email') }}" name="email" required/>
                                                @error('email')
                                                    <div class="error text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="form-inner">
                                                <label>{{translate('Create Password')}} <span class="text-color">*</span></label>
                                                <input type="password" name="password" id="password" placeholder="{{translate('Create Password')}}" autocomplete="new-password" required/>
                                                <i class="bi bi-eye-slash" id="togglePassword"></i>
                                                @error('password')
                                                    <div class="error text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="form-inner">
                                                <label>{{translate('Confirm Password')}} <span class="text-color">*</span></label>
                                                <input type="password" name="password_confirmation" id="password2" placeholder="{{translate('Confirm Password')}}" autocomplete="new-password" required/>
                                                <i class="bi bi-eye-slash" id="togglePassword2"></i>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="form-agreement form-inner d-flex justify-content-between flex-wrap">
                                                <div class="form-inner2">
                                                    <label class="containerss">
                                                        <input type="checkbox" name="agreement" value="1">
                                                        <span class="checkmark"></span>
                                                        <span class="text">{{translate('I agree to the')}} <a href="{{get_setting('term_page')}}">{{translate('Terms & Policy')}}</a></span>
                                                    </label>
                                                    @error('agreement')
                                                    <div class="error text-danger">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                        </div>
                                        @if (get_setting('google_recapcha_check') == 1)
                                            <div class="g-recaptcha mb-3" data-sitekey="{{ get_setting('recaptcha_key') }}"></div>
                                            @if (Session::has('g-recaptcha-response'))
                                                <p class="text-danger"> {{ Session::get('g-recaptcha-response') }}</p>
                                            @endif
                                        @endif
                                    </div>
                                    <button class="primary-btn1 btn-hover" type="submit">
                                        <span>{{translate('Create Account')}}</span>
                                        <strong></strong>
                                    </button>
                                </form>
                            </div>
                            <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                                <form class="w-100" method="POST" action="{{ route('register') }}">
                                    @csrf
                                    <input type="hidden" name="role" value="2">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-inner">
                                                <label>{{translate('First Name')}} <span class="text-color">*</span></label>
                                                <input type="text" placeholder="{{translate('First Name')}}" value="{{ old('first_name') }}" name="first_name" id="first_name2" required/>
                                                 @error('first_name')
                                                    <div class="error text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-inner">
                                                <label>{{translate('Last Name')}}</label>
                                                <input type="text" placeholder="{{translate('Last Name')}}" value="{{ old('last_name') }}" name="last_name" id="last_name2"/>
                                                @error('last_name')
                                                    <div class="error text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="form-inner">
                                                <label>{{translate('Gallery Name')}}</label>
                                                <input type="text" placeholder="{{translate('Gallery Name')}}" value="{{ old('gallery_name') }}" name="gallery_name" id="gallery_name"/>
                                                @error('gallery_name')
                                                    <div class="error text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="form-inner">
                                                <label>{{translate('Enter Your Email')}} <span class="text-color">*</span></label>
                                                <input type="email" placeholder="{{translate('Enter Your Email')}}" value="{{ old('email') }}" name="email" required/>
                                                @error('email')
                                                    <div class="error text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="form-inner">
                                                <label>{{translate('Create Password')}} <span class="text-color">*</span></label>
                                                <input type="password" name="password" id="password3" placeholder="{{translate('Create Password')}}" autocomplete="new-password" required/>
                                                <i class="bi bi-eye-slash" id="togglePassword3"></i>
                                                @error('password')
                                                    <div class="error text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="form-inner">
                                                <label>{{translate('Confirm Password')}} <span class="text-color">*</span></label>
                                                <input type="password" name="password_confirmation" id="password4" placeholder="{{translate('Confirm Password')}}" autocomplete="new-password" required/>
                                                <i class="bi bi-eye-slash" id="togglePassword4"></i>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="form-agreement form-inner d-flex justify-content-between flex-wrap">
                                                <div class="form-inner2">
                                                    <label class="containerss">
                                                        <input type="checkbox" name="agreement" value="1">
                                                        <span class="checkmark"></span>
                                                        <span class="text">{{translate('I agree to the')}} <a href="{{get_setting('term_page')}}">{{translate('Terms & Policy')}}</a></span>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        @if (get_setting('google_recapcha_check') == 1)
                                            <div class="g-recaptcha mb-3" data-sitekey="{{ get_setting('recaptcha_key') }}"></div>
                                            @if (Session::has('g-recaptcha-response'))
                                                <p class="text-danger"> {{ Session::get('g-recaptcha-response') }}</p>
                                            @endif
                                        @endif
                                    </div>
                                    <button class="primary-btn1 btn-hover" type="submit">
                                        <span>{{translate('Create Account')}}</span>
                                        <strong></strong>
                                    </button>
                                </form>
                            </div>
                        </div>
                        <div class="form-poicy-area mt-3">
                            <p>{{translate('By clicking the "signup" button, you create a Cobiro account, and you agree to Cobiro\'s')}} <a href="{{get_setting('term_page')}}">{{translate('Terms & Conditions')}}</a> & <a href="{{get_setting('privacy_page')}}">{{translate('Privacy Policy.')}}</a></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
