@extends('frontend.template-1.layouts.master')

@section('content')
@include('frontend.template-1.partials.breadcrumb')
    <div class="login-section mb-120">
        <div class="container">
            <div class="row d-flex justify-content-center g-4">
                <div class="col-xl-6 col-lg-8 col-md-10">
                    <div class="login-form-wrapper">
                        <div class="form-title">
                            <h3>{{translate('Log In')}}</h3>
                            <p>{{translate('New Member?')}} <a href="{{route('register')}}">{{translate('signup here')}}</a></p>
                        </div>
                        <form class="w-100" method="POST" action="{{ route('login') }}">
                            @csrf
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-inner">
                                        <label>{{translate('Enter Your Email')}} <span class="text-color">*</span></label>
                                        <input type="email" placeholder="{{translate('Enter Your Email')}}" name="email" id="email" required/>
                                        @error('email')
                                            <div class="error text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-inner">
                                        <label>{{translate('Password')}} <span class="text-color">*</span></label>
                                        <input type="password" name="password" id="password" placeholder="{{translate('Password')}}" autocomplete="new-password" required/>
                                        <i class="bi bi-eye-slash" id="togglePassword"></i>
                                        @error('password')
                                            <div class="error text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-agreement form-inner d-flex justify-content-between flex-wrap">
                                        <div class="form-inner2">
                                            <label for="remember_me" class="containerss">
                                                <input type="checkbox" id="remember_me" name="remember">
                                                <span class="checkmark"></span>
                                                <span class="text">{{translate('Remember me')}}</span>
                                            </label>
                                        </div>
                                        @if (Route::has('password.request'))
                                        <a href="{{ route('password.request') }}" class="forgot-pass">{{translate('Forgotten Password')}}</a>
                                        @endif
                                    </div>
                                </div>
                                @if (get_setting('google_recapcha_check') == 1)
                                    <div class="g-recaptcha mb-3" data-sitekey="{{ get_setting('recaptcha_key') }}"></div>
                                    @if (Session::has('g-recaptcha-response'))
                                        <p class="text-danger"> {{ Session::get('g-recaptcha-response') }}</p>
                                    @endif
                                @endif
                            </div>
                            <button class="primary-btn1 btn-hover" type="submit">
                                <span>{{translate('Log In')}}</span>
                                <strong></strong>
                            </button>
                        </form>
                        <div class="form-poicy-area mt-3">
                            <p>{{translate('By clicking the "signup" button, you create a Cobiro account, and you agree to Cobiro\'s')}} <a href="{{get_setting('term_page')}}">{{translate('Terms & Conditions')}}</a> & <a href="{{get_setting('privacy_page')}}">{{translate('Privacy Policy.')}}</a></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection