@extends('frontend.template-1.layouts.master')

@section('content')
@include('frontend.template-1.partials.breadcrumb')
    <div class="login-section mb-120">
        <div class="container">
            <div class="row d-flex justify-content-center g-4">
                <div class="col-xl-6 col-lg-8 col-md-10">
                    <div class="login-form-wrapper">
                        <div class="form-title">
                            <h3>{{translate('Forgot Password')}}</h3>
                            <p>{{translate('Forgot your password? No problem. Just let us know your email address and we will email you a password reset link that will allow you to choose a new one.')}}</p>
                        </div>
                        <form class="w-100" method="POST" action="{{ route('password.email') }}">
                            @csrf
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-inner">
                                        <label>{{translate('Enter Your Email')}} <span class="text-danger">*</span></label>
                                        <input type="email" placeholder="{{translate('Enter Your Email')}}" name="email" id="email" required autofocus value="{{ old('email') }}"/>
                                        @error('email')
                                            <div class="error text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <button class="primary-btn1 btn-hover" type="submit">
                                <span>{{translate('Email Password Reset Link')}}</span>
                                <strong></strong>
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection