
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ $page_title ?? '' }}</title>
    <link rel="icon" type="image/png" href="{{uploaded_asset(get_setting('front_favicon'))}}">
    <link rel="stylesheet" href="{{asset('backend/css/bootstrap.min.css')}}">
    <link rel="stylesheet" href="{{asset('backend/css/style.css')}}">
</head>
<body>
    <div class="login-bg d-flex jusify-content-center align-items-center">
        <img src="{{asset('backend/images/bg/login-vector.png')}}" class="img-fluid login-vector">
        <div class="login-form-area">
            <div class="form-title">
                <h4>{{translate('Wellcome To')}} <span>{{get_setting('company_name') ?? 'EgensLab'}}</span></h4>
                <p>{{translate('Super Admin Dashbord')}}</p>
            </div>
            @error('status')
                <div class="error text-danger"><strong>{{ $message }}</strong></div>
            @enderror
            <form action="{{ route('admin.login.submit') }}" method="POST" class="login-form">
                @csrf
                <div class="form-inner mb-35">
                    <label>{{translate('Email')}} <span class="text-danger">*</span></label>
                    <input type="text" name="email" class="username-input" placeholder="{{translate('Enter Your Email')}}">
                    <img src="{{asset('backend/images/icons/user-icon.png')}}" class="input-icon" alt="input-icon">        
                </div>
                <div class="form-inner mb-25">
                    <div>
                    <label>{{translate('Password')}} <span class="text-danger">*</span></label>
                    <input type="password" name="password" class="password" placeholder="{{translate('Enter Your Password')}}">
                    <img src="{{asset('backend/images/icons/pass-icon.png')}}" class="input-icon" alt="input-icon">
                </div>
                <div class="form-inner mb-35 d-flex justify-content-between flex-wrap position-relative">
                    <div class="form-group">
                        <input type="checkbox" id="remember_me" name="remember" class="form-check-input">
                        <label for="remember_me">{{translate('Remember Me')}}</label>
                    </div>
                    @if (Route::has('password.request'))
                        <a href="{{ route('password.request') }}" class="forgot-pass">{{translate('Forgotten Password')}}</a>
                    @endif
                </div>
                <button type="submit" class="eg-btn btn--primary login-btn"> <img src="{{asset('backend/images/icons/login-user.svg')}}" alt=" User Login"> {{translate('Login')}}</button>
            </form>
        </div>
    </div>
</body>
</html>