$(function () {
    "use strict";

    var $form = $(".modal-require-validation");
    const stripeKey = $form.data('modal-stripe-publishable-key');
    if (!stripeKey) {
        console.error('Stripe publishable key is not set!');
        return;
    }

    const stripe = Stripe(stripeKey);
    const elements = stripe.elements();

    const style = {
        base: {
            fontSize: '16px',
            color: '#32325d',
            '::placeholder': {
                color: '#aab7c4'
            }
        },
        invalid: {
            color: '#fa755a',
            iconColor: '#fa755a'
        }
    };

    const card = elements.create('card', { style: style });
    card.mount('#card-element');

    card.on('change', function(event) {
        if (event.error) {
            $('#card-errors').text(event.error.message);
        } else {
            $('#card-errors').text('');
        }
    });

    $form.on('submit', function (e) {
        var payment_method = $('.payment-option .custom-radio input[name="payment_method"]:checked').val();
        if (payment_method === 'stripe') {
            e.preventDefault();

            $('.modal-error').addClass('d-none');
            $('#card-errors').text('');

            stripe.createToken(card).then(function(result) {
                if (result.error) {
                    $('#card-errors').text(result.error.message);
                } else {
                    console.log(result.token.id);
                    $form.find('input[name=stripeToken]').remove();
                    $form.append('<input type="hidden" name="stripeToken" value="' + result.token.id + '">');
                    $form.get(0).submit();
                }
            });
        }
        else if (payment_method === 'razorpay') {
            e.preventDefault();

            // Prepare form data to send to server
            var formData = new FormData($form[0]);

            fetch($form.attr('action'), {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $form.find('input[name="_token"]').val()
                },
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.error) {
                    alert(data.error);
                    return;
                }

                var options = {
                    key: data.razorpayKey, // Razorpay key from backend
                    amount: data.amount,
                    currency: data.currency,
                    name: data.name,
                    description: data.description,
                    order_id: data.orderId,
                    handler: function (response) {
                        // Create a form to verify payment server-side
                        var verifyForm = $('<form>', {
                            method: 'POST',
                            action: '/payment/success/razorpay'
                        });

                        verifyForm.append($('<input>', {
                            type: 'hidden',
                            name: 'razorpay_payment_id',
                            value: response.razorpay_payment_id
                        }));
                        verifyForm.append($('<input>', {
                            type: 'hidden',
                            name: 'razorpay_order_id',
                            value: response.razorpay_order_id
                        }));
                        verifyForm.append($('<input>', {
                            type: 'hidden',
                            name: 'razorpay_signature',
                            value: response.razorpay_signature
                        }));
                        verifyForm.append($('<input>', {
                            type: 'hidden',
                            name: '_token',
                            value: $form.find('input[name="_token"]').val()
                        }));

                        $('body').append(verifyForm);
                        verifyForm.submit();
                    },
                    prefill: {
                        email: data.email,
                        contact: data.contact
                    },
                    theme: {
                        color: '#3399cc'
                    }
                };

                var rzp = new Razorpay(options);
                rzp.open();
            })
            .catch(error => {
                alert('Payment initialization failed. Please try again.');
                console.error(error);
            });
        }
    });
});
