(function ($) {
	"use strict";
    $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
    var successAlertImage = "/backend/plugins/cutealert/img/success.svg";
    var errorAlertImage = "/backend/plugins/cutealert/img/error.svg";
    var questionAlertImage = "/backend/plugins/cutealert/img/question.svg";
    var warningALertImage = "/backend/plugins/cutealert/img/warning.svg";
    var infoALertImage = "/backend/plugins/cutealert/img/info.svg";

    if ($('#lang-change').length > 0) {
        $('#lang-change .language-list li a').each(function () {
            $(this).on('click', function (e) {
                e.preventDefault();
                var locale = $(this).data('flag');
				console.log(locale);
                $.post('/changelanguage', { locale: locale }, function (res) {
                    console.log(res);
                    location.reload();
                    if (res.output == 'success') {
                        cuteToast({
                            type: "success",
                            message: res.message,
                            img: successAlertImage,
                            timer: 1500
                        });

                    }
                });

            });
        });
    }

    // Get State by dropdown
    $('.country_id').on('change', function () {
        var country_id = this.value;
        $(".state_id").empty();
        if (country_id) {
            $.ajax({
                url: "/location/get/state",
                type: "POST",
                data: {
                    country_id: country_id,
                },
                dataType: 'json',
                success: function (res) {
                    $('.state_id').html('<option value="">' + res.option + '</option>');
                    $.each(res.states, function (key, value) {
                        $(".state_id").append('<option value="' + value
                            .id + '">' + value.name + '</option>');
                    });
                }
            });
        }
    });

    // Get City by dropdown
    $('.state_id').on('change', function () {
        var state_id = this.value;
        $(".city_id").empty();
        if (state_id) {
            $.ajax({
                url: "/location/get/city",
                type: "POST",
                data: {
                    state_id: state_id,
                },
                dataType: 'json',
                success: function (res) {
                    $('.city_id').html('<option value="">' + res.option + '</option>');
                    $.each(res.city, function (key, value) {
                        $(".city_id").append('<option value="' + value
                            .id + '">' + value.name + '</option>');
                    });
                }
            });
        }
    });

    $('.select2').select2({
        width: '100%'
    });


    $(function () {
        $('.choose-payment-mathord .payment-method-section .custom-radio').on('click', function () {
    // Remove active class from all and hide all check marks
    $('.choose-payment-mathord .payment-method-section .custom-radio').removeClass('active');
    $('.choose-payment-mathord .payment-method-section .checked').addClass('d-none');

    // Add active class to clicked item
    $(this).addClass('active');

    // Show the check mark inside the clicked item
    $(this).find('.checked').removeClass('d-none');

    // Show/hide Stripe payment section based on class
    if ($(this).hasClass('stripe')) {
        $('#StripePayment').show();
    } else {
        $('#StripePayment').hide();
    }
});
    });

 $("input:radio[name=fixed_price]").click(function () {
        var fixed_price = $(this).val();
        if (fixed_price == 'other_amount') {
            $('#OtherPrice').show();
            $('#OtherPrice #modal_other_amount').prop('required', true);
        } else {
            $('#OtherPrice #modal_other_amount').prop('required', false);
            $('#OtherPrice').hide();
            $('.modal_amount_main').text(fixed_price);
            $('.modal_amount_main_val').val(fixed_price);
            // var tax_rate = $('#taxRate').val();
            // var tax_amount = (fixed_price / 100 ) * tax_rate;
            $('.modal_tax_amount').text(0);
            $('.modal_tax_amount_val').val(0);
            var total_amount = (parseFloat(fixed_price) + parseFloat(0));
            $('.modal_total_amount').text(total_amount);
            $('.modal_total_amount_val').val(total_amount);
        }

        $("#modal_other_amount").bind('keyup', function () {
            var fixed_price = $(this).val();
            $('.modal_amount_main').text(fixed_price);
            $('.modal_amount_main_val').val(fixed_price);
            // var tax_rate = $('#taxRate').val();
            // var tax_amount = (fixed_price / 100 ) * tax_rate;
            $('.modal_tax_amount').text(0);
            $('.modal_tax_amount_val').val(0);
            if (fixed_price) {
                var total_amount = (parseFloat(fixed_price) + parseFloat(0));
                $('.modal_total_amount').text(total_amount);
                $('.modal_total_amount_val').val(total_amount);
            } else {
                $('.modal_total_amount').text(0);
                $('.modal_total_amount_val').val(0);
            }
        });

    });

    // Auto slash of Expiry Date
    var card_date = document.getElementById('stripe_card_expiry');
    var card_date_modal = document.getElementById('modal_stripe_card_expiry');

    function checkValue(str, max) {
        if (str.charAt(0) !== '0' || str == '00') {
            var num = parseInt(str);
            if (isNaN(num) || num <= 0 || num > max) num = 1;
            str = num > parseInt(max.toString().charAt(0))
                && num.toString().length == 1 ? '0' + num : num.toString();
        };
        return str;
    };
    if (card_date) {
        card_date.addEventListener('input', function (e) {
            this.type = 'text';
            var input = this.value;
            if (/\D\/$/.test(input)) input = input.substr(0, input.length - 1);
            var values = input.split('/').map(function (v) {
                return v.replace(/\D/g, '')
            });
            if (values[0]) values[0] = checkValue(values[0], 12);
            if (values[1]) values[1] = checkValue(values[1], 50);
            var output = values.map(function (v, i) {
                return v.length == 2 && i < 2 ? v + '/' : v;
            });
            this.value = output.join('').substr(0, 5);
        });
    }
    if (card_date_modal) {
        card_date_modal.addEventListener('input', function (e) {
            this.type = 'text';
            var input = this.value;
            if (/\D\/$/.test(input)) input = input.substr(0, input.length - 1);
            var values = input.split('/').map(function (v) {
                return v.replace(/\D/g, '')
            });
            if (values[0]) values[0] = checkValue(values[0], 12);
            if (values[1]) values[1] = checkValue(values[1], 50);
            var output = values.map(function (v, i) {
                return v.length == 2 && i < 2 ? v + '/' : v;
            });
            this.value = output.join('').substr(0, 5);
        });
    }


    $(function () {
    $('.choose-payment-method .checkout-payment-option ul li').on('click', function () {
        $('.choose-payment-method .checkout-payment-option ul li').removeClass('active'); // Remove active class from all list items
        if ($(this).hasClass('stripe')) {
            $('#StripePayment').show();
            $(this).addClass('active'); // Add active class to the clicked list item
        }
        else if ($(this).hasClass('paypal')) {
            $('#StripePayment').hide();
            $(this).addClass('active'); // Add active class to the clicked list item
        }
        else if ($(this).hasClass('wallet')) {
            $('#StripePayment').hide();
            $(this).addClass('active'); // Add active class to the clicked list item
        }
        else if ($(this).hasClass('razorpay')) {
            $('#StripePayment').hide();
            $(this).addClass('active'); // Add active class to the clicked list item
        }
        else {
            $('#StripePayment').hide();
        }
    });
});
$(document).ready(function () {
$('.is_dashboard').on('change',function(){
    $('#panel_dashboard').submit();
});
});

    // Delete Confirm by sweetalert
$('.show_confirm').on("click", function (event) {
    var form = $(this).closest("form");
    event.preventDefault();

    Swal.fire({
        title: 'Are you sure you want to delete this record?',
        text: "If you delete this, it will be gone forever.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Yes, delete it!',
        cancelButtonText: 'No, cancel!',
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            form.submit();
        } else if (
            /* Read more about handling dismissals below */
            result.dismiss === Swal.DismissReason.cancel
        ) {
            Swal.fire(
                'Cancelled',
                'Your record is safe :)',
                'info'
            )
        }
    });
});

$('.filter_by').on('change', function () {
    $(this).closest('form').submit();
});


$(document).ready(function () {
        $(".replay-btn").click(function (e) {
            var comId = $(this).data('comment_id');
            $('#replyModal').modal("show");
            $('#replyModal #parent_id').val(comId);
        });
    });

$('#downloadPdf').click(function() {
    const { jsPDF } = window.jspdf;
    const element = document.getElementById('pdfContent');

    html2canvas(element, {
        scale: 3,           // High-resolution
        useCORS: true,      // Allow cross-origin images/fonts
        logging: true
    }).then(canvas => {
        const imgData = canvas.toDataURL('image/jpeg', 1.0); // JPEG format
        const pdf = new jsPDF('landscape', 'mm', 'a4');      // A4 landscape

        const pageWidth = pdf.internal.pageSize.getWidth();
        const pageHeight = pdf.internal.pageSize.getHeight();

        // Scale the image to full A4
        pdf.addImage(imgData, 'JPEG', 0, 0, pageWidth, pageHeight);
        pdf.save('document-' + new Date().getTime() + '.pdf');
    });
});
$(document).ready(function() {
    $('#printBtn').click(function() {
        // Trigger print
        window.print();
    });
});
}(jQuery));
function wishlistFunction() {
    // Get the button that was clicked
    const button = event.currentTarget;
    const itemId = button.dataset.id;
    const isAuth = button.dataset.auth;

    // If not logged in
    if (!isAuth || isAuth === "0") {
        window.location.href = "/login";
        return;
    }

    fetch("/user/wishlist/store", {
        method: "POST",
        headers: {
            "Content-Type": "application/json",
            "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify({ item_id: itemId })
    })
    .then(response => response.json())
    .then(data => {
        if (data.status === 'added') {
            // Change to filled heart
            button.innerHTML = `
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="15" viewBox="0 0 16 15">
                    <path fill="#e63946" d="M8.00013 13.6828C4.76378 11.4628 2.96935 9.42471 2.10683 7.72315C1.21149 5.95597 1.32211 4.57128 1.81244 3.61222C2.85685 1.57317 5.75006 1.01348 7.32792 2.63535L8.00013 3.32629L8.67234 2.63441C10.2502 1.01254 13.1434 1.57317 14.1878 3.61222C14.6791 4.57128 14.7888 5.95503 13.8934 7.72315C13.03 9.42471 11.2365 11.4628 8.00013 13.6828Z"/>
                </svg>
            `;
            cuteToast({
                type: "success",
                message: data.message,
                img: successAlertImage,
                timer: 1500
            });
        } else if (data.status === 'exists') {
            cuteToast({
                type: "error",
                message: data.message,
                img: errorAlertImage,
                timer: 1500
            });
        }
    })
    .catch(() => {
        cuteToast({
            type: "error",
            message: "Something went wrong!",
            img: errorAlertImage,
            timer: 1500
        });
    });
}


document.addEventListener('DOMContentLoaded', function() {
        const imageInput = document.getElementById('imageInput');
        const imagePreview = document.getElementById('imagePreview');

        if (imageInput && imagePreview) {
            imageInput.addEventListener('change', function(event) {
                const file = event.target.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        imagePreview.src = e.target.result;
                    };
                    reader.readAsDataURL(file);
                }
            });
        }
    });
