(function ($) {
    "use strict";
    let debounceTimeout;

    function filterSearchJob(page = 1) {
        let category = getCheckedValues('category_id');
        let artist = getCheckedValues('artist_id');
        let art_type = getCheckedValues('art_type');
        let order_by = $('.order_by').val() || "";
        let keyword = $(".keyword").val() || "";

        let artwork_type = $("#artwork_type").val();
        let widget_name = $("#widget_name").val();
        let item_show = $("#item_show").val();

        let params = $.param({
            page: page,
            order_by: order_by,
            category_id: category.join(','),
            artist_id: artist.join(','),
            keyword: keyword,
            art_type: art_type.join(','),
            artwork_type: artwork_type,
            widget_name: widget_name,
            item_show: item_show,
        });

        $.ajax({
            url: window.location.pathname + "?" + params,
            type: "GET",
            dataType: "json",
            success: function (data) {
                if (data.status) {
                    $("#loadArtwork").html(data.artworks);
                    if (data.total > 0) {
                        $(".from-count").text(data.first_item);
                        $(".to-count").text(data.last_item);
                        $(".total-count").text(data.total);
                    } else {
                        $(".result-summary").html(`Showing 0 of 0 results`);
                    }

                    $('#hidden_page').val(page || 1);
                    history.pushState(null, '', window.location.pathname + "?" + params);

                    $("[data-countdown]").each(function () {
                        var $deadline = new Date($(this).data("countdown")).getTime();
                        var $dataDays = $(this).children("[data-days]");
                        var $dataHours = $(this).children("[data-hours]");
                        var $dataMinutes = $(this).children("[data-minutes]");
                        var $dataSeconds = $(this).children("[data-seconds]");
                        var x = setInterval(function () {
                            var now = new Date().getTime();
                            var t = $deadline - now;
                            var days = Math.floor(t / (1000 * 60 * 60 * 24));
                            var hours = Math.floor((t % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                            var minutes = Math.floor((t % (1000 * 60 * 60)) / (1000 * 60));
                            var seconds = Math.floor((t % (1000 * 60)) / 1000);
                            $dataDays.html(`${days} <span>D</span> <span>Days</span>`);
                            $dataHours.html(`${hours} <span>H</span> <span>Hours</span>`);
                            $dataMinutes.html(`${minutes} <span>M</span> <span>Minutes</span>`);
                            $dataSeconds.html(`${seconds} <span>Sec</span> <span>Seconds</span>`);
                            if (t <= 0) {
                                clearInterval(x);
                                $dataDays.html("00 <span>D</span> <span>Days</span>");
                                $dataHours.html("00 <span>H</span> <span>Hours</span>");
                                $dataMinutes.html("00 <span>M</span> <span>Minutes</span>");
                                $dataSeconds.html("00 <span>Sec</span> <span>Seconds</span>");
                            }
                        }, 1000);
                    });
                }
            },
            error: function (err) {
                console.error(err);
            }
        });
    }

    function getCheckedValues(className) {
        let arr = [];
        $('.' + className + ':checked').each(function () {
            arr.push($(this).val());
        });
        return arr;
    }

    $('#productSearch').on('submit', function (e) {
        e.preventDefault();
        filterSearchJob();
    });

    $(document).on('input', '.keyword', function () {
        clearTimeout(debounceTimeout);
        debounceTimeout = setTimeout(() => filterSearchJob(), 500);
    });

    $(document).on('change', '.category_id, .artist_id, .art_type, .order_by', function () {
        filterSearchJob();
    });

    $(document).on('click', '.pagination a', function (e) {
        e.preventDefault();
        let page = $(this).attr('href').split('page=')[1];
        filterSearchJob(page);
    });

})(jQuery);
