(function ($) {
    "use strict";
    Dropzone.autoDiscover = false;
    // Csrf Token Loaded
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    // language change
    if ($('#lang-change').length > 0) {
        $('#lang-change .dropdown-menu li a').each(function () {
            $(this).on('click', function (e) {
                e.preventDefault();
                var $this = $(this);
                var locale = $this.data('flag');
                $.post('/changelanguage', { locale: locale }, function (res) {
                    console.log(res);
                    location.reload();
                    if (res.output == 'success') {
                        cuteToast({
                            type: "success",
                            message: res.message,
                            img: successAlertImage,
                            timer: 1500
                        });

                    }
                });

            });
        });
    }

    // Delete Confirm by sweetalert
$('.show_confirm').on("click", function (event) {
    var form = $(this).closest("form");
    event.preventDefault();

    Swal.fire({
        title: 'Are you sure you want to delete this record?',
        text: "If you delete this, it will be gone forever.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Yes, delete it!',
        cancelButtonText: 'No, cancel!',
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            form.submit();
        } else if (
            /* Read more about handling dismissals below */
            result.dismiss === Swal.DismissReason.cancel
        ) {
            Swal.fire(
                'Cancelled',
                'Your record is safe :)',
                'info'
            )
        }
    });
});

$('.winner_confirm').on("click", function (event) {
    var form = $(this).closest("form");
    var status = $(this).data("status");
    event.preventDefault();
    if (status == 2) {
    Swal.fire({
        title: `Are you sure you want to winner return this bid?`,
        text: "If you return winner this, it will be delivered the auctions.",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Yes, return it!',
        cancelButtonText: 'No, cancel!',
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            form.submit();
        } else if (
            /* Read more about handling dismissals below */
            result.dismiss === Swal.DismissReason.cancel
        ) {
            Swal.fire(
                'Cancelled',
                'Your record is safe :)',
                'info'
            )
        }
    });
}else{
    Swal.fire({
        title: `Are you sure you want to winner this bid?`,
        text: "If you winner this, it will be delivered the auctions.",
        icon: "success",
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, winner it!',
        cancelButtonText: 'No, cancel!',
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            form.submit();
        } else if (
            /* Read more about handling dismissals below */
            result.dismiss === Swal.DismissReason.cancel
        ) {
            Swal.fire(
                'Cancelled',
                'Your record is safe :)',
                'info'
            )
        }
    });
}
});

    // Select 2 with image for language code
    $(document).ready(function () {
        $("#language_code").select2({
            width: '100%',
            templateResult: formatOptions
        });
    });

    function formatOptions(lang) {
        if (!lang.id) { return lang.text; }

        console.log(lang.element.value);

        var $lang = $(
            '<span ><img sytle="display: inline-block;" src="/flags/' + lang.element.value.toLowerCase() + '.png"  /> ' + lang.text + '</span>'
        );

        return $lang;
    }

    $('.stausChange').on("change", function () {
        var data_id = $(this).data('id');
        var data_type = $(this).data('type');

        if (data_type == 'language') {
            var url = '/dashboard/languages/change/status';
        }else if(data_type == 'blogCategory'){
            var url = '/dashboard/blogs/categories/change/status';
        }else if(data_type == 'blog'){
            var url = '/dashboard/blogs/change/status';
        }else if(data_type == 'customer'){
            var url = '/dashboard/customer/change/status';
        }else if(data_type == 'artGallery'){
            var url = '/dashboard/art-gallery/change/status';
        }else if(data_type == 'artist'){
            var url = '/dashboard/artist/change/status';
        }else if(data_type == 'artworkCategory'){
            var url = '/dashboard/artwork/categories/change/status';
        }else if(data_type == 'artwork'){
            var url = '/dashboard/artworks/change/status';
        }else if(data_type == 'payment_methods'){
            var url = '/dashboard/payment/methods/change/status';
        }
        
        
        changeStatus(data_id, url);
    });

    function changeStatus(data_id, url) {
        if (data_id) {
            $.ajax({
                type: "POST",
                dataType: "json",
                url: url,
                data: { 'data_id': data_id },
                success: function (res) {
                    if (res.output == 'success') {
                        if (res.statusId == 1) {
                            $("#stausChange" + res.dataId).attr("checked", "checked");
                            cuteToast({
                                type: "success",
                                message: res.message,
                                img: successAlertImage,
                                timer: 1500
                            });

                        } else {
                            $("#stausChange" + res.dataId).removeAttr('checked');
                            cuteToast({
                                type: "success",
                                message: res.message,
                                img: successAlertImage,
                                timer: 1500
                            });
                        }
                    }
                },
                error: function (xhr) {
                    alert("Something Wrong")
                }
            });
        }
    }

    // allow seo option
    $('.seo-page-checkbox').on('change', function () {

        if ($(this).is(":checked")) {
            $(".seo-content").show();
        } else {
            $(".seo-content").hide();
        }
    })

    $('.seo-page-checkbox').trigger('change');

    // allow seo option
    $('.is_bread_crumb').on('change', function () {

        if ($(this).is(":checked")) {
            $(".bread-content").show();
        } else {
            $(".bread-content").hide();
        }
    })

    $('.is_bread_crumb').trigger('change');

    // meta keyward
    $(".meta-keyward").select2({
        tags: true,
        placeholder: "Meta keyward",
        width: "100%"
    });

    function readFile(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();

            reader.onload = function (e) {
                var htmlPreview =
                    '<img width="100" src="' + e.target.result + '" />' +
                    '<p>' + input.files[0].name + '</p>';
                var wrapperZone = $(input).parent();
                var previewZone = $(input).parent().parent().find('.preview-zone');
                var boxZone = $(input).parent().parent().find('.preview-zone').find('.box').find('.box-body');

                wrapperZone.removeClass('dragover');
                previewZone.removeClass('hidden');
                boxZone.empty();
                boxZone.append(htmlPreview);
                $('.file-upload .remove-preview').show();
            };

            reader.readAsDataURL(input.files[0]);
        }
    }

    function reset(e) {
        e.wrap('<form>').closest('form').get(0).reset();
        e.unwrap();
    }

    $(".featues_image").on('change', function () {
        readFile(this);
    });

    $('.file-upload .dropzone-wrapper').on('dragover', function (e) {
        e.preventDefault();
        e.stopPropagation();
        $(this).addClass('dragover');
    });

    $('.file-upload .dropzone-wrapper').on('dragleave', function (e) {
        e.preventDefault();
        e.stopPropagation();
        $(this).removeClass('dragover');
    });

    $('.file-upload .remove-preview').on('click', function () {
        var boxZone = $(this).parents('.file-upload .preview-zone').find('.box-body');
        var previewZone = $(this).parents('.file-upload .preview-zone');
        var dropzone = $(this).parents('.file-upload').find('.featues_image');
        boxZone.empty();
        previewZone.addClass('hidden');
        reset(dropzone);
        $('.file-upload .remove-preview').hide();
    });

    $(document).ready(function () {
        if (window.File && window.FileList && window.FileReader) {
            $("#files").on("change", function (e) {
                var files = e.target.files,
                    filesLength = files.length;
                var boxZone = $('.gallery-preview-zone').find('.box').find('.box-body');
                for (var i = 0; i < filesLength; i++) {
                    var f = files[i]
                    var fileReader = new FileReader();
                    fileReader.onload = (function (e) {
                        $("<div class=\"img-thumb-wrapper card shadow\">" +
                            "<span class=\"remove\">X</span>" +
                            "<img class=\"img-thumb\" src=\"" + e.target.result + "\" title=\"" + f.name + "\"/>" +
                            "</div>").appendTo(boxZone);
                        $(".remove").click(function () {
                            $(this).parent(".img-thumb-wrapper").remove();
                        });

                    });
                    fileReader.readAsDataURL(f);
                }
                // console.log(files);
            });
        } else {
            alert("Your browser doesn't support to File API")
        }
    });

// password-hide and show
	const togglePassword = document.querySelector('#togglePassword');
	const password = document.querySelector('#password');
	if (togglePassword) {
		togglePassword.addEventListener('click', function (e) {
			// toggle the type attribute
			const type = password.getAttribute('type') === 'password' ? 'text' : 'password';
			password.setAttribute('type', type);
			// toggle the eye / eye slash icon
			this.classList.toggle('bi-eye');
		});
	}

	// New-password
	const togglePassword2 = document.getElementById('togglePassword2');
	const password2 = document.querySelector('#password2');
	if (togglePassword2) {
		togglePassword2.addEventListener('click', function (e) {
			// toggle the type attribute
			const type = password2.getAttribute('type') === 'password' ? 'text' : 'password';
			password2.setAttribute('type', type);
			// toggle the eye / eye slash icon
			this.classList.toggle('bi-eye');
		});
	}

    $(".pricing-area-schedule").hide();


    $(document).on('change', '.auction_type_select', function (e) {

        e.preventDefault();
        let type = $(this).val();
        $(".pricing-area-schedule").show();

        if (type == 2) {
            $(".auction_type").hide();
            $(".direct_type").show();
            $('.direct_type .price').attr('required', 'required');
            $('.auction_type input').removeAttr('required');
            $('.auction_type select').removeAttr('required');
            $('.auction_schedule').hide();

        } else if (type == 1) {
            $(".direct_type").hide();
            $(".auction_type").show();
            $('.direct_type .price').removeAttr('required');
            $('.auction_type input').attr('required', 'required');
            $('.auction_type select').attr('required', 'required');
            $('.auction_schedule').show();
        }
    })

    $(document).ready(function () {
            $(".schedule_start_date").hide();
            $('.schedule_start_date #datepicker').removeAttr('required');
    });



    $(document).on('change', '.auction_schedule_type', function (e) {
        e.preventDefault();
        let type = $(this).val();
        if (type == 2) {
            $(".schedule_start_date").hide();
            $('.schedule_start_date #datepicker').removeAttr('required');
        } else if (type == 1) {
            $(".schedule_start_date").show();
            $('.schedule_start_date #datepicker').attr('required', 'required');
        }
        
    });

    let productType = $("#product_sale_type").val();
    if (productType !== "") {
        $(".auction_type_select").trigger('change');
        $(".auction_schedule_type").trigger('change');
    }


     // Get State by dropdown
    $('.country_id').on('change', function () {
        var country_id = this.value;
        $(".state_id").empty();
        if (country_id) {
            $.ajax({
                url: "/location/get/state",
                type: "POST",
                data: {
                    country_id: country_id,
                },
                dataType: 'json',
                success: function (res) {
                    $('.state_id').html('<option value="">' + res.option + '</option>');
                    $.each(res.states, function (key, value) {
                        $(".state_id").append('<option value="' + value
                            .id + '">' + value.name + '</option>');
                    });
                    $('.state_id').niceSelect('destroy');
                    $('.state_id').niceSelect();
                }
            });
        }
    });

    // Get City by dropdown
    $('.state_id').on('change', function () {
        var state_id = this.value;
        $(".city_id").empty();
        if (state_id) {
            $.ajax({
                url: "/location/get/city",
                type: "POST",
                data: {
                    state_id: state_id,
                },
                dataType: 'json',
                success: function (res) {
                    $('.city_id').html('<option value="">' + res.option + '</option>');
                    $.each(res.city, function (key, value) {
                        $(".city_id").append('<option value="' + value
                            .id + '">' + value.name + '</option>');
                    });
                    $('.city_id').niceSelect('destroy');
                    $('.city_id').niceSelect();
                }
            });
        }
    });

    $(document).on('click', '.removeRow', function () {
        $(this).parent().parent().remove();
    });

    // merchant payment
    let payment = $('#bankDetailsMainContent .payment_info').length;
    $('.addPayment').on('click', function () {

        payment++

        var row = '<div class="row payment_info mt-3">' +
            '<div class="col-lg-6">' +
            '<div class="form-inner mb-35">' +
            '<input type="hidden" name="merchant_payment_id['+payment+']" value=""></input>' +
            '<label>Type <span class="text-danger">*</span></label>' +
            '<select name="payment_type['+payment+']" class="select2 payment_type" >' +
            '<option value="">Select Option</option>' +
            '<option value="1">Bank</option>' +
            '<option value="2">Mobile Banking</option>' +
            '<option value="3">Paypal</option>' +
            '</select>' +
            '</div>' +
            '</div>' +
            '<div class="col-lg-6 select_bank" style="display:none;">' +
            '<div class="form-inner mb-35">' +
            '<label>Bank Name</label>' +
            '<input type="text" class="bank_name" name="bank_name['+payment+']" placeholder="Enter Bank Name">' +
            '</div>' +
            '</div>' +
            '<div class="col-lg-6 select_bank" style="display:none;">'+
                '<div class="form-inner">'+
                    '<label>Branch Name</label>'+
                        '<input type="text" class="branch_name" name="branch_name['+payment+']" placeholder="Enter Branch Name">'+
                '</div>'+
            '</div>'+
            '<div class="col-lg-6 select_bank" style="display:none;">' +
            '<div class="form-inner mb-35">' +
            '<label>Bank Account Name</label>' +
            '<input type="text" class="bank_ac_name" name="bank_ac_name['+payment+']" placeholder="Enter Bank Account Name">' +
            '</div>' +
            '</div>' +
            '<div class="col-lg-6 select_bank" style="display:none;">' +
            '<div class="form-inner mb-35">' +
            '<label>Bank Account Number</label>' +
            '<input type="text" name="bank_ac_number['+payment+']" class="bank_ac_number username-input" placeholder="Enter Bank Account Number">' +
            '</div>' +
            '</div>' +
            '<div class="col-lg-6 select_bank" style="display:none;">' +
            '<div class="form-inner mb-35 ">' +
            '<label>Bank Routing Number</label>' +
            '<input type="text" class="bank_routing_number" name="bank_routing_number['+payment+']" placeholder="Enter Bank Routing Number">' +
            '</div>' +
            '</div>' +
            '<div class="col-lg-6 select_mobile" style="display:none;">' +
            '<div class="form-inner mb-35 ">' +
            '<label>Mobile Banking Name</label>' +
            '<input type="text" class="mobile_banking_name" name="mobile_banking_name['+payment+']" placeholder="Enter Mobile Banking Name">' +
            '</div>' +
            '</div>' +
            '<div class="col-lg-6 select_mobile" style="display:none;">' +
            '<div class="form-inner mb-35 ">' +
            '<label>Mobile Number</label>' +
            '<input type="text" class="mobile_banking_number" name="mobile_banking_number['+payment+']" placeholder="Enter Mobile Number">' +
            '</div>' +
            '</div>' +
            '<div class="col-lg-6 select_paypal" style="display:none;">' +
            '<div class="form-inner mb-35 ">' +
            '<label>Paypal Name</label>' +
            '<input type="text" class="paypal_name" name="paypal_name['+payment+']" placeholder="Enter Paypal Name">' +
            '</div>' +
            '</div>' +
            '<div class="col-lg-6 select_paypal" style="display:none;">' +
            '<div class="form-inner mb-35 ">' +
            '<label>Paypal Username</label>' +
            '<input type="text" class="paypal_username" name="paypal_username['+payment+']" placeholder="Enter Paypal Username">' +
            '</div>' +
            '</div>' +
            '<div class="col-lg-6 select_paypal" style="display:none;">' +
            '<div class="form-inner mb-35 ">' +
            '<label>Paypal Email</label>' +
            '<input type="email" class="paypal_email" name="paypal_email['+payment+']" placeholder="Enter Paypal Email">' +
            '</div>' +
            '</div>' +
            '<div class="col-lg-6 select_paypal" style="display:none;">' +
            '<div class="form-inner mb-35 ">' +
            '<label>Paypal Mobile Number</label>' +
            '<input type="text" class="paypal_mobile_number" name="paypal_mobile_number['+payment+']" placeholder="Enter Paypal Mobile Number">' +
            '</div>' +
            '</div>' +
            '<div class="col-lg-12" >' +
            '<button style="float: right;" type="button" class="removePaymentRow eg-btn btn--red rounded px-3">' +
            '<i class="bi bi-x"></i>' +
            '</button>' +
            '</div>' +
            '</div>';
        $('#bankDetailsMainContent').append(row);
        $('.select2').select2({
            width: '100%'
        });
    });
    $('#bankDetailsMainContent').on('click', '.removePaymentRow', function () {
        var l = $('#bankDetailsMainContent .payment_info').length;
        if (l == 1) {
            alert('You can not remove last one');
        } else {
            $(this).parent().parent().remove();
        }
    });

    $('#bankDetailsMainContent').delegate('.payment_type', 'change', function () {
        var rows = $(this).parent().parent().parent();
        var payment_type = rows.find('.payment_type :selected').val();
        if (payment_type == 1) {
            rows.find('.select_bank').show();
            rows.find('.select_mobile').hide();
            rows.find('.select_paypal').hide();
        } else if (payment_type == 2) {
            rows.find('.select_bank').hide();
            rows.find('.select_mobile').show();
            rows.find('.select_paypal').hide();
        } else if (payment_type == 3) {
            rows.find('.select_bank').hide();
            rows.find('.select_mobile').hide();
            rows.find('.select_paypal').show();
        } else {
            rows.find('.select_bank').hide();
            rows.find('.select_mobile').hide();
            rows.find('.select_paypal').hide();
        }
    });

     // Get Artists by Author
    $('.author_id').on('change', function () {
        var author_id = this.value;
        $(".artist_id").empty();
        if (author_id) {
            $.ajax({
                url: "/dashboard/artworks/get/artists",
                type: "POST",
                data: {
                    author_id: author_id,
                },
                dataType: 'json',
                success: function (res) {
                    $('.artist_id').html('<option value="">' + res.option + '</option>');
                    $.each(res.artists, function (key, value) {
                        $(".artist_id").append('<option value="' + value
                            .id + '">' + value.name + '</option>');
                    });
                }
            });
        }
    });

    $(document).ready(function () {
    const $year = $('#year');

    // Populate years
    const currentYear = new Date().getFullYear();
    for (let y = currentYear - 100; y <= currentYear + 20; y++) {
        $year.append(`<option value="${y}">${y}</option>`);
    }

    });


    // adding input with click
    let specification = $('#specifiction_artwork .specificationRow').length;

    $(".addSpecification").on("click", function () {

        specification++

        let html = `<div class="mb-3 row g-3 specificationRow">
            <div class="form-inner col-md-6">
                <input type="text" name="specifications[${specification}][label]" class="m-input" placeholder="Label" autocomplete="off">
            </div>
             <div class="form-inner col-md-6 d-flex justify-content-center gap-2">
                <input type="text" name="specifications[${specification}][value]" class=" n-input" placeholder="Value" autocomplete="off">
                <button type="button" class="removeRow eg-btn btn--red rounded px-3">
                <i class="bi bi-x"></i></button></div><div class="input-group-append">
            </div>
        </div>`;
        $('#specifiction_artwork').append(html);
    });

    // artwork gallery remove
    $('.exist_remove').on('click', function () {
        var dataId = $(this).attr("data-gellery_id");
        if (dataId) {
            $.ajax({
                type: 'POST',
                url: "/dashboard/artworks/gallery/remove",
                data: {
                    dataId: dataId
                },
                dataType: 'json',
                cache: false,
                success: (res) => {
                    if (res.output == 'success') {
                        $("#gallery" + res.dataId).hide();
                        cuteToast({
                            type: "success",
                            message: res.message,
                            img: successAlertImage,
                            timer: 1500
                        });

                    }
                },
                error: function (xhr) {
                    alert("Something Wrong")
                }
            });
        }
    });


    $('.editPaymentMethods').on('click', function () {
        var id = $(this).attr("data-method_id");

        $.ajax({
            type: "POST",
            url: "/dashboard/payment/methods/edit",
            data: {
                id: id
            },
            dataType: 'json',
            success: function (res) {
                $('#paymentMethodsModal').modal('show');
                $('#method_id').val(res.id);
                $('#method_name').val(res.name);
                $('#method_mode').val(res.mode);
                if (res.mode == 1) {
                    $('#method_mode').prop('checked', false);
                    $('#method_mode_btn').text('Sandbox');
                    $('#method_mode_btn').removeClass('green-light--btn');
                    $('#method_mode_btn').addClass('orange-light--btn');
                } else {
                    $('#method_mode').prop('checked', true);
                    $('#method_mode_btn').text('Live');
                    $('#method_mode_btn').removeClass('orange-light--btn');
                    $('#method_mode_btn').addClass('green-light--btn');
                }
                if (res.logo) {
                    $('#payment_method_logo').attr('src', '/uploads/files/' + res.logo);
                }

                if (res.id == 1) {
                    $('#method_key').prop('required', false);
                    $('#method_secret').prop('required', false);
                    $('#method_key_div').hide();
                    $('#method_secret_div').hide();
                    $('#method_mode_div').hide();
                    $('#method_mode_div').removeClass('d-flex');
                    $('#method_key').val('');
                    $('#method_secret').val('');

                    $('#currency_rate').prop('required', false);
                    $('#method_rate_div').hide();
                    $('#currency_rate').val('');
                    $('#currency_id').val('');
                } else {
                    if (res.id == 4) {
                        $('#currency_label').text('Rs1 = ');
                        $('#currency_id').val(28);
                    } else {
                        $('#currency_id').val(1);
                        $('#currency_label').text('$1 = ');
                    }
                    $('#method_rate_div').show();
                    $('#currency_rate').prop('required', true);
                    $('#currency_rate').val(res.currency_rate);
                    $('#method_key_div').show();
                    $('#method_secret_div').show();
                    $('#method_mode_div').addClass('d-flex');
                    $('#method_mode_div').show();
                    $("#method_key").prop('required', true);
                    $("#method_secret").prop('required', true);
                    $('#method_key').val(res.key);
                    $('#method_secret').val(res.secret);
                }
            }
        });
    });

     // timer start
    function makeTimer() {
        var end_date = $("#bid_end_time").val();
        var endTime = new Date(end_date);
        var endTime = (Date.parse(endTime)) / 1000; //replace these two lines with the unix timestamp from the server
        var now = new Date();
        var now = (Date.parse(now) / 1000);
        var timeLeft = endTime - now;
        var days = Math.floor(timeLeft / 86400);
        var hours = Math.floor((timeLeft - (days * 86400)) / 3600);
        var minutes = Math.floor((timeLeft - (days * 86400) - (hours * 3600)) / 60);
        var seconds = Math.floor((timeLeft - (days * 86400) - (hours * 3600) - (minutes * 60)));
        if (hours < "10") {
            hours = "0" + hours;
        }
        if (minutes < "10") {
            minutes = "0" + minutes;
        }
        if (seconds < "10") {
            seconds = "0" + seconds;
        }
        if (endTime < now) {
            hours = "00";
            minutes = "00";
            seconds = "00";
            days = "00";
        }

        $("#timer1 #days1").html(days);
        $("#timer1 #hours1").html(hours);
        $("#timer1 #minutes1").html(minutes);
        $("#timer1 #seconds1").html(seconds);

    }
    setInterval(function () {
        makeTimer();
    }, 1000);
    // timer end
    

    $('.form_submit').on('change', function () {
        $(this).closest('form').submit();
    });
}(jQuery));

function printDiv() {
    var printContents = document.getElementById('printArea').innerHTML;
    var originalContents = document.body.innerHTML;

    document.body.innerHTML = printContents;

    window.print();

    document.body.innerHTML = originalContents;
}
// invoice pdf create
function createPDF(order_id) {
    var element = document.getElementById('printArea');
    html2pdf(element, {
        margin: 0.5,
        padding: 0,
        filename: 'invoice' + order_id + '.pdf',
        image: { type: 'jpeg', quality: 1 },
        html2canvas: { scale: 1, logging: true },
        jsPDF: { unit: 'in', format: 'A4', orientation: 'P' },
        class: createPDF
    });
};