<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Page;
use App\Models\WidgetContent;

class PageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $pages = array(
            array('id' => '1','name' => 'Home','slug' => 'home','meta_title' => NULL,'meta_keyward' => NULL,'meta_description' => '','meta_image' => NULL,'status' => '1','enable_seo' => '2','is_bread_crumb' => '2','short_bio' => '','background_image' => NULL,'created_at' => '2025-06-15 11:48:29','updated_at' => '2025-10-07 17:33:51'),
            array('id' => '2','name' => 'About  Us','slug' => 'about-us','meta_title' => NULL,'meta_keyward' => NULL,'meta_description' => NULL,'meta_image' => NULL,'status' => '1','enable_seo' => '2','is_bread_crumb' => '2','short_bio' => NULL,'background_image' => NULL,'created_at' => '2025-06-16 05:06:23','updated_at' => '2025-06-16 05:06:23'),
            array('id' => '3','name' => 'How to Bid','slug' => 'how-to-bid','meta_title' => NULL,'meta_keyward' => NULL,'meta_description' => NULL,'meta_image' => NULL,'status' => '1','enable_seo' => '2','is_bread_crumb' => '2','short_bio' => NULL,'background_image' => NULL,'created_at' => '2025-06-16 05:55:01','updated_at' => '2025-06-16 05:55:01'),
            array('id' => '4','name' => 'Contact Us','slug' => 'contact-us','meta_title' => NULL,'meta_keyward' => NULL,'meta_description' => NULL,'meta_image' => NULL,'status' => '1','enable_seo' => '2','is_bread_crumb' => '2','short_bio' => NULL,'background_image' => NULL,'created_at' => '2025-06-17 12:49:16','updated_at' => '2025-06-17 12:49:16'),
            array('id' => '5','name' => 'How to Sell','slug' => 'how-to-sell','meta_title' => NULL,'meta_keyward' => NULL,'meta_description' => NULL,'meta_image' => NULL,'status' => '1','enable_seo' => '2','is_bread_crumb' => '2','short_bio' => NULL,'background_image' => NULL,'created_at' => '2025-06-17 15:00:17','updated_at' => '2025-06-17 15:00:17'),
            array('id' => '6','name' => 'Artists','slug' => 'artists','meta_title' => NULL,'meta_keyward' => NULL,'meta_description' => NULL,'meta_image' => NULL,'status' => '1','enable_seo' => '2','is_bread_crumb' => '2','short_bio' => NULL,'background_image' => NULL,'created_at' => '2025-06-18 08:29:20','updated_at' => '2025-06-18 08:29:20'),
            array('id' => '7','name' => 'Auction','slug' => 'auction','meta_title' => NULL,'meta_keyward' => NULL,'meta_description' => '','meta_image' => NULL,'status' => '1','enable_seo' => '2','is_bread_crumb' => '1','short_bio' => 'An art catalog is a curated assembly of artworks gathered by an individual, institution, or group, often reflecting the collector\'s interests, tastes, or a specific theme.','background_image' => NULL,'created_at' => '2025-06-23 11:16:44','updated_at' => '2025-09-10 17:40:52'),
            array('id' => '8','name' => 'General Art','slug' => 'general-art','meta_title' => NULL,'meta_keyward' => NULL,'meta_description' => '','meta_image' => NULL,'status' => '1','enable_seo' => '2','is_bread_crumb' => '1','short_bio' => 'An art catalog is a curated assembly of artworks gathered by an individual, institution, or group, often reflecting the collector\'s interests, tastes, or a specific theme.','background_image' => NULL,'created_at' => '2025-06-24 10:14:31','updated_at' => '2025-09-10 17:41:55'),
            array('id' => '9','name' => 'Support Center','slug' => 'support-center','meta_title' => NULL,'meta_keyward' => NULL,'meta_description' => NULL,'meta_image' => NULL,'status' => '1','enable_seo' => '2','is_bread_crumb' => '2','short_bio' => NULL,'background_image' => NULL,'created_at' => '2025-06-25 08:46:31','updated_at' => '2025-06-25 08:46:31'),
            array('id' => '10','name' => 'Terms & Conditions','slug' => 'terms-conditions','meta_title' => NULL,'meta_keyward' => NULL,'meta_description' => NULL,'meta_image' => NULL,'status' => '1','enable_seo' => '2','is_bread_crumb' => '2','short_bio' => NULL,'background_image' => NULL,'created_at' => '2025-06-25 08:46:43','updated_at' => '2025-06-25 08:46:43'),
            array('id' => '11','name' => 'Privacy Policy','slug' => 'privacy-policy','meta_title' => NULL,'meta_keyward' => NULL,'meta_description' => NULL,'meta_image' => NULL,'status' => '1','enable_seo' => '2','is_bread_crumb' => '2','short_bio' => NULL,'background_image' => NULL,'created_at' => '2025-06-25 08:46:53','updated_at' => '2025-06-25 08:46:53'),
            array('id' => '12','name' => 'Upcoming Auction','slug' => 'upcoming-auction','meta_title' => NULL,'meta_keyward' => NULL,'meta_description' => NULL,'meta_image' => NULL,'status' => '1','enable_seo' => '2','is_bread_crumb' => '2','short_bio' => NULL,'background_image' => NULL,'created_at' => '2025-08-11 17:45:08','updated_at' => '2025-08-11 17:45:08'),
            array('id' => '14','name' => 'Articles','slug' => 'articles','meta_title' => NULL,'meta_keyward' => NULL,'meta_description' => '','meta_image' => NULL,'status' => '1','enable_seo' => '2','is_bread_crumb' => '2','short_bio' => 'Articles about Arts','background_image' => NULL,'created_at' => '2025-08-21 19:59:45','updated_at' => '2025-09-10 17:40:04'),
        );

        if (Page::count() == 0) {
            Page::insert($pages);
        }

        $page_item = [
            array('id' => '1','page_id' => '1','widget_slug' => 'sliders','ui_card_number' => '63f136a','widget_content' => '{"title":"Art That Speaks To Your Soul","button_text":"Explore Now","button_url":"https:\\/\\/artmart-app.egenslab.com\\/auction","description":"Unlock a world of imagination with our curated collection of original artworks. From bold abstracts to serene landscapes, discover pieces that inspire, captivate.","slider":{"1":{"img":"egens-yuLZmULY1c.webp"},"2":{"img":"egens-VhWgMvdzCf.webp"},"3":{"img":"egens-t2TVEv9vzL.webp"}}}','position' => '1','status' => '1','created_at' => '2025-06-15 11:49:42','updated_at' => '2025-10-09 20:56:54'),
        ];

        if (WidgetContent::count() == 0) {
            WidgetContent::insert($page_item);
        }
    }
}
