<?php

namespace Database\Seeders;

use App\Models\EmailTemplate;
use Illuminate\Database\Seeder;

class EmailTemplateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //

        $temples = array(
            array('id' => '1','name' => 'Deposit - Customer','slug' => 'deposit','subject' => 'Deposit success','body' => '<p style="text-align:center;"><img src="/uploads/email/16871738470.png" alt="16871738470.png"><br></p>

            <p>Dear [customer_full_name],</p>

            <p>Congratulations, Your Deposit has been successfully!</p>

            <p>Thank You</p>

            <p>The [company_name] Team.</p>

            <p><br></p>
            ','status' => '1','created_at' => '2024-01-22 01:05:00','updated_at' => '2025-07-28 11:05:10'),
            array('id' => '2','name' => 'Direct Product Order - Customer','slug' => 'order_mail','subject' => 'Thank you for order','body' => '<p style="text-align: center;"><img data-filename="favicon.ico" style="width: 22px;" src="/uploads/email/16871580300.png"><br><p>Dear [customer_full_name],</p><p>Congratulations, Your Order has been successfully send!</p><p>Thank You</p><p>The [company_name] Team.</p><p></p></p>','status' => '1','created_at' => '2024-01-22 01:05:00','updated_at' => '2024-01-22 01:05:00'),
            array('id' => '3','name' => 'Password Reset','slug' => 'forgot_password','subject' => 'Reset Your Account Password','body' => '<p style="text-align:center;"><br></p>

            <p>Dear [customer_full_name],</p>

            <p>To reset your password click here [reset_password_link]</p>

            <p>Thank You</p>

            <p>The [company_name] Team.</p>
            ','status' => '1','created_at' => '2024-01-22 01:05:00','updated_at' => '2025-10-10 21:56:55'),
            array('id' => '4','name' => 'Email Verification','slug' => 'verification_email','subject' => 'Account Verification Email','body' => '<p style="text-align: center;"><img data-filename="favicon.ico" style="width: 22px;" src="/uploads/email/16871581550.png"><br><p>Dear [customer_full_name],</p><p>To verify your email please click here.</p><p>[verify_btn]</p><p>Thank You</p><p>The [company_name] Team.</p><p></p><p></p><p></p></p>','status' => '1','created_at' => '2024-01-22 01:05:00','updated_at' => '2024-01-22 01:05:00'),
            array('id' => '5','name' => 'Customer Registration','slug' => 'registration','subject' => 'Thank you for registration','body' => '<p style="text-align: center;"><img data-filename="favicon.ico" style="width: 22px;" src="/uploads/email/16871581870.png"><br><p>Dear [customer_full_name],</p><p>Congratulations, Your Account has been successfully created!</p><p>Thank You</p><p>The [company_name] Team.</p><p></p></p>','status' => '1','created_at' => '2024-01-22 01:05:00','updated_at' => '2024-01-22 01:05:00'),
            array('id' => '6','name' => 'Withdraw Approved','slug' => 'withdraw_approved','subject' => 'Withdraw success','body' => '<p>Dear [customer_full_name],</p>

            <p>Congratulations, your withdrawal request has been successfully approved! Your payment will be sent to the payment account associated with your account. </p>

            <p>Please Check</p>

            <p>Thank You</p>

            <p>The [company_name] Team.</p>

            <p><br></p>
            ','status' => '1','created_at' => '2024-01-22 01:05:00','updated_at' => '2025-09-02 12:03:46'),
            array('id' => '7','name' => 'Bidding Winner - Customer','slug' => 'bid_winner','subject' => 'Thank you for Bid Winning','body' => '<p style="text-align: center;"><img data-filename="favicon.ico" style="width: 22px;" src="/uploads/email/16871580300.png"><br><p>Dear [customer_full_name],</p><p>Congratulations!! You won the bid please confirm your final payment.</p><p>Thank You</p><p>The [company_name] Team.</p><p></p><p></p></p>','status' => '1','created_at' => '2024-01-22 01:05:00','updated_at' => '2024-01-22 01:05:00'),
            array('id' => '8','name' => 'Bidding Final Payment - Customer','slug' => 'final_payment','subject' => 'Thank you for final payment','body' => '<p style="text-align: center;"><img data-filename="favicon.ico" style="width: 22px;" src="/uploads/email/16871580300.png"><br><p>Dear [customer_full_name],</p><p>Congratulations!! Your payment is successful we will shift your product and deliver as soon as possible.</p><p>Thank You</p><p>The [company_name] Team.</p><p></p><p></p></p>','status' => '1','created_at' => '2024-01-22 01:05:00','updated_at' => '2024-01-22 01:05:00'),
            array('id' => '9','name' => 'Password Reset Confirmation','slug' => 'password_reset_confirmation','subject' => 'Thank you for Password Reset','body' => '<p style="text-align: center;"><img data-filename="favicon.ico" style="width: 22px;" src="/uploads/email/16871580300.png"><br><p>Dear [customer_full_name],</p><p>Your password has been successfully reset. Now you can login in your account.</p><p>Thank You</p><p>The [company_name] Team.</p><p></p><p></p></p>','status' => '1','created_at' => '2024-01-22 01:05:00','updated_at' => '2024-01-22 01:05:00'),
            array('id' => '10','name' => 'Merchant Registration','slug' => 'merchant_registration','subject' => 'Thank you for Registration','body' => '<p style="text-align: center;"><img data-filename="favicon.ico" style="width: 22px;" src="/uploads/email/16871580300.png"><br><p>Dear [customer_full_name],</p><p>Congratulations!! Your merchant registration is successful now you can list your product and sell to the customer.</p><p>Thank You</p><p>The [company_name] Team.</p><p></p><p></p><p></p></p>','status' => '1','created_at' => '2024-01-22 01:05:00','updated_at' => '2024-01-22 01:05:00'),
            array('id' => '11','name' => 'Bidding - Customer','slug' => 'bidding_customer','subject' => 'Thank you for Bidding','body' => '<p style="text-align: center;"><img data-filename="favicon.ico" style="width: 22px;" src="/uploads/email/16871580300.png"><br><p>Dear [customer_full_name],</p><p>Congratulations!! Your bidding is successfully placed. Stay connected for the updates.</p><p>Thank You</p><p>The [company_name] Team.</p><p></p><p></p></p>','status' => '1','created_at' => '2024-01-22 01:05:00','updated_at' => '2024-01-22 01:05:00'),
            array('id' => '12','name' => 'Bidding Payment Refund - Customer','slug' => 'bidding_payment_refund','subject' => 'Thank you for Bidding & Bidding Payment Refund','body' => '<p style="text-align: center;"><img data-filename="favicon.ico" style="width: 22px;" src="/uploads/email/16871580300.png"><br><p>Dear [customer_full_name],</p><p>Your partial bidding amount has been successfully refunded to your account wallet.&nbsp;</p><p>Thank You</p><p>The [company_name] Team.</p><p></p><p></p></p>','status' => '1','created_at' => '2024-01-22 01:05:00','updated_at' => '2024-01-22 01:05:00'),
            array('id' => '13','name' => 'Withdraw Rejected','slug' => 'withdraw_rejected','subject' => 'Your Withdraw Rejected','body' => '<p>Dear [customer_full_name],</p>

            <p>Your withdrawal request has been rejected. Please get in touch with the admin for the update.</p>

            <p>Thank You</p>

            <p>The [company_name] Team.</p>
            ','status' => '1','created_at' => '2024-01-22 01:05:00','updated_at' => '2025-09-02 12:04:44'),
            array('id' => '14','name' => 'Withdraw Requested','slug' => 'withdraw_requested','subject' => 'Thank you for Withdraw Requested','body' => '<p>Dear [customer_full_name],</p>

            <p>Your withdrawal request has been placed. Will update you regarding this soon. Stay connected </p>

            <p>Thank You</p>

            <p>The [company_name] Team.</p>
            ','status' => '1','created_at' => '2024-01-22 01:05:00','updated_at' => '2025-09-02 12:05:12'),
            array('id' => '15','name' => 'Support Ticket Reply - Merchant','slug' => 'support_ticket_reply','subject' => 'Thank you for the Support Ticket Reply','body' => '<p style="text-align: center;"><img data-filename="favicon.ico" style="width: 22px;" src="/uploads/email/16871580300.png"><br><p>Dear [customer_full_name],</p><p>Your support ticket has been successfully submitted. Soon support member will response to your support.&nbsp;</p><p>Thank You</p><p>The [company_name] Team.</p><p></p><p></p></p>','status' => '1','created_at' => '2024-01-22 01:05:00','updated_at' => '2024-01-22 01:05:00'),
            array('id' => '16','name' => 'Support Ticket - Admin','slug' => 'support_ticket','subject' => 'Thank you for the Support Ticket','body' => '<p style="text-align: center;"><img data-filename="favicon.ico" style="width: 22px;" src="/uploads/email/16871580300.png"><br><p>Dear [customer_full_name],</p><p>Your support ticket has been successfully submitted. Soon support member will response to your support.&nbsp;<br></p><p>Thank You</p><p>The [company_name] Team.</p><p></p><p></p></p>','status' => '1','created_at' => '2024-01-22 01:05:00','updated_at' => '2024-01-22 01:05:00')
            );

        if(EmailTemplate::count()==0){
            EmailTemplate::insert($temples);
          }


    }
}
