<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->string('order_number')->unique();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('artwork_id');
            $table->integer('type')->default(1)->comment('Bid=1, Purchase=2');
            $table->decimal('amount', 20, 2)->nullable();
            $table->decimal('tax_rate', 20, 2)->nullable();
            $table->integer('quantity')->nullable();
            $table->longText('message')->nullable();
            $table->integer('status')->default(1)->comment('Processing=1, Win=2, Reject=3, Completed=4, On Hold=5, Delivered=6, Refunded=7, Shipped=8');
            $table->integer('win_status')->default(1);
            $table->integer('payment_status')->default(1)->comment('Partials=1, Unpaid=2, Paid=3');
            $table->integer('view')->default(0);
            $table->timestamps();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('artwork_id')->references('id')->on('artworks')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
