<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('artworks', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('author_id');
            $table->unsignedBigInteger('artist_id');
            $table->string('name');
            $table->string('slug');
            $table->string('certificate_number')->nullable();
            $table->string('reference_number')->nullable();
            $table->string('meta_title')->nullable();
            $table->longText('meta_keyward')->nullable();
            $table->text('meta_description')->nullable();
            $table->string('meta_image')->nullable();
            $table->string('year')->nullable();
            $table->text('location')->nullable();
            $table->integer('condition')->default(1)->comment('Good=1, Bad=2, Moderate=3');
            $table->longText('content')->nullable();
            $table->text('tags')->nullable();
            $table->text('features_image')->nullable();
            $table->string('height')->nullable();
            $table->string('width')->nullable();
            $table->string('length')->nullable();
            $table->longText('specifications')->nullable();
            $table->integer('sale_type')->default(1)->comment('Action=1, Direct=2');
            $table->integer('schedule_type')->default(1)->comment('Yes=1, No=2');
            $table->string('min_deposit')->nullable();
            $table->integer('min_deposit_type')->default(1)->comment('Percent=1, Fixed=2');
            $table->integer('quantity')->default(1);
            $table->double('price', 10, 2)->nullable();
            $table->double('sale_price', 10, 2)->nullable();
            $table->double('min_bid_price', 10, 2)->nullable();
            $table->string('start_date')->nullable();
            $table->string('end_date')->nullable();
            $table->integer('status')->default(1)->comment('Published=1, Draft=2, Pending=3, Inactive=4');
            $table->integer('enable_seo')->default(2)->comment('Yes=1, No=2');
            $table->timestamps();
            $table->foreign('author_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('artist_id')->references('id')->on('artists')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('artworks');
    }
};
