<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('artist_translations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('artist_id');
            $table->string('name');
            $table->text('bio')->nullable();
            $table->string('dob')->nullable();
            $table->string('nationality')->nullable();
            $table->text('themes')->nullable();
            $table->text('biography_desc')->nullable();
            $table->longText('career_lists')->nullable();
            $table->text('awards_desc')->nullable();
            $table->longText('awards_lists')->nullable();
            $table->string('lang',50);
            $table->foreign('artist_id')->references('id')->on('artists')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('artist_translations');
    }
};
