<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable implements MustVerifyEmail
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'custom_id',
        'fname',
        'lname',
        'email',
        'phone',
        'address',
        'country_id',
        'state_id',
        'city_id',
        'zip_code',
        'password',
        'status',
        'admin_commission',
        'wallet_balance',
        'image',
        'role',
        'gallery_name',
        'email_verified_at'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }


    public function countries(){
    	return $this->belongsTo(Location::class, 'country_id');
    }

    public function states(){
    	return $this->belongsTo(Location::class, 'state_id');
    }

    public function cities(){
    	return $this->belongsTo(Location::class, 'city_id');
    }

    public function artists() {
        return $this->hasOne(Artist::class, 'user_id');
    }

    public function withdraws()
    {
        return $this->hasMany(Transaction::class, 'user_id')->where('type',4);
    }

    public function artworks()
    {
        return $this->hasMany(Artwork::class, 'author_id', 'id');
    }

    public function deposits()
    {
        return $this->hasMany(Transaction::class, 'user_id')->where('type',1);
    }

    public function bids()
    {
        return $this->hasMany(Order::class, 'user_id')->where('type',1);
    }

    public function orders()
    {
        return $this->hasMany(Order::class, 'user_id')->where('type',2);
    }

    public function wishlists()
    {
        return $this->hasMany(Wishlist::class, 'user_id');
    }
}
