<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\App;

class Page extends Model
{
    protected $guarded = [];
    
    protected $with = ['page_translations'];

    public function getTranslation($field = '', $lang = false)
    {
        $lang = $lang == false ? App::getLocale() : $lang;
        $page_translations = $this->page_translations->where('lang', $lang)->first();

        return $page_translations != null ? $page_translations->$field : $this->$field;
    }

    public function page_translations()
    {
        return $this->hasMany(PageTranslation::class);
    }

    public static function getSingleWidgets($slugName)
    {
       $singleWidgets= Widget::where(['widget_slug'=>$slugName])->first();
       return $singleWidgets;
    }

    /**
     * Get the options associated with the user.
     */
    public static function getSinglePageById($id)
    {
        $singlePage   =self::where(['id'=>$id])->first();
        return $singlePage;
    }

    public function widgetContents()  {
        return $this->hasMany(WidgetContent::class, 'page_id', 'id')->orderBy('position', 'ASC');
    }
}
