<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\App;

class MenuItem extends Model
{
    protected $guarded = [];

    protected $with = ['menu_item_translations'];

    public function getTranslation($field = '', $lang = false)
    {
        $lang = $lang == false ? App::getLocale() : $lang;
        $menu_item_translations = $this->menu_item_translations->where('lang', $lang)->first();

        return $menu_item_translations != null ? $menu_item_translations->$field : $this->$field;
    }

    public function menu_item_translations()
    {
        return $this->hasMany(MenuItemTranslation::class);
    }

    public function parent()
    {
        return $this->belongsTo(self::class, 'parent_id');
    }

    public function children()
    {
        return $this->hasMany(self::class, 'parent_id')->orderBy('order', 'asc');
    }


    public function childrens()
    {
        return $this->children()->with('childrens');
    }

    public function menus()
    {
        return $this->belongsTo(Menu::class, 'menu_id');
    }
     public function page(){
         return $this->belongsTo(Page::class, 'slug', 'slug');
     }
     public function category(){
         return $this->belongsTo(Category::class, 'slug', 'slug');
     }
     public function blog(){
         return $this->belongsTo(Blog::class, 'slug', 'slug');
     }

     public function artist(){
         return $this->belongsTo(Artist::class, 'slug', 'slug');
     }
}
