<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Mews\Purifier\Casts\CleanHtml;
use Illuminate\Support\Facades\App;

class Blog extends Model
{
    protected $guarded = [];

    protected $casts = [
        'description'  => CleanHtml::class,
    ];

    protected $with = ['blog_translations'];

    public function getTranslation($field = '', $lang = false)
    {
        $lang = $lang == false ? App::getLocale() : $lang;
        $blog_translations = $this->blog_translations->where('lang', $lang)->first();

        return $blog_translations != null ? $blog_translations->$field : $this->$field;
    }

    public function blog_translations()
    {
        return $this->hasMany(BlogTranslation::class);
    }

    public function blog_categories()
    {
        return $this->belongsTo(BlogCategory::class, 'category_id');
    }

    public function users()
    {
        return $this->belongsTo(User::class, 'user_id');
    }


  


}
