<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\App;

class Artist extends Model
{
    protected $guarded = [];
    
    protected $with = ['artist_translations'];

    public function getTranslation($field = '', $lang = false)
    {
        $lang = $lang == false ? App::getLocale() : $lang;
        $artist_translations = $this->artist_translations->where('lang', $lang)->first();

        return $artist_translations != null ? $artist_translations->$field : $this->$field;
    }

    public function artist_translations()
    {
        return $this->hasMany(ArtistTranslation::class);
    }

    public function users()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function art_works() {
        return $this->hasMany(Artwork::class, 'artist_id');
    }
}
