<?php

namespace App\Http\Services\Payment;

use Stripe\Stripe;
use Stripe\Charge;
use Stripe\Customer;

class StripeService
{
    public function charge($request, $customerInfo)
    {
        // dd($request->stripeToken);
        Stripe::setApiKey(get_payment_method('stripe_secret'));

        $mainAmount = $customerInfo['total_amount'] / (get_payment_method('stripe_conversion') ?? 1);
        $mainAmount = (int) round($mainAmount * 100); // cents

        if ($request->type == 1 || $request->type == 7) {
            return Charge::create([
                'amount' => $mainAmount,
                'currency' => 'usd',
                'source' => $request->stripeToken,
                'description' => getPaymentDetails($request->type, $customerInfo),
            ]);
        } else {
            $customer = Customer::create([
                'email' => $customerInfo['email'],
                'name' => $customerInfo['name'],
                'source' => $request->stripeToken,
            ]);

            return Charge::create([
                'amount' => $mainAmount,
                'currency' => 'usd',
                'customer' => $customer->id,
                'description' => getPaymentDetails($customerInfo['type'], $customerInfo),
                'shipping' => [
                    'name' => $customerInfo['name'],
                    'address' => [
                        'line1' => $customerInfo['address'],
                        'postal_code' => $customerInfo['post_code'],
                        'city' => 'Dhaka',
                        'state' => 'Dhaka',
                        'country' => 'Bangladesh',
                    ],
                ],
            ]);
        }
    }
}
