<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Transaction;
use App\Models\ArtGalleryPaymentInfo;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class WithdrawController extends Controller
{
        /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
{
    $page_title = translate('Withdraw List');
    $user = Auth::user();
    $search = $request->search;
    $query = Transaction::query()->where('type', 4);

    if ($user->role != 3) {
        $query->where('user_id', $user->id);
        $statsQuery = fn($status) => Transaction::where('type', 4)->where('user_id', $user->id)->where('status', $status);
    } else {
        $statsQuery = fn($status) => Transaction::where('type', 4)->where('status', $status);
    }

    if ($search) {
        $query->where(function ($q) use ($search, $user) {
            $q->orWhere('payment_method', 'like', "%$search%")
              ->orWhere('transaction_id', 'like', "%$search%")
              ->orWhere('currency', 'like', "%$search%")
              ->orWhere('amount', 'like', "%$search%");
            if (Auth::user()->role != 3) {
                $q->orWhere('user_id', $user->id);
            }
        });
    }

    $withdraws = $query->latest()->paginate(10);

    $data = [
        'total_withdraw' => $statsQuery(2)->sum('amount'),
        'pending_withdraw' => $statsQuery(1)->sum('amount'),
        'pending_withdraw_request' => $statsQuery(1)->count(),
        'paid_withdraw_request' => $statsQuery(2)->count(),
    ];

    return view('backend.withdraw.index', compact('page_title', 'withdraws', 'data'));
}


    /**
     * add new withdraw from author.
     */
    public function withdraw_new()
    {
        $page_title = translate('Withdraw Request');
        $payment_methods = ArtGalleryPaymentInfo::where('user_id', Auth::user()->id)->get();

        return view('backend.withdraw.request', compact('page_title', 'payment_methods'));
    }
    /**
     * withdraw request from author.
     */
    public function withdraw_request(Request $request)
    {
        /** Validation */
        $validator = Validator::make($request->all(), [
            'amount' => 'required|max:255',
            'payment_method' => 'required|max:255',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }


        $withdraws = Transaction::where('type', 4)->orderBy('id', 'desc')->pluck('transaction_id')->first();

        $transactions = new Transaction;
        if ($withdraws) {
            $numbers = substr($withdraws, 2);
            $transaction_id = 'WD' . str_pad(($numbers +  1), 5, '0', STR_PAD_LEFT);
            $transactions->transaction_id = $transaction_id;
        } else {
            $transactions->transaction_id = 'WD00001';
        }

        $payments = ArtGalleryPaymentInfo::findOrFail($request->payment_method);

        $transactions->user_id = Auth::user()->id;
        $transactions->payment_method = $payments?->payment_info;
        $transactions->amount = $request->amount;
        $transactions->total_amount = $request->amount;
        $transactions->currency = get_setting('default_currency_code') ?? 'USD';
        $transactions->type = 4;
        $transactions->save();
        email_send('withdraw_requested', Auth::user()->email);

        return redirect()->route('dashboard.withdraw.list')->with('success', translate('Withdraw request send successfully'));
    }

    /**
     * withdraw request details from author.
     */
    public function details($id)
    {
        $user = Auth::user();
        if ($user->role == 2) {
            return redirect()->route('dashboard.withdraw.list')->with('error', translate('This page not supported'));
        } else {
            $page_title = translate('Withdraw Details');
            $withdraw = Transaction::findOrFail($id);
            return view('backend.withdraw.details', compact('page_title', 'withdraw'));
        }
    }

    /**
     * withdraw request approved or cancel by Admin
     */
    public function status(Request $request, $id)
    {
        $withdraw = Transaction::findOrFail($id);
        if ($request->status == 1) {
            $withdraw->status = 2;
        } else {
            $withdraw->status = 3;
        }
        if ($withdraw->update()) {
            if($withdraw->status == 2){
                User::where('id', $withdraw->user_id)->decrement('wallet_balance', $withdraw->amount);
                email_send('withdraw_approved', $withdraw->users->email);
            }else{
                email_send('withdraw_rejected', $withdraw->users->email);
            }
                
        }
        

        return redirect()->route('dashboard.withdraw.list')->with('success', translate('Withdraw status changed successfully!'));
    }
}
