<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\PaymentMethod;
use App\Models\Currency;

class PaymentMethodController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'admin']);
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $methods = PaymentMethod::latest()->paginate(10);
        $page_title = translate('Payment Methods');
        $default_currency = Currency::findOrFail(get_setting('default_currency'));
        return view('backend.payment_methods.index', compact('methods', 'page_title','default_currency'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Request $request)
    {
        $payment_methods  = PaymentMethod::findOrFail($request->id);
        return Response()->json($payment_methods);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        $method_id = $request->method_id;
        $methods = PaymentMethod::findOrFail($method_id);

        /** Features image upload */
        if ($logo = $request->file('logo')) {
            if (file_exists(file_path().$methods->logo)) {
                unlink(file_path().$methods->logo);
            }
            $methods->logo = uploadImage($logo);
        }

        if (isset($request->mode)) {
            $methods->mode = $request->mode;
        } else {
            $methods->mode = 1;
        }
        $methods->key = $request->method_key;
        $methods->secret = $request->method_secret;
        $methods->currency_id = $request->currency_id;
        $methods->currency_rate = $request->currency_rate;
        $methods->update();


        return redirect()->back()->with('success', 'Payment Method updated successfully!');
    }
}
