<?php
use App\Models\Setting;
use App\Models\Translation;
use App\Models\Currency;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;
use App\Models\Artwork;
use App\Models\Artist;
use App\Models\User;
use App\Models\Blog;
use App\Models\Contact;
use App\Models\Language;
use App\Models\WidgetContent;
use App\Models\PaymentMethod;
use App\Models\BillingAddress;
use App\Models\ShippingAddress;
use App\Models\EmailTemplate;
use App\Models\Wishlist;


//highlights the selected navigation on frontend
if (!function_exists('default_language')) {
    function default_language()
    {
        return get_setting('DEFAULT_LANGUAGE', 'en');
    }
}

if (!function_exists('prelaceScript')) {

    function prelaceScript($descipt)
    {
        return preg_replace('#<script(.*?)>(.*?)</script>#is', '', $descipt);
    }
}

/**
 * active_language
 *
 * @return Response
 */

if (!function_exists('active_language')) {

    function active_language()
    {
        if(Session::has('locale')){
            $locale = Session::get('locale', Config::get('app.locale'));
        }else{
            $locale = get_setting('DEFAULT_LANGUAGE','en');
        }
        return  $locale;
    }
}

/**
 * active_language_name
 *
 * @return Response
 */

if (!function_exists('active_language_name')) {

    function active_language_name()
    {
        try{
        $name = Language::where('code',active_language())->pluck('name')->first();
        return  $name;
        }catch(Exception $e){

        }
    }
}

/**
 * Generate a setting path for the application.
 */
if (!function_exists('get_setting')) {
    function get_setting($key, $default = null)
    {

        if (alreadyInstalled() !== false) {
            $setting = Setting::where('type', $key)->first();

            return $setting == null ? $default : $setting->value;
        }

        return null;
    }
}
/**
 * paymentMethods
 *
 * @return Response
 */
if (!function_exists('paymentMethods')) {

    function paymentMethods()
    {
        return PaymentMethod::where('status', 1)->get();
    }
}
/**
 * translate
 *
 * @param  mixed $key
 * @param  mixed $lang
 * @param  mixed $addslashes
 * @return Response
 */


if (!function_exists('translate')) {

    function translate($key, $lang = null, $addslashes = false)
    {
        if (alreadyInstalled() !== false) {
            if ($lang == null) {
                $lang = App::getLocale();
            }

            $lang_key = preg_replace('/[^A-Za-z0-9\_]/', '', str_replace(' ', '_', strtolower($key)));

            $translations_default = Cache::rememberForever('translations-' . get_setting('DEFAULT_LANGUAGE', 'en'), function () {
                return Translation::where('lang', get_setting('DEFAULT_LANGUAGE', 'en'))->pluck('lang_value', 'lang_key')->toArray();
            });

            if (!isset($translations_default[$lang_key])) {
                $translation_def = new Translation;
                $translation_def->lang = get_setting('DEFAULT_LANGUAGE', 'en');
                $translation_def->lang_key = $lang_key;
                $translation_def->lang_value = $key;
                $translation_def->save();
                Cache::forget('translations-' . get_setting('DEFAULT_LANGUAGE', 'en'));
            }

            $translation_locale = Cache::rememberForever('translations-' . $lang, function () use ($lang) {
                return Translation::where('lang', $lang)->pluck('lang_value', 'lang_key')->toArray();
            });

            //Check for session lang
            if (isset($translation_locale[$lang_key])) {
                return $addslashes ? addslashes($translation_locale[$lang_key]) : $translation_locale[$lang_key];
            } elseif (isset($translations_default[$lang_key])) {
                return $translations_default[$lang_key];
            } else {
                return $key;
            }
        }
    }
}

/**
 * alreadyInstalled
 *
 * @return response
 */
if (!function_exists('alreadyInstalled')) {

    function alreadyInstalled()
    {
        return file_exists(storage_path('installed'));
    }
}

/**
 * active_language
 *
 * @return Response
 */

if (!function_exists('active_language')) {

    function active_language()
    {
        $locale = "";
        if (Session::has('locale')) {
            $locale = Session::get('locale');
        } else {
            $locale =  'en';
        }
        return  $locale;
    }
}

// Return the URL of the uploaded file, or a placeholder if not found
if (!function_exists('uploaded_asset')) {
    function uploaded_asset($file)
    {
        $filePath = public_path('uploads/files/' . $file);

        if ($file && file_exists($filePath)) {
            return asset('uploads/files/' . $file);
        }

        return asset('uploads/placeholder.jpeg');
    }
}

// Return the full server path to the uploads/files directory
if (!function_exists('file_path')) {
    function file_path()
    {
        return public_path('uploads/files/');
    }
}


    /**
 * dateFormat
 *
 * @param  mixed  $date
 * @return Response
 */
if (!function_exists('dateFormat')) {
    function dateFormat($date)
    {
        if ($date !== '') {
            $parse = Carbon::parse($date);

            return $parse->format(get_setting('date_format'));
        }

        return false;
    }
}

if (!function_exists('indexFile')) {
    function indexFile()
    {
        if (File::exists(public_path('index.php'))) {
            return true;
        };
        return false;
    }
}

/**
 * uploadImage
 *
 * @param  mixed  $date
 * @return Response
 */
if (!function_exists('uploadImage')) {
function uploadImage($image)
{
    $imageName = pathinfo($image->getClientOriginalName(), PATHINFO_FILENAME)
                    . '-' . time() . '.' . $image->getClientOriginalExtension();
    $image->move(file_path(), $imageName);
    return $imageName;
}
}

/**
 * selectedTheme
 *
 * @return Response
 */

if (!function_exists('selectedTheme')) {

    function selectedTheme()
    {
        return get_setting('theme_id') ?? 1;
    }
}

/**
 * currency_symbol
 */
if (!function_exists('currency_symbol')) {
    function currency_symbol($currency_id = null)
    {
        $currency = $currency_id ?? get_setting('default_currency');

        if ($currency) {
            $default_currency = Currency::findOrFail($currency);
            $symbol = $default_currency?->symbol;

            return $symbol;
        }

        return false;
    }
}

/**
 * default Currency
 */
if (!function_exists('default_currency_code')) {
    function default_currency_code($currency_id = null)
    {
        $currency = $currency_id ?? get_setting('default_currency');

        if ($currency) {
            $default_currency = Currency::findOrFail($currency);
            $code = $default_currency?->code;

            return $code;
        }

        return false;
    }
}
/**
 * format_currency
 */
if (!function_exists('format_currency')) {
function format_currency($amount, $symbol = null, $decimals = 2)
{
    // Get currency symbol if not provided
        $symbol = $symbol ?? currency_symbol();

        // Ensure the amount is numeric
        $amount = is_numeric($amount) ? (float) $amount : 0;

        return $symbol . number_format($amount, $decimals);
}
}
/**
 * format_number
 */
if (!function_exists('format_number')) {
    function format_number($number)
    {
        // Remove commas and trim whitespace
        $number = str_replace(',', '', trim($number));

        // Ensure it's numeric
        if (!is_numeric($number)) {
            return [
                'number' => 0,
                'suffix' => ''
            ];
        }

        $number = (float) $number;

        if ($number >= 1_000_000_000) {
            return [
                'number' => round($number / 1_000_000_000, 1),
                'suffix' => 'B'
            ];
        } elseif ($number >= 1_000_000) {
            return [
                'number' => round($number / 1_000_000, 1),
                'suffix' => 'M'
            ];
        } elseif ($number >= 1_000) {
            return [
                'number' => round($number / 1_000, 1),
                'suffix' => 'K'
            ];
        }

        return [
            'number' => $number,
            'suffix' => ''
        ];
    }
}

/**
 * Artworks
 */
if (!function_exists('artworks')) {
    function artworks($type = 1, $limit = null, $per_page = null, $order_by = 'desc')
    {
        $query = Artwork::where('status', 1)->orderBy('id', $order_by);

        if ($type !== 'all') {
            if ($type === 'upcoming') {
                $query->where('sale_type', 1)->where('start_date', '>=', now());
            }elseif($type == 1) {
                $query->where('sale_type', 1)->where('start_date', '<=', now());
            }else{
                $query->where('sale_type', $type);
            }
        }

        if ($limit) {
            return $query->limit($limit)->get();
        }

        if ($per_page) {
            return $query->paginate($per_page);
        }

        return $query->get();
    }
}

/**
 * Featured Artists
 */
if (!function_exists('featured_artists')) {
    function featured_artists($limit = null, $per_page = null, $order_by = 'desc')
    {
        $query = Artist::where('status', 1)->where('isFeatured',1)->orderBy('id', $order_by);

        if ($limit) {
            return $query->limit($limit)->get();
        }

        if ($per_page) {
            return $query->paginate($per_page);
        }

        return $query->get();
    }
}

/**
 * Artists
 */
if (!function_exists('artists')) {
    function artists($limit = null, $per_page = null, $order_by = 'desc')
    {
        $query = Artist::where('status', 1)->orderBy('id', $order_by);

        if ($limit) {
            return $query->limit($limit)->get();
        }

        if ($per_page) {
            return $query->paginate($per_page);
        }

        return $query->get();
    }
}

/**
 * getWidgetContent
 *
 * @param  mixed  $pageId
 * @param  mixed  $widgetName
 * @return Response
 */
if (!function_exists('getWidgetContent')) {

    function getWidgetContent($pageId, $widgetName)
    {
        return WidgetContent::where(['page_id' => $pageId, 'widget_slug' => $widgetName])->first();
    }
}

/**
 * Blogs
 */
if (!function_exists('blogs')) {
    function blogs($limit = null, $per_page = null, $order_by = 'desc')
    {
        $query = Blog::where('status', 1)->orderBy('id', $order_by);

        if ($limit) {
            return $query->limit($limit)->get();
        }

        if ($per_page) {
            return $query->paginate($per_page);
        }

        return $query->get();
    }
}

// contact unread
if (!function_exists('contact_unread')) {
    function contact_unread()
    {   $contacts = Contact::where('isRead',2)->count();
        return $contacts;
    }
}

// menu item title
function menuItemTitle($menu_item) {
    switch ($menu_item->menu_type) {
        case 'page':
            return $menu_item?->page?->getTranslation('name') ?? $menu_item->getTranslation('title');
        case 'category':
            return $menu_item->category?->getTranslation('name') ?? $menu_item->getTranslation('title');
        case 'blog':
            return $menu_item?->blog?->getTranslation('title') ?? $menu_item->getTranslation('title');
        case 'artist':
            return $menu_item?->artist?->getTranslation('name') ?? $menu_item->getTranslation('title');
        default:
            return Str::limit($menu_item->getTranslation('title'), 25);
    }
}
// menu item URL
function menuItemUrl($menu_item) {
    switch ($menu_item->menu_type) {
        case 'page':
            return $menu_item->slug == 'home' ? url('/') : url($menu_item->slug);
        case 'custom':
            return $menu_item->target;
        case 'category':
            return url('category/' . $menu_item->slug);
        case 'blog':
            return url('blog/' . $menu_item->slug);
        case 'artist':
            return url('artists/' . $menu_item->slug);
        default:
            return '#';
    }
}
// menu item target
function menuItemTarget($menu_item) {
    if ($menu_item->menu_type == 'custom' && $menu_item->new_tap == 1) {
        return '_blank';
    }
    return '';
}

/**
 * Generate a payment method path for the application.
 */
if (!function_exists('get_payment_method')) {
    function get_payment_method($key)
    {
        $method = explode('_', $key);
        $payment_method = PaymentMethod::where('slug', $method[0])->first();
        if ($payment_method) {
            if ($method[1] == 'mode') {
                return $payment_method->mode == 2 ? false : true;
            } elseif ($method[1] == 'key') {
                return $payment_method->key;
            } elseif ($method[1] == 'secret') {
                return $payment_method->secret;
            } elseif ($method[1] == 'conversion') {
                return $payment_method->currency_rate;
            }
        } else {
            return null;
        }
    }
}
/**
 * message of payment.
 */
if (!function_exists('getPaymentDetails')) {
function getPaymentDetails($type, $customerInfo = NULL)
    {
        switch ($type) {
            case 1:
                return 'Deposit to Wallet';
            case 2:
                return 'Bid Initial Payment';
            case 3:

                $artwork = Artwork::find($customerInfo['artwork_id']);
                return 'Purchase - ' . ($artwork->name ?? '');
            case 4:
                return 'Withdraw from Wallet';
            case 7:
                return 'Bid Final Payment';
            default:
                return 'Payment';
        }
    }
}

/**
 * Custom ID generation for users based on their role.
 */
if (!function_exists('generate_custom_id')) {
    function generate_custom_id($role)
{
    // Define prefix based on role
    $prefix = $role == 1 ? 'C' : 'AG';

    // Get the last custom_id with that prefix
    $lastId = User::where('role', $role)
        ->where('custom_id', 'like', $prefix . '%')
        ->latest('id')
        ->pluck('custom_id')
        ->first();

    // Extract the numeric part and increment
    if ($lastId) {
        $number = (int) substr($lastId, strlen($prefix));
        $next = str_pad($number + 1, 4, '0', STR_PAD_LEFT);
    } else {
        $next = '0001';
    }

    return $prefix . $next;
}
}

/**
 * Address generation for orders.
 */
if (!function_exists('generate_address')) {
    function generate_address($orderId, $request)
{
    $user = Auth::user();
    $address = new Address();
    $address->order_id = $orderId;
    $address->name = $request->input('name') ?? $user->fname.' ' .$user->lname;
    $address->email = $request->input('email') ?? $user->email;
    $address->phone = $request->input('phone') ?? $user->phone;
    $address->address = $request->input('address') ?? $user->address;
    $address->post_code = $request->input('post_code') ?? $user->zip_code;
    $address->save();

    return $address;
}
}

/**
 * Bid Minimum Deposit generation for orders.
 */
if (!function_exists('bid_minimum_deposit')) {
    function bid_minimum_deposit($amount, $min_deposit, $type = 1)
{
    if($type == 1) {
        $deposit = $amount * ($min_deposit / 100);
    }else{
        $deposit = $min_deposit;
    }

    return $deposit;
}
}

if (!function_exists('email_send')) {
    function email_send($templateSlug, $emailTo = null, $token = null)
    {
        $template = EmailTemplate::where('slug', $templateSlug)->first();
        if (!$template) return back()->with('error', __('Email Template not found'));

        $user = Auth::user() ?? User::where('email', $emailTo)->first();
        if (!$user || !$emailTo) return back()->with('error', __('User Email not found'));

        $shortcodes = [
            'company_name' => get_setting('company_name') ?? 'Bidout',
            'reset_password_link' => $token ? '<a href="' . url("/password/reset/$token?email=$emailTo") . '" class="eg-btn btn--primary back-btn">Reset Password</a>' : '',
        ];

        $prefix = $user->role == 2 ? 'artgallery' : 'customer';
        foreach (['fname', 'lname', 'email', 'phone', 'address', 'zip_code'] as $field) {
            $shortcodes["{$prefix}_{$field}"] = $user->$field ?? '';
        }

        $shortcodes["{$prefix}_full_name"] = trim(($user->fname ?? '') . ' ' . ($user->lname ?? ''));
        $shortcodes["{$prefix}_country"] = $user->countries?->name ?? '';
        $shortcodes["{$prefix}_state"] = $user->states?->name ?? '';
        $shortcodes["{$prefix}_city"] = $user->cities?->name ?? '';

        $body = str_replace(
            array_map(fn($k) => "[$k]", array_keys($shortcodes)),
            array_values($shortcodes),
            $template->body
        );

        try {
            Mail::send('backend.email_template.email_body', ['body' => $body], function ($msg) use ($emailTo, $user, $template) {
                $name = trim(($user->fname ?? '') . ' ' . ($user->lname ?? ''));
                $msg->to($emailTo, $name)->subject($template->subject);
            });
            return 'success';
        } catch (\Throwable $th) {
            return back()->with('error', __('Mail sending failed'));
        }
    }
}

/**
 * wishlist_count
 *
 */

if (!function_exists('wishlist_count')) {

    function wishlist_count()
    {
        if(Auth::check()){
            $count = Wishlist::where('user_id', Auth::user()->id)->count();
        }else{
            $count = 0;
        }

        return $count;
    }
}

